/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository;

import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.service.internal.repository.CustomExecutionDao;

public interface ExecutionDao
extends JpaRepository<Execution, Long>,
CustomExecutionDao {
    public static final String EXECUTION_ID = "executionId";

    @Query
    public List<ExecutionStep> findSteps(@Param(value="executionId") long var1);

    @Query
    public List<ActionTestStep> findOriginalSteps(@Param(value="executionId") long var1);

    @Query
    public List<Long> findOriginalStepIds(@Param(value="executionIds") List<Long> var1);

    @Query
    public long countStatus(@Param(value="execId") long var1, @Param(value="status") ExecutionStatus var3);

    @Query
    public List<Long> findExecutionIdsHavingStepStatus(@Param(value="projectId") Long var1, @Param(value="status") ExecutionStatus var2);

    @Modifying
    @Query(name="ExecutionStep.replaceStatus")
    public void replaceExecutionStepStatus(@Param(value="projectId") long var1, @Param(value="oldStatus") ExecutionStatus var3, @Param(value="newStatus") ExecutionStatus var4);

    @Modifying
    @Query(name="IterationTestPlanItem.replaceStatus")
    public void replaceTestPlanStatus(@Param(value="projectId") long var1, @Param(value="oldStatus") ExecutionStatus var3, @Param(value="newStatus") ExecutionStatus var4);

    @Query
    public long countSteps(@Param(value="executionId") long var1);

    @Query
    public long countByTestCaseId(@Param(value="testCaseId") long var1);

    @Query(value="select execution from Execution execution join execution.testPlan testPlan join testPlan.iteration iteration join iteration.campaign campaign join campaign.project project left join testPlan.testSuites testSuites left join execution.issues issues where execution.referencedTestCase.id = :testCaseId group by execution.id, execution.testPlan.id, iteration.id, campaign.id, campaign.name, project.id")
    public Page<Execution> findAllByReferencedTestCaseId(@Param(value="testCaseId") long var1, Pageable var3);

    @Query(value="select step from ExecutionStep step join fetch step.referencedTestStep testStep join fetch testStep.testCase where step.execution.id = :id")
    public List<ExecutionStep> findStepsWithReferencedStepAndTestCase(@Param(value="id") Long var1);
}

