/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.query;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import org.squashtest.tm.domain.library.structures.LibraryTree;
import org.squashtest.tm.domain.library.structures.TreeNode;
import org.squashtest.tm.service.internal.query.InternalEntityType;
import org.squashtest.tm.service.internal.query.InternalQueryModel;
import org.squashtest.tm.service.internal.query.PlannedJoin;

class QueryPlan
extends LibraryTree<InternalEntityType, TraversedEntity> {
    QueryPlan() {
    }

    TraversedEntity getRoot() {
        return (TraversedEntity)((Object)this.getRootNodes().get(0));
    }

    void addNode(InternalEntityType parentKey, TraversedEntity childNode, PlannedJoin joinMeta) {
        this.addNode((Object)parentKey, childNode);
        TraversedEntity parent = (TraversedEntity)this.getNode((Object)parentKey);
        parent.addJoinInfo((InternalEntityType)((Object)childNode.getKey()), joinMeta);
    }

    public Iterator<PlannedJoin> joinIterator() {
        return new QueryPlanJoinIterator(this);
    }

    void trim(InternalQueryModel definition) {
        Set<InternalEntityType> targets = definition.getTargetEntities();
        LinkedList<TraversedEntity> fifo = new LinkedList<TraversedEntity>(this.getLeaves());
        while (!fifo.isEmpty()) {
            InternalEntityType curType;
            TraversedEntity current = (TraversedEntity)((Object)fifo.remove());
            if (current == null || targets.contains((Object)(curType = (InternalEntityType)((Object)current.getKey()))) || !current.getChildren().isEmpty()) continue;
            TraversedEntity parent = (TraversedEntity)current.getParent();
            if (!fifo.contains((Object)parent)) {
                fifo.add(parent);
            }
            this.remove((Object)curType);
        }
    }

    private static final class QueryPlanJoinIterator
    implements Iterator<PlannedJoin> {
        private QueryPlan plan;
        private Queue<TraversedEntity> toProcess = new LinkedList<TraversedEntity>();
        private TraversedEntity currentParent = null;
        private TraversedEntity currentChild = null;
        private Queue<TraversedEntity> remainingChildren = new LinkedList<TraversedEntity>();
        private boolean hasNext = false;

        QueryPlanJoinIterator(QueryPlan plan) {
            this.plan = plan;
            this.toProcess.add(plan.getRoot());
            this.armNext();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public PlannedJoin next() {
            if (this.hasNext()) {
                PlannedJoin res = this.currentParent.getJoinInfo((InternalEntityType)((Object)this.currentChild.getKey()));
                this.armNext();
                return res;
            }
            throw new NoSuchElementException("no more joins to see");
        }

        private void armNext() {
            while (this.remainingChildren.isEmpty() && !this.toProcess.isEmpty()) {
                this.currentParent = this.toProcess.remove();
                this.remainingChildren.addAll(this.currentParent.getChildren());
            }
            boolean bl = this.hasNext = !this.remainingChildren.isEmpty();
            if (this.hasNext) {
                this.currentChild = this.remainingChildren.remove();
                this.toProcess.add(this.currentChild);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("don't do that");
        }

        public QueryPlan getPlan() {
            return this.plan;
        }

        public void setPlan(QueryPlan plan) {
            this.plan = plan;
        }

        public Queue<TraversedEntity> getToProcess() {
            return this.toProcess;
        }

        public void setToProcess(Queue<TraversedEntity> toProcess) {
            this.toProcess = toProcess;
        }

        public Queue<TraversedEntity> getRemainingChildren() {
            return this.remainingChildren;
        }

        public void setRemainingChildren(Queue<TraversedEntity> remainingChildren) {
            this.remainingChildren = remainingChildren;
        }
    }

    static final class TraversedEntity
    extends TreeNode<InternalEntityType, TraversedEntity> {
        private final Map<InternalEntityType, PlannedJoin> joinInfos = new HashMap<InternalEntityType, PlannedJoin>();

        TraversedEntity(InternalEntityType type) {
            super((Object)type);
        }

        protected void updateWith(TraversedEntity newData) {
        }

        public String toString() {
            return ((InternalEntityType)((Object)this.getKey())).toString();
        }

        void addJoinInfo(InternalEntityType outboundType, PlannedJoin joininfo) {
            this.joinInfos.put(outboundType, joininfo);
        }

        void removeJoinInfo(InternalEntityType outboundType) {
            this.joinInfos.remove((Object)outboundType);
        }

        PlannedJoin getJoinInfo(InternalEntityType outboundType) {
            return this.joinInfos.get((Object)outboundType);
        }
    }
}

