/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.projectimporter.pivotimporter.parsers;

import com.fasterxml.jackson.core.JsonParser;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.library.NewFolderDto;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.service.internal.dto.projectimporter.FolderToImport;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.parsers.AttachmentParserHelper;
import org.squashtest.tm.service.projectimporter.pivotimporter.PivotJsonParsingHelper;
import org.squashtest.tm.service.projectimporter.pivotimporter.parsers.FolderParser;

@Service(value="FolderParser")
public class FolderParserImpl
implements FolderParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(FolderParserImpl.class);

    @Override
    public FolderToImport parseFolder(JsonParser jsonParser, JsonImportFile jsonFile, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        FolderToImport folderToImport = new FolderToImport();
        NewFolderDto newFolderDto = new NewFolderDto();
        try {
            while (PivotJsonParsingHelper.isNotTheEndOfParsedObject(jsonParser)) {
                String fieldName = jsonParser.getCurrentName();
                jsonParser.nextToken();
                switch (fieldName) {
                    case "id": {
                        folderToImport.setInternalId(jsonParser.getText());
                        break;
                    }
                    case "name": {
                        newFolderDto.setName(jsonParser.getText());
                        break;
                    }
                    case "description": {
                        newFolderDto.setDescription(jsonParser.getText());
                        break;
                    }
                    case "custom_fields": {
                        newFolderDto.setCustomFields(PivotJsonParsingHelper.getCustomFieldValues(jsonParser, pivotImportMetadata.getCustomFieldIdsMap()));
                        break;
                    }
                    case "parent_type": {
                        folderToImport.setParentType(EntityType.valueOf((String)jsonParser.getText()));
                        break;
                    }
                    case "parent_id": {
                        folderToImport.setParentId(jsonParser.getText());
                        break;
                    }
                    case "attachments": {
                        folderToImport.setAttachments(AttachmentParserHelper.parseAttachments(jsonParser));
                        break;
                    }
                }
                PivotFormatLoggerHelper.logParsingSuccessForEntity(LOGGER, PivotFormatLoggerHelper.getFolderEntityKindNameFromJsonFile(jsonFile, false), newFolderDto.getName(), folderToImport.getInternalId(), pivotFormatImport);
            }
            folderToImport.setFolder(newFolderDto);
        }
        catch (Exception e) {
            PivotFormatLoggerHelper.handleParsingErrorForEntity(LOGGER, PivotFormatLoggerHelper.getFolderEntityKindNameFromJsonFile(jsonFile, false), folderToImport.getInternalId(), pivotFormatImport, e);
        }
        return folderToImport;
    }
}

