/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.projectimporter.pivotimporter.parsers;

import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.service.internal.dto.CustomFieldFormModel;
import org.squashtest.tm.service.internal.dto.projectimporter.CustomFieldToImport;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.parsers.CufOption;
import org.squashtest.tm.service.projectimporter.pivotimporter.PivotJsonParsingHelper;
import org.squashtest.tm.service.projectimporter.pivotimporter.parsers.CustomFieldParser;

@Service(value="CustomFieldParser")
public class CustomFieldParserImpl
implements CustomFieldParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomFieldParserImpl.class);

    @Override
    public CustomFieldToImport parseCustomField(JsonParser jsonParser, PivotFormatImport pivotFormatImport) {
        CustomFieldToImport customFieldToImport = new CustomFieldToImport();
        CustomFieldFormModel cufFormModel = new CustomFieldFormModel();
        ArrayList<BindableEntity> boundEntities = new ArrayList<BindableEntity>();
        try {
            while (PivotJsonParsingHelper.isNotTheEndOfParsedObject(jsonParser)) {
                String fieldName = jsonParser.getCurrentName();
                jsonParser.nextToken();
                switch (fieldName) {
                    case "id": {
                        customFieldToImport.setInternalId(jsonParser.getText());
                        break;
                    }
                    case "input_type": {
                        cufFormModel.setInputType(InputType.valueOf((String)jsonParser.getText()));
                        break;
                    }
                    case "name": {
                        cufFormModel.setName(jsonParser.getText());
                        break;
                    }
                    case "label": {
                        cufFormModel.setLabel(jsonParser.getText());
                        break;
                    }
                    case "code": {
                        cufFormModel.setCode(jsonParser.getText());
                        break;
                    }
                    case "default_value": {
                        String cufValue = jsonParser.getValueAsString();
                        cufFormModel.setDefaultValue(Objects.nonNull(cufValue) ? cufValue : "");
                        break;
                    }
                    case "optional": {
                        cufFormModel.setOptional(jsonParser.getBooleanValue());
                        break;
                    }
                    case "options": {
                        this.handleCustomFieldOptions(jsonParser, cufFormModel);
                        break;
                    }
                    case "bound_entities": {
                        this.handleBoundEntities(jsonParser, boundEntities);
                        break;
                    }
                }
                PivotFormatLoggerHelper.logParsingSuccessForEntity(LOGGER, "custom field", cufFormModel.getName(), customFieldToImport.getInternalId(), pivotFormatImport);
            }
        }
        catch (Exception e) {
            PivotFormatLoggerHelper.handleParsingErrorForEntity(LOGGER, "custom field", customFieldToImport.getInternalId(), pivotFormatImport, e);
        }
        CustomField customField = cufFormModel.getCustomField();
        customFieldToImport.setCustomField(customField);
        customFieldToImport.setBoundEntities(boundEntities);
        return customFieldToImport;
    }

    private void handleCustomFieldOptions(JsonParser jsonParser, CustomFieldFormModel cufFormModel) throws IOException {
        List<CufOption> cufOptions = new ArrayList<CufOption>();
        if (PivotJsonParsingHelper.isStartingToParseNewArray(jsonParser)) {
            cufOptions = CustomFieldParserImpl.parseCufOptions(jsonParser);
        }
        cufFormModel.setOptions(CustomFieldParserImpl.convertCufOptionsToListOfArrays(cufOptions));
    }

    private static List<CufOption> parseCufOptions(JsonParser jsonParser) throws IOException {
        ArrayList<CufOption> optionsList = new ArrayList<CufOption>();
        while (PivotJsonParsingHelper.isNotTheEndOfParsedArray(jsonParser)) {
            if (!PivotJsonParsingHelper.isStartingToParseNewObject(jsonParser)) continue;
            optionsList.add(CustomFieldParserImpl.parseCufOption(jsonParser));
        }
        return optionsList;
    }

    private static CufOption parseCufOption(JsonParser jsonParser) throws IOException {
        String name = null;
        String code = null;
        String color = null;
        while (PivotJsonParsingHelper.isNotTheEndOfParsedObject(jsonParser)) {
            String fieldName = jsonParser.getCurrentName();
            jsonParser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = jsonParser.getValueAsString();
                    break;
                }
                case "code": {
                    code = jsonParser.getValueAsString();
                    break;
                }
                case "color": {
                    color = jsonParser.getValueAsString();
                    break;
                }
            }
        }
        return new CufOption(name, code, color);
    }

    private static String[][] convertCufOptionsToListOfArrays(List<CufOption> options) {
        String[][] result = new String[options.size()][3];
        int i = 0;
        while (i < options.size()) {
            CufOption option = options.get(i);
            result[i][0] = option.name();
            result[i][1] = option.code();
            result[i][2] = option.color();
            ++i;
        }
        return result;
    }

    private void handleBoundEntities(JsonParser jsonParser, List<BindableEntity> boundEntities) throws IOException {
        if ("bound_entities".equals(jsonParser.getCurrentName())) {
            while (PivotJsonParsingHelper.isNotTheEndOfParsedArray(jsonParser)) {
                boundEntities.add(BindableEntity.valueOf((String)jsonParser.getText()));
            }
        }
    }
}

