/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.projectimporter.pivotimporter;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.concurrent.DelegatingSecurityContextRunnable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.domain.projectimporter.PivotFormatImportStatus;
import org.squashtest.tm.service.internal.projectimporter.concurrency.SynchronisedSectionWrapper;
import org.squashtest.tm.service.projectimporter.pivotimporter.GlobalProjectPivotImporterService;

@Service(value="ProjectPivotImportTaskScheduler")
public class ProjectPivotImportTaskScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectPivotImportTaskScheduler.class);
    private static final int DEFAULT_DELAY = 3600;
    private static final int MIN_DELAY = 30;
    public static final String PIVOT_FORMAT_IMPORT_USER = "project.importer";
    private static final String PENDING_IMPORTS_QUERY = "SELECT p FROM PivotFormatImport p left join fetch p.project WHERE p.status = :status";
    @Named(value="squashtest.tm.service.ThreadPoolTaskScheduler")
    private final TaskScheduler taskScheduler;
    private final SynchronisedSectionWrapper synchronisedSectionWrapper;
    private final Environment environment;
    private final GlobalProjectPivotImporterService globalProjectPivotImporterService;
    @PersistenceContext
    private EntityManager entityManager;

    public ProjectPivotImportTaskScheduler(TaskScheduler taskScheduler, SynchronisedSectionWrapper synchronisedSectionWrapper, Environment environment, GlobalProjectPivotImporterService globalProjectPivotImporterService) {
        this.taskScheduler = taskScheduler;
        this.synchronisedSectionWrapper = synchronisedSectionWrapper;
        this.environment = environment;
        this.globalProjectPivotImporterService = globalProjectPivotImporterService;
    }

    @PostConstruct
    public void handlePendingPivotFormatImports() {
        this.taskScheduler.scheduleWithFixedDelay(this.executePivotFormatImportTask(), (long)this.getDelay());
    }

    private int getDelay() {
        String property = this.environment.getProperty("squash.project-imports.delay");
        int delay = 3600;
        if (StringUtils.isNotBlank((CharSequence)property)) {
            try {
                delay = Integer.parseInt(property);
                delay = Math.max(delay, 30);
                LOGGER.info("Found the property 'squash.project-imports.delay'. Delay between each import phases will be  : " + delay + " seconds.", new Object[0]);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Impossible to parse the property 'squash.project-imports.delay' as a number. Please provide a valid synchronisation delay.", new Object[0]);
                throw e;
            }
        }
        return delay *= 1000;
    }

    private Runnable executePivotFormatImportTask() {
        return new DelegatingSecurityContextRunnable(this.synchronisedSectionWrapper.wrapAsSynchronisedSection(this.performPivotFormatImport()));
    }

    private Runnable performPivotFormatImport() {
        return () -> {
            try {
                this.performCronAuthentication();
                List<PivotFormatImport> pendingImports = this.fetchPendingImports();
                for (PivotFormatImport pendingImport : pendingImports) {
                    if (Objects.nonNull(pendingImport.getProject())) {
                        this.globalProjectPivotImporterService.importInExistingProject(pendingImport);
                        continue;
                    }
                    this.globalProjectPivotImporterService.importProject(pendingImport);
                }
            }
            finally {
                SecurityContextHolder.clearContext();
            }
        };
    }

    private List<PivotFormatImport> fetchPendingImports() {
        return this.entityManager.createQuery(PENDING_IMPORTS_QUERY, PivotFormatImport.class).setParameter("status", (Object)PivotFormatImportStatus.PENDING).getResultList();
    }

    private void performCronAuthentication() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Performing internal authentication for project import...", new Object[0]);
        }
        SecurityContextHolder.clearContext();
        AnonymousAuthenticationToken authentication = new AnonymousAuthenticationToken(PIVOT_FORMAT_IMPORT_USER, (Object)PIVOT_FORMAT_IMPORT_USER, Collections.singletonList(new SimpleGrantedAuthority("ROLE_ADMIN")));
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Project importer - Authenticated as {}", new Object[]{PIVOT_FORMAT_IMPORT_USER});
        }
    }
}

