/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.projectimporter.pivotimporter;

import java.util.Objects;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.exception.pivotformatimport.CouldNotCreateEntityDuringImportException;
import org.squashtest.tm.exception.pivotformatimport.CouldNotParseEntityDuringImportException;
import org.squashtest.tm.exception.pivotformatimport.PivotImportAttachmentMaxSizeExceededException;
import org.squashtest.tm.exception.pivotformatimport.PivotImportAttachmentTypeNotAllowedException;
import org.squashtest.tm.service.internal.dto.projectimporter.ImportWarningEntry;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.AttachmentHolderInfo;

public final class PivotFormatLoggerHelper {
    public static final String CALLED_TEST_CASE = "called test case";
    public static final String CALLED_TEST_CASES = "called test cases";
    public static final String CAMPAIGN = "campaign";
    public static final String CAMPAIGNS = "campaigns";
    public static final String CAMPAIGN_FOLDER = "campaign folder";
    public static final String CAMPAIGN_FOLDERS = "campaign folders";
    public static final String CUSTOM_FIELD = "custom field";
    public static final String CUSTOM_FIELDS = "custom fields";
    public static final String EXECUTION = "execution";
    public static final String EXECUTION_STEP_INSIDE_EXECUTION = "an execution step inside execution";
    public static final String EXECUTIONS = "executions";
    public static final String ITERATION = "iteration";
    public static final String ITERATIONS = "iterations";
    public static final String REQUIREMENT = "requirement";
    public static final String REQUIREMENTS = "requirements";
    public static final String REQUIREMENT_FOLDER = "requirement folder";
    public static final String REQUIREMENT_FOLDERS = "requirement folders";
    public static final String TEST_CASE = "test case";
    public static final String TEST_CASES = "test cases";
    public static final String TEST_CASE_FOLDER = "test case folder";
    public static final String TEST_CASE_FOLDERS = "test case folders";
    public static final String TEST_STEP = "test step";
    public static final String TEST_SUITE = "test suite";
    public static final String TEST_SUITES = "test suites";

    private PivotFormatLoggerHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static void logImportStartedForEntitiesKind(Logger logger, String zipFileName, String entitiesKind, PivotFormatImport pivotFormatImport) {
        logger.info("Starting to import {} from zip archive \"{}\" for import with id: {}", new Object[]{entitiesKind, zipFileName, pivotFormatImport.getId()});
    }

    public static void logImportSuccessForEntitiesKind(Logger logger, String entitiesKind, PivotFormatImport pivotFormatImport) {
        logger.info("Import id: {} - Successfully imported {} from json file", new Object[]{pivotFormatImport.getId(), entitiesKind});
    }

    public static void logImportFailureForEntitiesKind(Logger logger, String entitiesKind, PivotFormatImport pivotFormatImport) {
        logger.error("Import id: {} - Failed to import {} from json file", new Object[]{pivotFormatImport.getId(), entitiesKind});
    }

    public static void logParsingSuccessForEntity(Logger logger, String entityKind, String entityName, String internalId, PivotFormatImport pivotFormatImport) {
        logger.debug("Import id {} - The {} with name \"{}\" and internal id {} was successfully parsed", new Object[]{pivotFormatImport.getId(), entityKind, entityName, internalId});
    }

    public static void logParsingSuccessForUnnamedEntity(Logger logger, String entityKind, String internalId, PivotFormatImport pivotFormatImport) {
        logger.debug("Import id {} - The {} and internal id {} was successfully parsed", new Object[]{pivotFormatImport.getId(), entityKind, internalId});
    }

    public static void handleParsingErrorForEntity(Logger logger, String entityKind, String internalId, PivotFormatImport pivotFormatImport, Exception e) {
        String message = Objects.nonNull(internalId) ? String.format("Import id: %s - Failed to parse %s with internal id : %s", pivotFormatImport.getId(), entityKind, internalId) : String.format("Import id: %s - Failed to parse %s.", pivotFormatImport.getId(), entityKind);
        logger.error(message, new Object[0]);
        throw new CouldNotParseEntityDuringImportException(message, (Throwable)e);
    }

    public static void logEntityCreationStarted(Logger logger, String entityKind, String internalId, PivotFormatImport pivotFormatImport) {
        logger.info("Import id: {} - Creating {} with internal id {}", new Object[]{pivotFormatImport.getId(), entityKind, internalId});
    }

    public static void logEntityCreatedSuccessfully(Logger logger, String entityKind, String entityName, String internalId, PivotFormatImport pivotFormatImport) {
        logger.info("Import id: {} - Successfully created {} named \"{}\" with internal id {}", new Object[]{pivotFormatImport.getId(), entityKind, entityName, internalId});
    }

    public static void logUnnamedEntityCreatedSuccessfully(Logger logger, String entityKind, String internalId, PivotFormatImport pivotFormatImport) {
        logger.info("Import id: {} - Successfully created {} with internal id {}", new Object[]{pivotFormatImport.getId(), entityKind, internalId});
    }

    public static void handleEntityCreationFailed(Logger logger, String entityKind, String entityName, String internalId, PivotFormatImport pivotFormatImport, Exception e) {
        String message = String.format("Import id: %s - Failed to create %s named \"%s\" with internal id %s", pivotFormatImport.getId(), entityKind, entityName, internalId);
        logger.error(message, new Object[0]);
        throw new CouldNotCreateEntityDuringImportException(message, (Throwable)e);
    }

    public static void handleUnnamedEntityCreationFailed(Logger logger, String entityKind, String internalId, PivotFormatImport pivotFormatImport, Exception e) {
        String message = String.format("Import id: %s - Failed to create %s with internal id %s", pivotFormatImport.getId(), entityKind, internalId);
        logger.error(message, new Object[0]);
        throw new CouldNotCreateEntityDuringImportException(message, (Throwable)e);
    }

    public static String getFolderEntityKindNameFromJsonFile(JsonImportFile jsonFileName, boolean isPlural) {
        String entityKindName = "";
        switch (jsonFileName) {
            case TEST_CASE_FOLDERS: {
                entityKindName = isPlural ? TEST_CASE_FOLDERS : TEST_CASE_FOLDER;
                break;
            }
            case REQUIREMENT_FOLDERS: {
                entityKindName = isPlural ? REQUIREMENT_FOLDERS : REQUIREMENT_FOLDER;
                break;
            }
            case CAMPAIGN_FOLDERS: {
                entityKindName = isPlural ? CAMPAIGN_FOLDERS : CAMPAIGN_FOLDER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown json import file name: " + (Object)((Object)jsonFileName));
            }
        }
        return entityKindName;
    }

    public static void handleAttachmentNotFound(Logger logger, String attachmentPath, AttachmentHolderInfo holderInfo, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        String message = String.format("Import %s - Could not find attachment for %s with internal ID %s at the following path: %s ", pivotFormatImport.getId(), PivotFormatLoggerHelper.findEntityLabelByHolderType(holderInfo), holderInfo.internalHolderId(), attachmentPath);
        logger.error(message, new Object[0]);
        pivotImportMetadata.getImportWarningEntries().add(new ImportWarningEntry(holderInfo.holderType(), message));
    }

    public static void handleAttachmentTypeNotAllowed(Logger logger, String fileType, String fileName, AttachmentHolderInfo holderInfo, PivotFormatImport pivotFormatImport) {
        String message = String.format("Import %s - Could not add attachment for %s with internal ID %s. The extension \"%s\" of file \"%s\" is not allowed for attachment import.", pivotFormatImport.getId(), PivotFormatLoggerHelper.findEntityLabelByHolderType(holderInfo), holderInfo.internalHolderId(), fileType, fileName);
        logger.error(message, new Object[0]);
        throw new PivotImportAttachmentTypeNotAllowedException(message);
    }

    public static void handleAttachmentMaxSizeExceeded(Logger logger, String fileName, Long fileSize, Long maxAllowedSize, AttachmentHolderInfo holderInfo, PivotFormatImport pivotFormatImport) {
        String message = String.format("Import %s - Could not add attachment for %s with internal ID %s. The attachment \"%s\" has exceeded size limit (Max allowed size: %s bytes). File size: %s bytes", pivotFormatImport.getId(), PivotFormatLoggerHelper.findEntityLabelByHolderType(holderInfo), holderInfo.internalHolderId(), fileName, maxAllowedSize, fileSize);
        logger.error(message, new Object[0]);
        throw new PivotImportAttachmentMaxSizeExceededException(message);
    }

    private static String findEntityLabelByHolderType(AttachmentHolderInfo holderInfo) {
        return switch (holderInfo.holderType()) {
            case EntityType.TEST_CASE_FOLDER -> TEST_CASE_FOLDER;
            case EntityType.TEST_CASE -> TEST_CASE;
            case EntityType.ACTION_TEST_STEP -> TEST_STEP;
            case EntityType.REQUIREMENT_FOLDER -> REQUIREMENT_FOLDER;
            case EntityType.REQUIREMENT -> REQUIREMENT;
            case EntityType.CAMPAIGN_FOLDER -> CAMPAIGN_FOLDER;
            case EntityType.CAMPAIGN -> CAMPAIGN;
            case EntityType.ITERATION -> ITERATION;
            case EntityType.TEST_SUITE -> TEST_SUITE;
            case EntityType.EXECUTION -> EXECUTION;
            case EntityType.EXECUTION_STEP -> EXECUTION_STEP_INSIDE_EXECUTION;
            default -> throw new IllegalArgumentException("Unknown attachment holder type: " + holderInfo.holderType());
        };
    }
}

