/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.milestone;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneHolder;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.audit.AuditModificationService;
import org.squashtest.tm.service.internal.repository.CampaignDao;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.internal.repository.loaders.testcase.TestCaseLoader;
import org.squashtest.tm.service.milestone.MilestoneMembershipManager;

@Service(value="squashtest.tm.service.MilestoneMembershipManager")
public class MilestoneMembershipManagerImpl
implements MilestoneMembershipManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MilestoneMembershipManagerImpl.class);
    @Inject
    private TestCaseLoader testCaseLoader;
    @Inject
    private RequirementVersionDao requirementVersionDao;
    @Inject
    private CampaignDao campaignDao;
    @Inject
    private MilestoneDao milestoneDao;
    @Inject
    private AuditModificationService auditModificationService;

    @Override
    public void bindTestCaseToMilestones(long testCaseId, Collection<Long> milestoneIds) {
        TestCase tc = (TestCase)this.testCaseLoader.load(testCaseId, EnumSet.of(TestCaseLoader.Options.FETCH_MILESTONES));
        List milestones = this.milestoneDao.findAllById(milestoneIds);
        for (Milestone m : milestones) {
            tc.bindMilestone(m);
        }
        LOGGER.debug("Milestone binding: updating auditable test case {}", new Object[]{testCaseId});
        this.auditModificationService.updateAuditable((AuditableMixin)tc);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'WRITE') or hasRole('ROLE_ADMIN')")
    public void unbindTestCaseFromMilestones(long testCaseId, Collection<Long> milestoneIds) {
        TestCase tc = (TestCase)this.testCaseLoader.load(testCaseId, EnumSet.of(TestCaseLoader.Options.FETCH_MILESTONES));
        for (Long milestoneId : milestoneIds) {
            tc.unbindMilestone(milestoneId);
        }
        LOGGER.debug("Milestone unbinding: updating auditable test case {}", new Object[]{testCaseId});
        this.auditModificationService.updateAuditable((AuditableMixin)tc);
    }

    @Override
    public void bindRequirementVersionToMilestones(long requirementVersionId, Collection<Long> milestoneIds) {
        RequirementVersion version = (RequirementVersion)this.requirementVersionDao.getReferenceById(requirementVersionId);
        List milestones = this.milestoneDao.findAllById(milestoneIds);
        for (Milestone m : milestones) {
            if (m.isOneVersionAlreadyBound(version)) continue;
            version.bindMilestone(m);
        }
        LOGGER.debug("Milestone binding: updating auditable requirement version {}", new Object[]{requirementVersionId});
        this.auditModificationService.updateAuditable((AuditableMixin)version);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion', 'WRITE') or hasRole('ROLE_ADMIN')")
    public void unbindRequirementVersionFromMilestones(long requirementVersionId, Collection<Long> milestoneIds) {
        RequirementVersion version = (RequirementVersion)this.requirementVersionDao.getReferenceById(requirementVersionId);
        for (Long milestoneId : milestoneIds) {
            version.unbindMilestone(milestoneId);
        }
        LOGGER.debug("Milestone unbinding: updating auditable requirement version {}", new Object[]{requirementVersionId});
        this.auditModificationService.updateAuditable((AuditableMixin)version);
    }

    @Override
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign' , 'WRITE') or hasRole('ROLE_ADMIN')")
    public void bindCampaignToMilestone(long campaignId, Long milestoneId) {
        if (milestoneId != null) {
            Campaign campaign = (Campaign)this.campaignDao.findById(campaignId);
            Milestone milestone = (Milestone)this.milestoneDao.getReferenceById(milestoneId);
            campaign.bindMilestone(milestone);
            LOGGER.debug("Milestone binding: updating auditable campaign {}", new Object[]{campaignId});
            this.auditModificationService.updateAuditable((AuditableMixin)campaign);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Campaign.class)
    public void unbindCampaignFromMilestones(@Id long campaignId, Collection<Long> milestoneIds) {
        this.unbindCampaignFromMilestonesUnsecured(campaignId, milestoneIds);
    }

    @Override
    @CheckBlockingMilestone(entityType=Campaign.class)
    public void unbindCampaignFromMilestonesUnsecured(@Id long campaignId, Collection<Long> milestoneIds) {
        Campaign campaign = (Campaign)this.campaignDao.findById(campaignId);
        if (campaign != null) {
            for (Long milestoneId : milestoneIds) {
                campaign.unbindMilestone(milestoneId);
            }
            LOGGER.debug("Milestone unbinding: updating auditable campaign {}", new Object[]{campaignId});
            this.auditModificationService.updateAuditable((AuditableMixin)campaign);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign' , 'WRITE') or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=Campaign.class)
    public void unbindCampaignFromSingleMilestone(@Id long campaignId, Long milestoneId) {
        Campaign campaign = (Campaign)this.campaignDao.findById(campaignId);
        campaign.unbindMilestone(milestoneId);
        LOGGER.debug("Milestone unbinding: updating auditable campaign {}", new Object[]{campaignId});
        this.auditModificationService.updateAuditable((AuditableMixin)campaign);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')")
    public Collection<Milestone> findAllMilestonesForTestCase(long testCaseId) {
        return this.milestoneDao.findAllMilestonesForTestCase(testCaseId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')")
    public boolean isTestCaseMilestoneDeletable(long testCaseId) {
        return this.milestoneDao.isTestCaseMilestoneDeletable(testCaseId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')")
    public boolean isTestCaseMilestoneModifiable(long testCaseId) {
        return this.milestoneDao.isTestCaseMilestoneModifiable(testCaseId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testCaseId, 'org.squashtest.tm.domain.testcase.TestCase' , 'READ') or hasRole('ROLE_ADMIN')")
    public Collection<Milestone> findAssociableMilestonesToTestCase(long testCaseId) {
        return this.milestoneDao.findAssociableMilestonesForTestCase(testCaseId);
    }

    @Override
    public Collection<Milestone> findAllMilestonesForUser(long userId) {
        return this.milestoneDao.findAssociableMilestonesForUser(userId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#requirementVersionId, 'org.squashtest.tm.domain.requirement.RequirementVersion' , 'READ') or hasRole('ROLE_ADMIN')")
    public Collection<Milestone> findAssociableMilestonesToRequirementVersion(long requirementVersionId) {
        return this.milestoneDao.findAssociableMilestonesForRequirementVersion(requirementVersionId);
    }

    @Override
    public Collection<Milestone> findMilestonesForRequirementVersion(long requirementVersionId) {
        return this.milestoneDao.findMilestonesForRequirementVersion(requirementVersionId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign' , 'READ') or hasRole('ROLE_ADMIN')")
    public Collection<Milestone> findAssociableMilestonesToCampaign(long campaignId) {
        return this.milestoneDao.findAssociableMilestonesForCampaign(campaignId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign' , 'READ') or hasRole('ROLE_ADMIN')")
    public Collection<Milestone> findMilestonesForCampaign(long campaignId) {
        return this.milestoneDao.findMilestonesForCampaign(campaignId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration' , 'READ') or hasRole('ROLE_ADMIN')")
    public Collection<Milestone> findMilestonesForIteration(long iterationId) {
        return this.milestoneDao.findMilestonesForIteration(iterationId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testSuiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'READ') or hasRole('ROLE_ADMIN')")
    public Collection<Milestone> findMilestonesForTestSuite(long testSuiteId) {
        return this.milestoneDao.findMilestonesForTestSuite(testSuiteId);
    }

    @Override
    public Collection<Campaign> findCampaignsByMilestoneId(long milestoneId) {
        return this.milestoneDao.findCampaignsForMilestone(milestoneId);
    }

    @Override
    public boolean isMilestoneBoundToACampainInProjects(Long milestoneId, List<Long> projectIds) {
        return this.milestoneDao.isMilestoneBoundToACampainInProjects(milestoneId, projectIds);
    }

    @Override
    public List<Long> findTestCaseIdsBoundToBlockingMilestone(Collection<Long> testCaseIds) {
        return this.milestoneDao.findTestCaseIdsBoundToBlockingMilestone(testCaseIds);
    }

    @Override
    public <T extends MilestoneHolder> void bindHoldersToMilestones(Map<T, List<Long>> holdersMilestoneIds) {
        if (holdersMilestoneIds.isEmpty()) {
            return;
        }
        Set milestoneIds = holdersMilestoneIds.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Map<Long, Milestone> milestoneById = this.milestoneDao.findAllById(milestoneIds).stream().collect(Collectors.toMap(Milestone::getId, milestone -> milestone));
        if (milestoneById.isEmpty()) {
            return;
        }
        holdersMilestoneIds.forEach((holder, holderMilestoneIds) -> holderMilestoneIds.stream().map(milestoneById::get).filter(Objects::nonNull).forEach(arg_0 -> ((MilestoneHolder)holder).bindMilestone(arg_0)));
    }
}

