/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.milestone;

import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.milestone.MilestoneFinderService;

@Component
public class ActiveMilestoneHolderImpl
implements ActiveMilestoneHolder {
    @Inject
    private MilestoneFinderService milestoneFinderService;
    private final ThreadLocal<Optional<Milestone>> activeMilestoneHolder = ThreadLocal.withInitial(Optional::empty);
    private final ThreadLocal<Long> activeMilestoneIdHolder = new ThreadLocal();

    @Override
    public Optional<Milestone> getActiveMilestone() {
        if (this.activeMilestoneHolder.get().isEmpty()) {
            Long milestoneId = this.activeMilestoneIdHolder.get();
            List<Long> milestoneIds = this.milestoneFinderService.findAllIdsVisibleToCurrentUser();
            Milestone milestone = null;
            if (milestoneIds.contains(milestoneId)) {
                milestone = this.milestoneFinderService.findById(milestoneId);
            }
            this.activeMilestoneHolder.set(Optional.ofNullable(milestone));
        }
        return this.activeMilestoneHolder.get();
    }

    @Override
    public void setActiveMilestone(Long milestoneId) {
        this.activeMilestoneIdHolder.set(milestoneId);
    }

    @Override
    public void clearContext() {
        this.activeMilestoneHolder.remove();
        this.activeMilestoneIdHolder.remove();
    }

    @Override
    public Optional<Long> getActiveMilestoneId() {
        return Optional.ofNullable(this.activeMilestoneIdHolder.get());
    }
}

