/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import java.security.Key;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.crypto.SecretKey;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.users.ApiToken;
import org.squashtest.tm.domain.users.ApiTokenPermission;
import org.squashtest.tm.service.RestApiJwtSecretKeyManager;
import org.squashtest.tm.service.internal.repository.ApiTokenDao;
import org.squashtest.tm.service.jwt.JwtTokenService;

@Service
public class JwtTokenServiceImpl
implements JwtTokenService {
    public static final String INVALID_TOKEN = "Invalid token";
    @Inject
    private ApiTokenDao apiTokenDao;

    @Override
    public String generateJwt(String userId, String uuid, Date expiryDate, Date createdOn, String permission, String jwtSecret) {
        SecretKey key = RestApiJwtSecretKeyManager.getRestApiJwtSecretKey(jwtSecret);
        return Jwts.builder().subject(userId).claim("uuid", (Object)uuid).claim("permissions", (Object)permission).issuedAt(createdOn).expiration(expiryDate).signWith((Key)key, (SecureDigestAlgorithm)Jwts.SIG.HS512).compact();
    }

    @Override
    public String getUserIdFromToken(String token, String jwtSecret) {
        SecretKey key = RestApiJwtSecretKeyManager.getRestApiJwtSecretKey(jwtSecret);
        return ((Claims)Jwts.parser().verifyWith(key).build().parseSignedClaims((CharSequence)token).getPayload()).getSubject();
    }

    @Override
    public boolean validateApiToken(List<String> permissionsExemptions, String token, String jwtSecret, HttpServletRequest request) {
        SecretKey key = RestApiJwtSecretKeyManager.getRestApiJwtSecretKey(jwtSecret);
        try {
            boolean isMethodAllowed;
            Claims payload = (Claims)Jwts.parser().verifyWith(key).build().parseSignedClaims((CharSequence)token).getPayload();
            String jwtPermissions = (String)payload.get("permissions", String.class);
            String jwtUuid = (String)payload.get("uuid", String.class);
            String jwtUserId = payload.getSubject();
            if (jwtPermissions == null || jwtUuid == null || jwtUserId == null) {
                throw new BadCredentialsException(INVALID_TOKEN);
            }
            Optional<ApiToken> potentialApiToken = this.apiTokenDao.findByUuid(jwtUuid);
            ApiToken squashApiToken = this.throwNotExistOrSetLastUsage(potentialApiToken);
            if (!JwtTokenServiceImpl.isTokenValid(squashApiToken, jwtPermissions, payload.getExpiration(), jwtUserId)) {
                throw new BadCredentialsException(INVALID_TOKEN);
            }
            boolean shouldByPassPermission = permissionsExemptions.stream().anyMatch(endpoint -> request.getServletPath().endsWith((String)endpoint));
            boolean bl = isMethodAllowed = shouldByPassPermission || ApiTokenPermission.valueOf((String)jwtPermissions).getAllowedMethods().contains(request.getMethod());
            if (!isMethodAllowed) {
                throw new BadCredentialsException(INVALID_TOKEN);
            }
            return true;
        }
        catch (JwtException | IllegalArgumentException ex) {
            throw new BadCredentialsException(INVALID_TOKEN, ex);
        }
    }

    private ApiToken throwNotExistOrSetLastUsage(Optional<ApiToken> potentialApiToken) {
        if (potentialApiToken.isEmpty()) {
            throw new BadCredentialsException(INVALID_TOKEN);
        }
        ApiToken squashApiToken = potentialApiToken.get();
        squashApiToken.setLastUsage(new Date());
        this.apiTokenDao.saveAndFlush(squashApiToken);
        return squashApiToken;
    }

    private static boolean isTokenValid(ApiToken apiToken, String jwtPermissions, Date jwtExpiryDate, String jwtUserId) {
        Instant instant = jwtExpiryDate.toInstant();
        LocalDateTime jwtExpiryDateUtc = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        String jwtExpiryDateUtcString = jwtExpiryDateUtc.format(DateTimeFormatter.ISO_DATE);
        return Objects.equals(apiToken.getPermissions(), jwtPermissions) && Objects.equals(apiToken.getExpiryDate(), jwtExpiryDateUtcString) && Objects.equals(apiToken.getUser().getId().toString(), jwtUserId) && new Date().before(jwtExpiryDate);
    }
}

