/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.projectimporterxray.model;

import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.AbstractGenericItem;

public class XrayImportModel {
    private String pivotFileName;
    private String pivotLogFileName;
    private final List<EntityCount> entityCounts = new ArrayList<EntityCount>();

    public String getPivotFileName() {
        return this.pivotFileName;
    }

    public void setPivotFileName(String pivotFileName) {
        this.pivotFileName = pivotFileName;
    }

    public String getPivotLogFileName() {
        return this.pivotLogFileName;
    }

    public void setPivotLogFileName(String pivotLogFileName) {
        this.pivotLogFileName = pivotLogFileName;
    }

    public List<EntityCount> getEntityCounts() {
        return this.entityCounts;
    }

    public static class EntityCount {
        private String i18nKey;
        private int entitySuccesses = 0;
        private int entityWarnings = 0;
        private int entityFailures = 0;

        public EntityCount(EntityType entityType) {
            this.i18nKey = entityType.getI18nKey();
        }

        public String getI18nKey() {
            return this.i18nKey;
        }

        public void setI18nKey(String i18nKey) {
            this.i18nKey = i18nKey;
        }

        public int getEntitySuccesses() {
            return this.entitySuccesses;
        }

        public int getEntityWarnings() {
            return this.entityWarnings;
        }

        public int getEntityFailures() {
            return this.entityFailures;
        }

        public <T extends AbstractGenericItem> void countEntity(T item) {
            switch (item.getItemStatus()) {
                case SUCCESS: {
                    ++this.entitySuccesses;
                    break;
                }
                case WARNING: {
                    ++this.entityWarnings;
                    break;
                }
                default: {
                    ++this.entityFailures;
                }
            }
        }
    }

    public static enum EntityType {
        TEST_CASE("sqtm-core.administration-workspace.views.project.import.dialog.import-from-xray.label.generate-pivot.test-case"),
        CALLED_TEST_CASE("sqtm-core.administration-workspace.views.project.import.dialog.import-from-xray.label.generate-pivot.call-test-case"),
        CAMPAIGN("sqtm-core.administration-workspace.views.project.import.dialog.import-from-xray.label.generate-pivot.campaign"),
        ITERATION("sqtm-core.administration-workspace.views.project.import.dialog.import-from-xray.label.generate-pivot.iteration");

        private final String i18nKey;

        private EntityType(String i18nKey) {
            this.i18nKey = i18nKey;
        }

        public String getI18nKey() {
            return this.i18nKey;
        }
    }
}

