/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.sprintgroup;

import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.service.display.sprintgroup.SprintGroupDisplayService;
import org.squashtest.tm.service.internal.display.dto.AttachmentListDto;
import org.squashtest.tm.service.internal.display.dto.sprintgroup.SprintGroupDto;
import org.squashtest.tm.service.internal.library.EntityPathHeaderService;
import org.squashtest.tm.service.internal.repository.display.AttachmentDisplayDao;
import org.squashtest.tm.service.internal.repository.display.SprintGroupDisplayDao;

@Service
@Transactional(readOnly=true)
public class SprintGroupDisplayServiceImpl
implements SprintGroupDisplayService {
    private final SprintGroupDisplayDao sprintGroupDisplayDao;
    private final AttachmentDisplayDao attachmentDisplayDao;
    private final EntityPathHeaderService entityPathHeaderService;

    public SprintGroupDisplayServiceImpl(SprintGroupDisplayDao sprintGroupDisplayDao, AttachmentDisplayDao attachmentDisplayDao, EntityPathHeaderService entityPathHeaderService) {
        this.sprintGroupDisplayDao = sprintGroupDisplayDao;
        this.attachmentDisplayDao = attachmentDisplayDao;
        this.entityPathHeaderService = entityPathHeaderService;
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintGroupId, 'org.squashtest.tm.domain.campaign.SprintGroup' ,'READ')  or hasRole('ROLE_ADMIN')")
    public SprintGroupDto getSprintGroupView(long sprintGroupId) {
        SprintGroupDto sprintGroupDto = this.sprintGroupDisplayDao.getSprintGroupDtoById(sprintGroupId);
        AttachmentListDto attachmentList = this.attachmentDisplayDao.findAttachmentListById(sprintGroupDto.getAttachmentListId());
        sprintGroupDto.setAttachmentList(attachmentList);
        String path = this.entityPathHeaderService.buildCLNPathHeader(sprintGroupId);
        sprintGroupDto.setPath(path);
        return sprintGroupDto;
    }
}

