/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.sprint;

import java.util.Collections;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.requirement.ManagementMode;
import org.squashtest.tm.domain.synchronisation.SynchronisationKind;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.Project;
import org.squashtest.tm.service.campaign.SprintTestPlanItemManagerService;
import org.squashtest.tm.service.display.sprint.SprintDisplayService;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.SprintKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.SprintReqVersionKnownIssueFinder;
import org.squashtest.tm.service.internal.display.campaign.ReadUnassignedTestPlanHelper;
import org.squashtest.tm.service.internal.display.dto.AttachmentListDto;
import org.squashtest.tm.service.internal.display.dto.UserView;
import org.squashtest.tm.service.internal.display.dto.sprint.AvailableTestPlanItemDto;
import org.squashtest.tm.service.internal.display.dto.sprint.AvailableTestPlanItemIdsDto;
import org.squashtest.tm.service.internal.display.dto.sprint.SprintDto;
import org.squashtest.tm.service.internal.display.dto.sprint.SprintReqVersionDto;
import org.squashtest.tm.service.internal.display.dto.sprint.SprintReqVersionView;
import org.squashtest.tm.service.internal.library.EntityPathHeaderService;
import org.squashtest.tm.service.internal.repository.display.AttachmentDisplayDao;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;

@Service
@Transactional(readOnly=true)
public class SprintDisplayServiceImpl
implements SprintDisplayService {
    private final SprintDisplayDao sprintDisplayDao;
    private final AttachmentDisplayDao attachmentDisplayDao;
    private final EntityPathHeaderService entityPathHeaderService;
    private final DSLContext dslContext;
    private final PermissionEvaluationService permissionEvaluationService;
    private final SprintReqVersionKnownIssueFinder sprintReqVersionKnownIssueFinder;
    private final SprintKnownIssueFinder sprintKnownIssueFinder;
    private final SprintTestPlanItemManagerService sprintTestPlanItemManagerService;
    private final ReadUnassignedTestPlanHelper readUnassignedTestPlanHelper;

    public SprintDisplayServiceImpl(SprintDisplayDao sprintDisplayDao, AttachmentDisplayDao attachmentDisplayDao, EntityPathHeaderService entityPathHeaderService, DSLContext dslContext, PermissionEvaluationService permissionEvaluationService, SprintReqVersionKnownIssueFinder sprintReqVersionKnownIssueFinder, SprintKnownIssueFinder sprintKnownIssueFinder, SprintTestPlanItemManagerService sprintTestPlanItemManagerService, ReadUnassignedTestPlanHelper readUnassignedTestPlanHelper) {
        this.sprintDisplayDao = sprintDisplayDao;
        this.entityPathHeaderService = entityPathHeaderService;
        this.attachmentDisplayDao = attachmentDisplayDao;
        this.dslContext = dslContext;
        this.permissionEvaluationService = permissionEvaluationService;
        this.sprintReqVersionKnownIssueFinder = sprintReqVersionKnownIssueFinder;
        this.sprintKnownIssueFinder = sprintKnownIssueFinder;
        this.sprintTestPlanItemManagerService = sprintTestPlanItemManagerService;
        this.readUnassignedTestPlanHelper = readUnassignedTestPlanHelper;
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint' ,'READ')  or hasRole('ROLE_ADMIN')")
    public SprintDto getSprintView(long sprintId) {
        SprintDto sprintDto = this.sprintDisplayDao.getSprintDtoById(sprintId);
        if (SynchronisationKind.XSQUASH4JIRA.getName().equals(sprintDto.getSynchronisationKind())) {
            this.translateJiraRemoteStateIntoSquashStatus(sprintDto);
        }
        AttachmentListDto attachmentList = this.attachmentDisplayDao.findAttachmentListById(sprintDto.getAttachmentListId());
        sprintDto.setAttachmentList(attachmentList);
        String path = this.entityPathHeaderService.buildCLNPathHeader(sprintId);
        sprintDto.setPath(path);
        List<SprintReqVersionDto> sprintReqVersions = this.findSprintReqVersionDtosBySprintId(sprintId);
        sprintDto.setSprintReqVersions(sprintReqVersions);
        int nbIssues = this.sprintKnownIssueFinder.countKnownIssues(sprintId);
        sprintDto.setNbIssues(nbIssues);
        sprintDto.setNbTestPlanItems(this.countTestPlanItems(sprintId));
        sprintDto.setAssignableUsers(UserView.fromEntities(this.sprintTestPlanItemManagerService.findAssignableUsersByCampaignLibraryId(sprintDto.getCampaignLibraryId())));
        return sprintDto;
    }

    private void translateJiraRemoteStateIntoSquashStatus(SprintDto sprintDto) {
        SprintStatus remoteState = sprintDto.getRemoteState();
        if (remoteState == SprintStatus.FUTURE) {
            sprintDto.setRemoteState(SprintStatus.UPCOMING);
        } else if (remoteState == SprintStatus.ACTIVE) {
            sprintDto.setRemoteState(SprintStatus.OPEN);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint' ,'READ')  or hasRole('ROLE_ADMIN')")
    public List<SprintReqVersionDto> findSprintReqVersionDtosBySprintId(long sprintId) {
        Project requirementVersionProject = Tables.PROJECT.as("REQUIREMENT_VERSION_PROJECT");
        Field reqVersionProjectId = requirementVersionProject.field("PROJECT_ID");
        Field reqVersionProjectName = requirementVersionProject.field("NAME");
        org.squashtest.tm.jooq.domain.tables.SprintReqVersion sprintReqVersion = Tables.SPRINT_REQ_VERSION.as("SPRINT_REQ_VERSION_ALIAS");
        return this.dslContext.select((SelectField)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.as("ID"), (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME"), (SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)reqVersionProjectId.as("REQUIREMENT_VERSION_PROJECT_ID"), (SelectField)reqVersionProjectName.as("REQUIREMENT_VERSION_PROJECT_NAME"), (SelectField)this.getReferenceBasedOnReqVersionId().as("REFERENCE"), (SelectField)this.getNameBasedOnReqVersionId().as("NAME"), this.getCategoryBasedOnReqVersionId().as("CATEGORY_ID"), (SelectField)this.getCategoryLabelIfSprintNotClosed().as("CATEGORY_LABEL"), (SelectField)this.getDescriptionBasedOnReqVersionId().as("DESCRIPTION"), (SelectField)this.getCriticalityBasedOnReqVersionId().as("CRITICALITY"), (SelectField)this.getStatusBasedOnReqVersionId().as("STATUS"), (SelectField)Tables.REQUIREMENT_VERSION.RES_ID.as("VERSION_ID"), (SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.as("REQUIREMENT_ID"), (SelectField)Tables.SPRINT_REQ_VERSION.SPRINT_ID, (SelectField)Tables.SPRINT_REQ_VERSION.MODE, (SelectField)Tables.SPRINT_REQ_VERSION.VALIDATION_STATUS, (SelectField)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_PERIMETER_STATUS, (SelectField)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_URL, (SelectField)this.getRemoteReqStatusAndState().as("REMOTE_REQ_STATUS_AND_STATE"), (SelectField)DSL.selectCount().from((TableLike)Tables.EXECUTION).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).join((TableLike)sprintReqVersion).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)sprintReqVersion.TEST_PLAN_ID)).where(sprintReqVersion.SPRINT_REQ_VERSION_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID)).asField("NB_EXECUTIONS"), (SelectField)DSL.selectCount().from((TableLike)Tables.TEST_PLAN_ITEM).join((TableLike)Tables.TEST_PLAN).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN.TEST_PLAN_ID)).join((TableLike)sprintReqVersion).on(Tables.TEST_PLAN.TEST_PLAN_ID.eq((Field)sprintReqVersion.TEST_PLAN_ID)).where(sprintReqVersion.SPRINT_REQ_VERSION_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID)).asField("NB_TESTS")).from((TableLike)Tables.SPRINT_REQ_VERSION).leftJoin((TableLike)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER).on(Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.eq((Field)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.SPRINT_REQ_VERSION_ID)).leftJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID)).leftJoin((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).leftJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.PROJECT).on(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).leftJoin((TableLike)requirementVersionProject).on(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq(reqVersionProjectId)).leftJoin((TableLike)Tables.SPRINT).on(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Field)Tables.SPRINT.CLN_ID)).where(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Object)sprintId)).orderBy((OrderField)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID).fetchInto(SprintReqVersionDto.class);
    }

    private int countTestPlanItems(long sprintId) {
        String userToRestrictTo = this.readUnassignedTestPlanHelper.getUserToRestrictTo(sprintId, Sprint.class.getName());
        return this.sprintDisplayDao.countTestPlanItems(sprintId, userToRestrictTo);
    }

    @Override
    public List<SprintReqVersionDto> findSprintReqVersionDtosForDenormalization(long sprintId) {
        return this.dslContext.select((SelectField)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.as("ID"), (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE.as("REFERENCE"), (SelectField)Tables.RESOURCE.NAME.as("NAME"), (SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS.as("STATUS"), (SelectField)Tables.REQUIREMENT_VERSION.CRITICALITY.as("CRITICALITY"), (SelectField)this.getCategoryLabelforDenormalization().as("CATEGORY_LABEL"), (SelectField)Tables.RESOURCE.DESCRIPTION.as("DESCRIPTION")).from((TableLike)Tables.SPRINT_REQ_VERSION).leftJoin((TableLike)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER).on(Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.eq((Field)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.SPRINT_REQ_VERSION_ID)).leftJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID)).leftJoin((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).where(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Object)sprintId)).and(Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID.isNotNull()).and(Tables.SPRINT_REQ_VERSION.MODE.eq((Object)ManagementMode.NATIVE.toString())).fetchInto(SprintReqVersionDto.class);
    }

    private Field<String> getCategoryLabelforDenormalization() {
        return this.dslContext.select((SelectField)Tables.INFO_LIST_ITEM.LABEL).from((TableLike)Tables.INFO_LIST_ITEM).where(Tables.INFO_LIST_ITEM.ITEM_ID.eq((Select)this.dslContext.select((SelectField)Tables.REQUIREMENT_VERSION.CATEGORY))).asField();
    }

    private Field<String> getCategoryLabelIfSprintNotClosed() {
        return DSL.when((Condition)this.shouldNotDisplayReqVersionData(), (Field)Tables.SPRINT_REQ_VERSION.CATEGORY);
    }

    private SelectField<Long> getCategoryBasedOnReqVersionId() {
        return DSL.when((Condition)DSL.not((Condition)this.shouldNotDisplayReqVersionData()), (Field)Tables.REQUIREMENT_VERSION.CATEGORY);
    }

    private Field<String> getReferenceBasedOnReqVersionId() {
        return DSL.when((Condition)this.shouldNotDisplayReqVersionData(), (Field)Tables.SPRINT_REQ_VERSION.REFERENCE).otherwise((Field)Tables.REQUIREMENT_VERSION.REFERENCE);
    }

    private Field<String> getNameBasedOnReqVersionId() {
        return DSL.when((Condition)this.shouldNotDisplayReqVersionData(), (Field)Tables.SPRINT_REQ_VERSION.NAME).otherwise((Field)Tables.RESOURCE.NAME);
    }

    private Field<String> getCriticalityBasedOnReqVersionId() {
        return DSL.when((Condition)this.shouldNotDisplayReqVersionData(), (Field)Tables.SPRINT_REQ_VERSION.CRITICALITY).otherwise((Field)Tables.REQUIREMENT_VERSION.CRITICALITY);
    }

    private Field<String> getStatusBasedOnReqVersionId() {
        return DSL.when((Condition)this.shouldNotDisplayReqVersionData(), (Field)Tables.SPRINT_REQ_VERSION.STATUS).otherwise((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS);
    }

    private Field<String> getRemoteReqStatusAndState() {
        return DSL.when((Condition)Tables.SPRINT_REQ_VERSION.STATUS.isNull().or(Tables.SPRINT_REQ_VERSION.STATUS.eq((Object)"")), (Field)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_STATE).otherwise(DSL.when((Condition)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_STATE.isNull(), (Field)Tables.SPRINT_REQ_VERSION.STATUS).otherwise(Tables.SPRINT_REQ_VERSION.STATUS.concat(new Field[]{DSL.inline((String)", "), Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_STATE})));
    }

    private Field<String> getDescriptionBasedOnReqVersionId() {
        return DSL.when((Condition)this.shouldNotDisplayReqVersionData(), (Field)Tables.SPRINT_REQ_VERSION.DESCRIPTION).otherwise((Field)Tables.RESOURCE.DESCRIPTION);
    }

    private Condition shouldNotDisplayReqVersionData() {
        return Tables.SPRINT_REQ_VERSION.MODE.eq((Object)ManagementMode.SYNCHRONIZED.name()).or(Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID.isNull()).or(Tables.SPRINT_REQ_VERSION.MODE.eq((Object)ManagementMode.NATIVE.name()).and(Tables.SPRINT.STATUS.eq((Object)SprintStatus.CLOSED.name())));
    }

    @Override
    public SprintReqVersionView findSprintReqVersionViewById(long sprintReqVersionId) {
        SprintReqVersionView sprintReqVersionDto = (SprintReqVersionView)this.dslContext.select(new SelectFieldOrAsterisk[]{Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.as("ID"), Tables.PROJECT.NAME.as("PROJECT_NAME"), Tables.PROJECT.PROJECT_ID, Tables.PROJECT.CL_ID.as("CAMPAIGN_LIBRARY_ID"), this.getReferenceBasedOnReqVersionId().as("REFERENCE"), this.getNameBasedOnReqVersionId().as("NAME"), Tables.REQUIREMENT_VERSION.CATEGORY.as("CATEGORY_ID"), Tables.SPRINT_REQ_VERSION.CATEGORY.as("CATEGORY_LABEL"), this.getCriticalityBasedOnReqVersionId().as("CRITICALITY"), this.getStatusBasedOnReqVersionId().as("STATUS"), Tables.REQUIREMENT_VERSION.RES_ID.as("VERSION_ID"), Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.as("REQUIREMENT_ID"), Tables.SPRINT_REQ_VERSION.SPRINT_ID, this.getDescriptionBasedOnReqVersionId().as("DESCRIPTION"), Tables.CAMPAIGN_LIBRARY_NODE.NAME.as("SPRINT_NAME"), Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID, Tables.SPRINT_REQ_VERSION.MODE, Tables.SPRINT_REQ_VERSION.CREATED_BY, Tables.SPRINT_REQ_VERSION.CREATED_ON, Tables.SPRINT_REQ_VERSION.LAST_MODIFIED_BY, Tables.SPRINT_REQ_VERSION.LAST_MODIFIED_ON, Tables.SPRINT_REQ_VERSION.VALIDATION_STATUS, Tables.SPRINT.STATUS.as("SPRINT_STATUS"), Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_URL, Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_STATE}).from((TableLike)Tables.SPRINT_REQ_VERSION).leftJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID)).leftJoin((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).leftJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.PROJECT).on(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.SPRINT).on(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Field)Tables.SPRINT.CLN_ID)).leftJoin((TableLike)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER).on(Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.eq((Field)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.SPRINT_REQ_VERSION_ID)).where(Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.eq((Object)sprintReqVersionId)).fetchOneInto(SprintReqVersionView.class);
        Long sprintId = sprintReqVersionDto.getSprintId();
        int nbIssues = this.sprintReqVersionKnownIssueFinder.countKnownIssues(sprintReqVersionId);
        sprintReqVersionDto.setNbIssues(nbIssues);
        PermissionsUtils.checkPermission(this.permissionEvaluationService, Collections.singletonList(sprintId), Permissions.READ.name(), Sprint.class.getName());
        String path = this.entityPathHeaderService.buildCLNPathHeader(sprintId);
        String sprintName = sprintReqVersionDto.getSprintName();
        sprintReqVersionDto.setPath(String.valueOf(path) + " > " + sprintName);
        sprintReqVersionDto.setAssignableUsers(UserView.fromEntities(this.sprintTestPlanItemManagerService.findAssignableUsersByCampaignLibraryId(sprintReqVersionDto.getCampaignLibraryId())));
        return sprintReqVersionDto;
    }

    @Override
    public List<AvailableTestPlanItemDto> findAvailableTestPlanItems(long sprintReqVersionId) {
        if (!this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.LINK.name(), (Long)sprintReqVersionId, SprintReqVersion.class.getName())) {
            return Collections.emptyList();
        }
        List alreadyPlannedItems = this.dslContext.select((SelectField)Tables.TEST_PLAN_ITEM.TCLN_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME, (SelectField)Tables.TEST_CASE.REFERENCE, (SelectField)Tables.TEST_PLAN_ITEM.DATASET_ID, (SelectField)Tables.DATASET.NAME).from((TableLike)Tables.TEST_PLAN_ITEM).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.DATASET).on(Tables.TEST_PLAN_ITEM.DATASET_ID.eq((Field)Tables.DATASET.DATASET_ID)).innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID)).where(Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.eq((Object)sprintReqVersionId)).fetchInto(AvailableTestPlanItemDto.class);
        List coverageItems = this.dslContext.select((SelectField)Tables.TEST_CASE.TCLN_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME, (SelectField)Tables.TEST_CASE.REFERENCE, (SelectField)Tables.DATASET.DATASET_ID, (SelectField)Tables.DATASET.NAME).from((TableLike)Tables.TEST_CASE).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.DATASET).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.DATASET.TEST_CASE_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID)).innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).where(Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.eq((Object)sprintReqVersionId)).fetchInto(AvailableTestPlanItemDto.class);
        coverageItems.removeIf(coverageItem -> SprintDisplayServiceImpl.isAlreadyPlanned(coverageItem, alreadyPlannedItems));
        return coverageItems;
    }

    @Override
    public List<AvailableTestPlanItemIdsDto> findAvailableTestPlanItemIds(long sprintReqVersionId) {
        return this.dslContext.select((SelectField)Tables.TEST_CASE.TCLN_ID, (SelectField)Tables.DATASET.DATASET_ID).from((TableLike)Tables.SPRINT_REQ_VERSION).leftJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID)).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.DATASET).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.DATASET.TEST_CASE_ID)).where(Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.eq((Object)sprintReqVersionId)).fetchInto(AvailableTestPlanItemIdsDto.class);
    }

    private static boolean isAlreadyPlanned(AvailableTestPlanItemDto coverageItem, List<AvailableTestPlanItemDto> alreadyPlannedItems) {
        return alreadyPlannedItems.stream().anyMatch(alreadyPlannedItem -> SprintDisplayServiceImpl.compareItems(coverageItem, alreadyPlannedItem));
    }

    private static boolean compareItems(AvailableTestPlanItemDto coverageItem, AvailableTestPlanItemDto alreadyPlannedItem) {
        if (alreadyPlannedItem.testCaseId() == null) {
            return false;
        }
        if (!alreadyPlannedItem.testCaseId().equals(coverageItem.testCaseId())) {
            return false;
        }
        if (alreadyPlannedItem.datasetId() == null && coverageItem.datasetId() == null) {
            return true;
        }
        if (alreadyPlannedItem.datasetId() == null || coverageItem.datasetId() == null) {
            return false;
        }
        return alreadyPlannedItem.datasetId().equals(coverageItem.datasetId());
    }
}

