/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.Order;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.jooq.DSLContext;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.AccessDeniedException;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQuery;
import org.squashtest.tm.domain.query.NaturalJoinStyle;
import org.squashtest.tm.domain.query.Operation;
import org.squashtest.tm.domain.query.QueryColumnPrototype;
import org.squashtest.tm.domain.query.QueryFilterColumn;
import org.squashtest.tm.domain.query.QueryModel;
import org.squashtest.tm.domain.query.QueryOrderingColumn;
import org.squashtest.tm.domain.query.QueryProjectionColumn;
import org.squashtest.tm.domain.query.QueryStrategy;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.records.ProjectRecord;
import org.squashtest.tm.service.display.search.ResearchResult;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridSort;
import org.squashtest.tm.service.internal.display.search.filter.FilterHandlers;
import org.squashtest.tm.service.internal.display.search.filter.FilterValueHandlers;
import org.squashtest.tm.service.internal.repository.ColumnPrototypeDao;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.query.ConfiguredQuery;
import org.squashtest.tm.service.query.QueryProcessingService;

public abstract class AbstractSearchService {
    protected Map<String, QueryColumnPrototype> prototypesByLabel;
    protected QueryProcessingService queryService;
    protected ColumnPrototypeDao columnPrototypeDao;
    protected EntityManager entityManager;
    protected ProjectFinder projectFinder;
    protected FilterHandlers filterHandlers;
    protected FilterValueHandlers gridFilterValueHandlers;
    private final DSLContext dslContext;

    protected AbstractSearchService(QueryProcessingService queryService, ColumnPrototypeDao columnPrototypeDao, EntityManager entityManager, ProjectFinder projectFinder, FilterHandlers filterHandlers, FilterValueHandlers gridFilterValueHandlers, DSLContext dslContext) {
        this.queryService = queryService;
        this.columnPrototypeDao = columnPrototypeDao;
        this.entityManager = entityManager;
        this.projectFinder = projectFinder;
        this.filterHandlers = filterHandlers;
        this.gridFilterValueHandlers = gridFilterValueHandlers;
        this.dslContext = dslContext;
    }

    @PostConstruct
    public void init() {
        this.prototypesByLabel = this.columnPrototypeDao.findAll().stream().collect(Collectors.toMap(QueryColumnPrototype::getLabel, Function.identity()));
    }

    public ResearchResult search(GridRequest gridRequest) {
        this.assertCurrentUserHasPermissionToSearch();
        QueryModel query = this.prepareBaseQuery(gridRequest);
        List<Long> ids = this.searchPaginatedEntityIds(gridRequest, query);
        long count = this.countMatchingEntities(gridRequest, query);
        return new ResearchResult(ids, count);
    }

    protected void assertCurrentUserHasPermissionToSearch() {
        if (!this.projectFinder.canReadAtLeastOneProject()) {
            throw new AccessDeniedException("No permissions to search");
        }
    }

    private long countMatchingEntities(GridRequest request, QueryModel query) {
        ExtendedHibernateQuery<Tuple> countHibernateQuery = this.prepareHibernateQuery(request, query);
        countHibernateQuery.limit(Long.MAX_VALUE);
        countHibernateQuery.offset(0L);
        return countHibernateQuery.clone(this.getSession()).fetchCount();
    }

    private List<Long> searchPaginatedEntityIds(GridRequest request, QueryModel query) {
        ExtendedHibernateQuery<Tuple> extendedHibernateQuery = this.prepareHibernateQuery(request, query);
        return extendedHibernateQuery.clone(this.getSession()).fetch().stream().map(tuple -> (Long)tuple.get(0, Long.class)).toList();
    }

    private ExtendedHibernateQuery<Tuple> prepareHibernateQuery(GridRequest request, QueryModel query) {
        ConfiguredQuery configuredQuery = this.preparePaginatedConfiguredQuery(request, query);
        ExtendedHibernateQuery extendedHibernateQuery = this.queryService.prepareQuery(configuredQuery);
        this.filterHandlers.handleFiltersOutOfQueryEngine(extendedHibernateQuery, request);
        return extendedHibernateQuery;
    }

    private Session getSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    private ConfiguredQuery preparePaginatedConfiguredQuery(GridRequest request, QueryModel query) {
        PageRequest pageable = null;
        if (request.getPage() != null && request.getSize() != null) {
            pageable = PageRequest.of((int)request.getPage(), (int)request.getSize());
        }
        ConfiguredQuery configuredQuery = new ConfiguredQuery();
        List<EntityReference> scope = this.computeScope(request);
        configuredQuery.setScope(scope);
        configuredQuery.setQueryModel(query);
        configuredQuery.setPaging((Pageable)pageable);
        return configuredQuery;
    }

    protected List<EntityReference> computeScope(GridRequest request) {
        List<EntityReference> scope = request.getScope().isEmpty() ? this.computeDefaultScope() : this.computeCustomScope(request);
        List<EntityReference> convertedScope = this.convertProjectIntoLibraries(scope);
        return this.extendScope(convertedScope, request.isExtendedHighLvlReqScope());
    }

    private List<EntityReference> convertProjectIntoLibraries(List<EntityReference> entityReferences) {
        boolean hasProject = entityReferences.stream().anyMatch(e -> e.getType() == EntityType.PROJECT);
        if (hasProject) {
            List<Long> projectIds = entityReferences.stream().filter(entityReference -> entityReference.getType() == EntityType.PROJECT).map(EntityReference::getId).toList();
            List<EntityReference> libraryIds = this.findLibraryIds(projectIds).stream().map(id -> new EntityReference(this.getLibraryEntityType(), id)).toList();
            if (libraryIds.size() != entityReferences.size()) {
                throw new IllegalArgumentException("Incorrect perimeter in that search... " + entityReferences);
            }
            return libraryIds;
        }
        return entityReferences;
    }

    protected abstract EntityType getLibraryEntityType();

    private List<Long> findLibraryIds(List<Long> projectIds) {
        return this.dslContext.select(this.getLibraryIdField()).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_ID.in(projectIds)).fetch(this.getLibraryIdField());
    }

    protected abstract TableField<ProjectRecord, Long> getLibraryIdField();

    private List<EntityReference> computeCustomScope(GridRequest request) {
        return request.getScope().stream().map(EntityReference::fromNodeId).toList();
    }

    private List<EntityReference> computeDefaultScope() {
        return this.projectFinder.findAllReadableIds().stream().map(id -> new EntityReference(EntityType.PROJECT, id)).toList();
    }

    protected QueryModel prepareBaseQuery(GridRequest request) {
        QueryModel query = new QueryModel();
        query.setStrategy(QueryStrategy.MAIN);
        query.setJoinStyle(NaturalJoinStyle.INNER_JOIN);
        this.prepareProjection(request, query);
        this.prepareFilters(request, query);
        this.prepareOrders(request, query);
        return query;
    }

    private void prepareOrders(GridRequest request, QueryModel query) {
        List<GridSort> gridSorts = request.getSort();
        List<QueryOrderingColumn> orderingColumns = this.prepareCustomSorts(gridSorts);
        query.setOrderingColumns(orderingColumns);
    }

    private List<QueryOrderingColumn> prepareCustomSorts(List<GridSort> gridSorts) {
        List<QueryOrderingColumn> customOrderingColumns = gridSorts.stream().map(this::prepareCustomSort).toList();
        ArrayList<QueryOrderingColumn> orderingColumns = new ArrayList<QueryOrderingColumn>(customOrderingColumns);
        orderingColumns.add(this.prepareDefaultOrderingColumn());
        return orderingColumns;
    }

    private QueryOrderingColumn prepareCustomSort(GridSort gridSort) {
        QueryOrderingColumn queryOrderingColumn = new QueryOrderingColumn();
        QueryColumnPrototype columnPrototype = this.findColumnPrototype(gridSort.getColumnPrototype());
        queryOrderingColumn.setColumnPrototype(columnPrototype);
        queryOrderingColumn.setCufId(gridSort.getCufId());
        if (gridSort.getDirection().equals((Object)GridSort.SortDirection.ASC)) {
            queryOrderingColumn.setOrder(Order.ASC);
        } else {
            queryOrderingColumn.setOrder(Order.DESC);
        }
        queryOrderingColumn.setOperation(Operation.NONE);
        return queryOrderingColumn;
    }

    private QueryOrderingColumn prepareDefaultOrderingColumn() {
        QueryOrderingColumn queryOrderingColumn = new QueryOrderingColumn();
        queryOrderingColumn.setColumnPrototype(this.findColumnPrototype(this.getDefaultSortColumnName()));
        queryOrderingColumn.setOperation(Operation.NONE);
        queryOrderingColumn.setOrder(Order.ASC);
        return queryOrderingColumn;
    }

    private void prepareFilters(GridRequest request, QueryModel query) {
        ArrayList filters = new ArrayList();
        request.getFilterValues().stream().filter(filter -> !this.filterHandlers.isHandledOutOfQueryEngine((GridFilterValue)filter)).forEach(gridFilterValue -> {
            String columnPrototype = gridFilterValue.getColumnPrototype();
            if (StringUtils.isNotBlank((CharSequence)columnPrototype)) {
                QueryFilterColumn queryFilterColumn = this.prepareFilter((GridFilterValue)gridFilterValue, columnPrototype);
                filters.add(queryFilterColumn);
            }
        });
        query.setFilterColumns(filters);
    }

    private QueryFilterColumn prepareFilter(GridFilterValue gridFilterValue, String columnPrototype) {
        QueryColumnPrototype filterPrototype = this.findColumnPrototype(columnPrototype);
        QueryFilterColumn queryFilterColumn = new QueryFilterColumn();
        queryFilterColumn.setColumn(filterPrototype);
        queryFilterColumn.setOperation(Operation.valueOf((String)gridFilterValue.getOperation()));
        this.gridFilterValueHandlers.handleGridFilterValuesOutOfQueryEngine(gridFilterValue);
        queryFilterColumn.addValues(gridFilterValue.getValues());
        queryFilterColumn.setCufId(gridFilterValue.getCufId());
        return queryFilterColumn;
    }

    private QueryColumnPrototype findColumnPrototype(String columnPrototypeLabel) {
        if (StringUtils.isBlank((CharSequence)columnPrototypeLabel)) {
            throw new IllegalArgumentException("Cannot find a prototype without its identifier");
        }
        if (!this.prototypesByLabel.containsKey(columnPrototypeLabel)) {
            throw new IllegalArgumentException("Unknown column prototype " + columnPrototypeLabel);
        }
        QueryColumnPrototype filterPrototype = this.prototypesByLabel.get(columnPrototypeLabel);
        return filterPrototype;
    }

    private void prepareProjection(GridRequest request, QueryModel query) {
        List<QueryProjectionColumn> idProjection = this.prepareProjectionOnId();
        ArrayList<QueryProjectionColumn> projections = new ArrayList<QueryProjectionColumn>(idProjection);
        List<QueryProjectionColumn> projectionColumns = request.getSort().stream().filter(gridSort -> !this.getIdentifierColumnName().contains(gridSort.getColumnPrototype())).map(gridSort -> {
            QueryProjectionColumn queryProjectionColumn = new QueryProjectionColumn();
            queryProjectionColumn.setColumnPrototype(this.findColumnPrototype(gridSort.getColumnPrototype()));
            queryProjectionColumn.setCufId(gridSort.getCufId());
            queryProjectionColumn.setOperation(Operation.NONE);
            return queryProjectionColumn;
        }).toList();
        projections.addAll(projectionColumns);
        query.setProjectionColumns(projections);
    }

    private List<QueryProjectionColumn> prepareProjectionOnId() {
        return this.getIdentifierColumnName().stream().map(columnPrototypeName -> {
            QueryProjectionColumn queryProjectionColumn = new QueryProjectionColumn();
            queryProjectionColumn.setColumnPrototype(this.findColumnPrototype((String)columnPrototypeName));
            queryProjectionColumn.setOperation(Operation.NONE);
            return queryProjectionColumn;
        }).toList();
    }

    protected abstract List<String> getIdentifierColumnName();

    protected abstract String getDefaultSortColumnName();

    protected List<EntityReference> extendScope(List<EntityReference> entityReferences, boolean extendedScope) {
        return entityReferences;
    }
}

