/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.campaign;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;
import org.squashtest.tm.service.internal.display.grid.columns.LevelEnumColumn;

public class IterationTestPlanItemExecutionGrid
extends AbstractGrid {
    private final Long iterationId;
    private final Long itemId;

    public IterationTestPlanItemExecutionGrid(Long iterationId, Long itemId) {
        this.iterationId = iterationId;
        this.itemId = itemId;
    }

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn((Field<?>)Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID), new GridColumn(Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ORDER.as("EXECUTION_ORDER")), new GridColumn(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.as("PROJECT_ID")), new GridColumn(Tables.EXECUTION.EXECUTION_MODE.as("INFERRED_EXECUTION_MODE")), new GridColumn(Tables.EXECUTION.REFERENCE.as("EXECUTION_REFERENCE")), new GridColumn(Tables.EXECUTION.NAME.as("EXECUTION_NAME")), new LevelEnumColumn(TestCaseImportance.class, (Field<String>)Tables.EXECUTION.IMPORTANCE), new GridColumn(Tables.EXECUTION.DATASET_LABEL.as("DATASET_NAME")), new LevelEnumColumn(ExecutionStatus.class, (Field<String>)Tables.EXECUTION.EXECUTION_STATUS), new GridColumn(Tables.EXECUTION.LAST_EXECUTED_BY.as("USER")), new GridColumn((Field<?>)Tables.EXECUTION.LAST_EXECUTED_ON), new GridColumn(this.countIssue().as("ISSUE_COUNT")), new GridColumn(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.as("ITEM_TEST_PLAN_ID")), new GridColumn(Tables.ITERATION.ITERATION_ID.as("ITERATION_ID")), new GridColumn(DSL.field((Condition)this.countBlockingMilestoneBindings().greaterThan((Object)0)).as("BOUND_TO_BLOCKING_MILESTONE")));
    }

    private Field<Integer> countIssue() {
        return DSL.selectCount().from((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).where(Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).asField("ISSUE_COUNT");
    }

    @Override
    protected Table<?> getTable() {
        return Tables.EXECUTION.innerJoin((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).on(Tables.EXECUTION.EXECUTION_ID.eq((Field)Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID)).innerJoin((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).on(Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID)).leftJoin((TableLike)Tables.DATASET).on(Tables.ITERATION_TEST_PLAN_ITEM.DATASET_ID.eq((Field)Tables.DATASET.DATASET_ID)).innerJoin((TableLike)Tables.ITEM_TEST_PLAN_LIST).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID)).innerJoin((TableLike)Tables.ITERATION).on(Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID));
    }

    @Override
    protected Field<?> getIdentifier() {
        return Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID;
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID;
    }

    @Override
    protected Condition craftInvariantFilter() {
        return Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.eq((Object)this.itemId).and(Tables.ITERATION.ITERATION_ID.eq((Object)this.iterationId));
    }

    @Override
    protected SortField<?> getDefaultOrder() {
        return Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ORDER.desc();
    }

    private Field<Integer> countBlockingMilestoneBindings() {
        return DSL.selectCount().from((TableLike)Tables.MILESTONE).join((TableLike)Tables.MILESTONE_CAMPAIGN).on(Tables.MILESTONE_CAMPAIGN.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.MILESTONE.STATUS.in((Collection)MilestoneStatus.MILESTONE_BLOCKING_STATUSES).and(Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID))).asField();
    }
}

