/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.campaign;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.Record4;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.SelectOnConditionStep;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.records.IterationTestPlanItemRecord;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.campaign.AbstractTestPlanGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;
import org.squashtest.tm.service.internal.display.grid.columns.LevelEnumColumn;
import org.squashtest.tm.service.internal.repository.display.IterationDisplayDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;

public class IterationTestPlanGrid
extends AbstractTestPlanGrid<IterationTestPlanItemRecord> {
    private final Long iterationId;
    private final IterationDisplayDao iterationDisplayDao;
    private final PermissionEvaluationService permissionEvaluationService;

    public IterationTestPlanGrid(Long iterationId, String userLoginToRestrictTo, IterationDisplayDao iterationDisplayDao, PermissionEvaluationService permissionEvaluationService) {
        super(userLoginToRestrictTo);
        this.iterationId = iterationId;
        this.iterationDisplayDao = iterationDisplayDao;
        this.permissionEvaluationService = permissionEvaluationService;
    }

    @Override
    protected TableField<IterationTestPlanItemRecord, Long> getItemIdColumn() {
        return Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID;
    }

    @Override
    protected TableField<IterationTestPlanItemRecord, Long> getAssigneeIdColumn() {
        return Tables.ITERATION_TEST_PLAN_ITEM.USER_ID;
    }

    @Override
    protected TableField<IterationTestPlanItemRecord, Long> getTestCaseIdColumn() {
        return Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID;
    }

    @Override
    protected Table<IterationTestPlanItemRecord> getItemTable() {
        return Tables.ITERATION_TEST_PLAN_ITEM;
    }

    @Override
    protected Long countRows(DSLContext dslContext, GridRequest request) {
        if (request.getFilterValues().isEmpty() && this.currentUserCanReadUnassigned(this.iterationId)) {
            return this.iterationDisplayDao.getNbTestPlanItem(this.iterationId, this.userLoginToRestrictTo);
        }
        return super.countRows(dslContext, request);
    }

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn((Field<?>)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID), new GridColumn((Field<?>)Tables.ITERATION_TEST_PLAN_ITEM.LAST_EXECUTED_ON), new GridColumn(this.findItpiWithLatestExecution().field("LATEST_EXECUTION_ID")), new GridColumn(Tables.ITERATION_TEST_PLAN_ITEM.USER_ID.as("ASSIGNEE_ID")), new GridColumn((Field<?>)Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID), new GridColumn(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as("TEST_CASE_ID")), new GridColumn((Field<?>)Tables.TEST_CASE_LIBRARY_NODE.NAME.as("TEST_CASE_NAME"), (Field<?>)Tables.TEST_CASE_LIBRARY_NODE.NAME), new GridColumn(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.as("PROJECT_ID")), new GridColumn((Field<?>)Tables.PROJECT.NAME.as("PROJECT_NAME"), (Field<?>)Tables.PROJECT.NAME), new GridColumn((Field<?>)Tables.TEST_CASE.REFERENCE.as("TEST_CASE_REFERENCE"), (Field<?>)Tables.TEST_CASE.REFERENCE), new LevelEnumColumn(TestCaseImportance.class, (Field<String>)Tables.TEST_CASE.IMPORTANCE), new GridColumn(this.getUser().field("ASSIGNEE_FULL_NAME")), new GridColumn(this.getUser().field("ASSIGNEE_LOGIN")), new GridColumn((Field<?>)Tables.DATASET.NAME.as("DATASET_NAME"), (Field<?>)Tables.DATASET.NAME), new GridColumn(DSL.coalesce((Field)this.getAutomationFields().field("INFERRED_EXECUTION_MODE"), (Field[])new Field[]{Tables.EXECUTION.EXECUTION_MODE}).as("INFERRED_EXECUTION_MODE")), new GridColumn((Field<?>)Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID), new GridColumn(this.getTestSuites().field("TEST_SUITES")), new LevelEnumColumn(ExecutionStatus.class, (Field<String>)Tables.ITERATION_TEST_PLAN_ITEM.EXECUTION_STATUS), new GridColumn(DSL.field((String)"MILESTONE_MIN_DATE")), new GridColumn(DSL.field((String)"MILESTONE_MAX_DATE")), new GridColumn(DSL.field((String)"MILESTONE_LABELS")), new GridColumn(DSL.field((String)"BOUND_TO_BLOCKING_MILESTONE")), new GridColumn(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.isNull().as("TEST_CASE_DELETED")));
    }

    @Override
    protected Table<?> getTable() {
        SelectHavingStep<Record2<Long, String>> getAutomationFields = this.getAutomationFields();
        SelectHavingStep<Record> getUser = this.getUser();
        SelectOnConditionStep<Record2<Long, Long>> findItpiWithLatestExecution = this.findItpiWithLatestExecution();
        SelectHavingStep<?> testSuites = this.getTestSuites();
        SelectHavingStep<Record4<Long, Timestamp, Timestamp, String>> milestoneDates = this.getMilestoneDates();
        SelectHavingStep<Record2<Long, Boolean>> boundToLockedMilestone = this.getBoundToBlockingMilestone();
        return this.getFilteredTableOnAssigneeIfNotExploratory((Table<Record>)Tables.ITERATION_TEST_PLAN_ITEM.innerJoin((TableLike)Tables.ITEM_TEST_PLAN_LIST).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID)).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.ITERATION).on(Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).leftJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).leftJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin(getAutomationFields).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq(getAutomationFields.field("ITEM_ID", Long.class))).leftJoin((TableLike)Tables.DATASET).on(Tables.ITERATION_TEST_PLAN_ITEM.DATASET_ID.eq((Field)Tables.DATASET.DATASET_ID)).leftJoin(getUser).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq(getUser.field("ITEM_ID", Long.class))).leftJoin(findItpiWithLatestExecution).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq(findItpiWithLatestExecution.field("ITEM_ID", Long.class))).leftJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.EXECUTION_ID.eq(findItpiWithLatestExecution.field("LATEST_EXECUTION_ID", Long.class))).leftJoin(testSuites).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq(testSuites.field("ITEM_ID", Long.class))).leftJoin(milestoneDates).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq(milestoneDates.field("ITEM_ID", Long.class))).leftJoin(boundToLockedMilestone).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq(boundToLockedMilestone.field("ITEM_ID", Long.class))).leftJoin((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.ITEM_TEST_PLAN_ID)));
    }

    @Override
    protected Condition craftInvariantFilter() {
        return Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID.eq((Object)this.iterationId);
    }

    @Override
    protected Field<?> getIdentifier() {
        return Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID;
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID;
    }

    @Override
    protected SortField<?> getDefaultOrder() {
        return Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ORDER.asc();
    }

    @Override
    protected SelectHavingStep<Record2<Long, Integer>> findLastExecutionByOrder() {
        return DSL.select((SelectField)Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.as("ITEM_ID"), (SelectField)DSL.max((Field)Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ORDER).as("MAX_EXECUTION_ORDER")).from((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).innerJoin((TableLike)Tables.ITEM_TEST_PLAN_LIST).on(Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID)).where(Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID.eq((Object)this.iterationId)).groupBy(new GroupField[]{DSL.field((String)"ITEM_ID")});
    }

    private SelectHavingStep<?> getTestSuites() {
        return DSL.select((SelectField)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.as("ITEM_ID"), (SelectField)DSL.listAgg((Field)Tables.TEST_SUITE.NAME, (String)", ").withinGroupOrderBy(new OrderField[]{Tables.TEST_SUITE_TEST_PLAN_ITEM.TEST_PLAN_ORDER}).as("TEST_SUITES")).from((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).innerJoin((TableLike)Tables.TEST_SUITE).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Field)Tables.TEST_SUITE.ID)).innerJoin((TableLike)Tables.ITERATION_TEST_SUITE).on(Tables.TEST_SUITE.ID.eq((Field)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID)).where(Tables.ITERATION_TEST_SUITE.ITERATION_ID.eq((Object)this.iterationId)).groupBy(new GroupField[]{Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID});
    }

    private boolean currentUserCanReadUnassigned(Long iterationId) {
        return this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.READ_UNASSIGNED.name(), iterationId, "org.squashtest.tm.domain.campaign.Iteration");
    }
}

