/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.campaign;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.execution.ExploratoryExecutionEventType;
import org.squashtest.tm.domain.execution.ExploratoryExecutionRunningState;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.campaign.TestPlanGridHelpers;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;

public class ExploratorySessionExecutionGrid
extends AbstractGrid {
    private static final String EXEC_ID = "EXEC_ID";
    private final Long overviewId;

    public ExploratorySessionExecutionGrid(Long overviewId) {
        this.overviewId = overviewId;
    }

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn(DSL.field((String)EXEC_ID).as("EXECUTION_ID")), new GridColumn(DSL.field((String)"LAST_EXECUTED_ON", Timestamp.class)), new GridColumn(DSL.field((String)"ASSIGNEE_ID")), new GridColumn(DSL.field((String)"ASSIGNEE_LOGIN")), new GridColumn(DSL.field((String)"ASSIGNEE_FULL_NAME")), new GridColumn(DSL.field((String)"TASK_DIVISION")), new GridColumn(DSL.field((String)"REVIEWED")), new GridColumn(DSL.field((String)"NOTE_TYPES")), new GridColumn(DSL.field((String)"EXECUTION_ORDER")), new GridColumn(DSL.field((String)"PROJECT_ID")), new GridColumn(this.countIssue().as("ISSUE_COUNT")), new GridColumn(DSL.field((String)"RUNNING_STATE")));
    }

    private Field<String> findSessionStatus() {
        return DSL.select((SelectField)DSL.when((Condition)Tables.EXPLORATORY_EXECUTION_EVENT.EVENT_TYPE.eq((Object)ExploratoryExecutionEventType.STOP.name()), (Object)ExploratoryExecutionRunningState.STOPPED.name()).otherwise(DSL.when((Condition)Tables.EXPLORATORY_EXECUTION_EVENT.EVENT_TYPE.in((Object[])new String[]{ExploratoryExecutionEventType.RESUME.name(), ExploratoryExecutionEventType.START.name(), ExploratoryExecutionEventType.PAUSE.name()}), (Object)ExploratoryExecutionRunningState.RUNNING.name()).otherwise((Object)ExploratoryExecutionRunningState.NEVER_STARTED.name())).as("RUNNING_STATE")).from((TableLike)Tables.EXPLORATORY_EXECUTION_EVENT).where(Tables.EXPLORATORY_EXECUTION_EVENT.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).orderBy((OrderField)Tables.EXPLORATORY_EXECUTION_EVENT.EVENT_DATE.desc()).limit((Number)1).asField();
    }

    private Field<Integer> countIssue() {
        return DSL.select((SelectField)DSL.countDistinct((Field)Tables.ISSUE.REMOTE_ISSUE_ID)).from((TableLike)Tables.ISSUE).innerJoin((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).on(Tables.EXECUTION_ISSUES_CLOSURE.ISSUE_ID.eq((Field)Tables.ISSUE.ISSUE_ID)).where(DSL.field((String)EXEC_ID).eq((Object)Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID)).asField("ISSUE_COUNT");
    }

    @Override
    protected Table<?> getTable() {
        return DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[]{Tables.EXECUTION.EXECUTION_ID.as(EXEC_ID), Tables.EXECUTION.LAST_EXECUTED_ON, Tables.EXPLORATORY_EXECUTION.ASSIGNEE_ID, Tables.EXPLORATORY_EXECUTION.TASK_DIVISION, Tables.CORE_USER.LOGIN.as("ASSIGNEE_LOGIN"), Tables.EXPLORATORY_EXECUTION.REVIEWED, Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ORDER, Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID, DSL.groupConcat((Field)Tables.SESSION_NOTE.KIND).as("NOTE_TYPES"), TestPlanGridHelpers.formatAssigneeFullName(), DSL.coalesce(this.findSessionStatus(), (Object)ExploratoryExecutionRunningState.NEVER_STARTED.name()).as("RUNNING_STATE")}).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).on(Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).innerJoin((TableLike)Tables.ITEM_TEST_PLAN_LIST).on(Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID)).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).innerJoin((TableLike)Tables.EXPLORATORY_EXECUTION).on(Tables.EXPLORATORY_EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.SESSION_NOTE).on(Tables.SESSION_NOTE.EXECUTION_ID.eq((Field)Tables.EXPLORATORY_EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.CORE_USER).on(Tables.CORE_USER.PARTY_ID.eq((Field)Tables.EXPLORATORY_EXECUTION.ASSIGNEE_ID)).innerJoin((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.EXPLORATORY_SESSION_OVERVIEW.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID).and(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Object)this.overviewId))).groupBy(new GroupField[]{Tables.EXECUTION.EXECUTION_ID, Tables.EXPLORATORY_EXECUTION.ASSIGNEE_ID, Tables.EXPLORATORY_EXECUTION.TASK_DIVISION, Tables.EXPLORATORY_EXECUTION.REVIEWED, Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ORDER, Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID, Tables.CORE_USER.PARTY_ID}).asTable();
    }

    @Override
    protected Field<?> getIdentifier() {
        return DSL.field((String)"EXECUTION_ID");
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return DSL.field((String)"PROJECT_ID");
    }

    @Override
    protected SortField<?> getDefaultOrder() {
        return DSL.field((String)"EXECUTION_ORDER").asc();
    }
}

