/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.environmentvariable;

import java.util.List;
import javax.transaction.Transactional;
import org.jooq.DSLContext;
import org.springframework.stereotype.Service;
import org.squashtest.tm.service.display.environmentvariable.EnvironmentVariableDisplayService;
import org.squashtest.tm.service.internal.display.dto.EnvironmentVariableDto;
import org.squashtest.tm.service.internal.display.dto.EnvironmentVariableOptionDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.administration.EnvironmentVariableGrid;
import org.squashtest.tm.service.internal.repository.EnvironmentVariableBindingDao;
import org.squashtest.tm.service.internal.repository.display.EnvironmentVariableDisplayDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional
public class EnvironmentVariableDisplayServiceImpl
implements EnvironmentVariableDisplayService {
    private final DSLContext dsl;
    private final EnvironmentVariableDisplayDao dao;
    private final EnvironmentVariableBindingDao bindingDao;
    private final PermissionEvaluationService permissionEvaluationService;

    public EnvironmentVariableDisplayServiceImpl(DSLContext dsl, EnvironmentVariableDisplayDao dao, EnvironmentVariableBindingDao bindingDao, PermissionEvaluationService permissionEvaluationService) {
        this.dsl = dsl;
        this.dao = dao;
        this.bindingDao = bindingDao;
        this.permissionEvaluationService = permissionEvaluationService;
    }

    @Override
    public GridResponse findAll(GridRequest request) {
        this.permissionEvaluationService.checkAtLeastOneProjectManagementPermissionOrAdmin();
        EnvironmentVariableGrid evGrid = new EnvironmentVariableGrid();
        return evGrid.getRows(request, this.dsl);
    }

    @Override
    public List<EnvironmentVariableDto> getAllEnvironmentVariableReferences() {
        this.permissionEvaluationService.checkAtLeastOneProjectManagementPermissionOrAdmin();
        return this.dao.getAllEnvironmentVariableDto();
    }

    @Override
    public EnvironmentVariableDto getEnvironmentVariableView(Long environmentVariableId) {
        this.permissionEvaluationService.checkAtLeastOneProjectManagementPermissionOrAdmin();
        EnvironmentVariableDto dto = this.dao.getEnvironmentVariableById(environmentVariableId);
        dto.setIsBoundToServer(this.isEnvironmentVariableBound(dto.getId()));
        return dto;
    }

    @Override
    public List<EnvironmentVariableOptionDto> getOptionsByEvId(Long environmentVariableId) {
        this.permissionEvaluationService.checkAtLeastOneProjectManagementPermissionOrAdmin();
        return this.dao.getEnvironmentVariableOptionListByEvId(environmentVariableId);
    }

    private boolean isEnvironmentVariableBound(Long environmentVariableId) {
        return !this.bindingDao.findAllByEnvironmentVariable_Id(environmentVariableId).isEmpty();
    }
}

