/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.campaign;

import java.util.Map;
import java.util.Set;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.ResultQuery;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.campaign.AbstractSuccessRateCalculator;

@Component
@Scope(value="prototype")
public class IterationTestPlanItemSuccessRateCalculator
extends AbstractSuccessRateCalculator {
    public IterationTestPlanItemSuccessRateCalculator(DSLContext dslContext) {
        super(dslContext);
    }

    @Override
    protected Map<Long, Float> createRateByDataRowIdMap(Set<Long> testPlanItemIds) {
        Field executionId = this.dslContext.select((SelectField)Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID).from((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).where(Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID)).orderBy((OrderField)Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ORDER.desc()).limit((Number)1).asField("EXECUTION_ID");
        CommonTableExpression executionCTE = DSL.name((String)"LAST_EXEC").fields("ITEM_TEST_PLAN_ID", "EXECUTION_ID").as((ResultQuery)this.dslContext.select((SelectField)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID, (SelectField)executionId).from((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).where(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.in(testPlanItemIds)));
        Field successRate = DSL.sum((Field)DSL.when((Condition)Tables.EXECUTION_STEP.EXECUTION_STATUS.eq((Object)ExecutionStatus.SUCCESS.name()), (Object)1)).cast(Float.class).mul((Number)100).div(DSL.when((Condition)DSL.count().eq((Object)0), (Object)1).otherwise((Field)DSL.count())).as("SUCCESS_RATE");
        Field itemTestPlanId = executionCTE.field("ITEM_TEST_PLAN_ID", Long.class);
        return this.dslContext.with(new CommonTableExpression[]{executionCTE}).select((SelectField)itemTestPlanId, (SelectField)successRate).from((TableLike)executionCTE).join((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq(executionCTE.field("EXECUTION_ID", Long.class))).join((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID)).groupBy(new GroupField[]{itemTestPlanId}).orderBy((OrderField)itemTestPlanId).fetchMap(itemTestPlanId, successRate);
    }
}

