/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion.jdbc;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record3;
import org.jooq.SelectConditionStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.TableOnConditionStep;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.deletion.jdbc.AbstractSprintReqVersionDeletionHandler;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcBatchReorderHelper;

public class JdbcSprintDeletionHandler
extends AbstractSprintReqVersionDeletionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcSprintDeletionHandler.class);
    private final Set<Long> sprintIds;

    public JdbcSprintDeletionHandler(Collection<Long> sprintIds, DSLContext dslContext, EntityManager entityManager, AttachmentRepository attachmentRepository, JdbcBatchReorderHelper reorderHelper, String operationId) {
        super(dslContext, entityManager, attachmentRepository, reorderHelper, operationId);
        this.sprintIds = new HashSet<Long>(sprintIds);
    }

    protected TableOnConditionStep<Record> joinToExecution() {
        return Tables.SPRINT.join((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID)).join((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID));
    }

    @Override
    protected Condition getPredicate() {
        return Tables.SPRINT.CLN_ID.in(this.sprintIds);
    }

    public void deleteSprints() {
        this.logStartProcess();
        this.clearPersistenceContext();
        this.storeEntitiesToDeleteIntoWorkingTable();
        this.performDeletions();
        this.cleanWorkingTable();
        this.logEndProcess();
    }

    private void logEndProcess() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Deleted Sprints %s. Time elapsed %s", this.sprintIds, this.startDate.until(LocalDateTime.now(), ChronoUnit.MILLIS)), new Object[0]);
        }
    }

    private void performDeletions() {
        this.performExecutionDeletions();
        this.deleteSprintVersionSyncExtenders();
        this.deleteSprintReqVersionTestPlansItems();
        this.deleteSprintReqVersions();
        this.deleteSprintReqVersionTestPlans();
        this.deleteCustomFieldValues();
        this.deleteAttachmentLists();
        this.deleteAttachmentContents();
        this.deleteSprintEntities();
    }

    private void deleteSprintEntities() {
        this.workingTables.delete(Tables.SPRINT.CLN_ID, Tables.SPRINT.CLN_ID);
        this.logDelete((Table<?>)Tables.SPRINT);
    }

    private void logStartProcess() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Init deletion process of sprints %s. Operation:  %s", this.sprintIds, this.operationId), new Object[0]);
        }
    }

    private void storeEntitiesToDeleteIntoWorkingTable() {
        this.storeExecutionsToDeleteIntoWorkingTable();
        this.addSprintReqVersions();
        this.addSprintReqVersionsTestPlans();
        this.addSprintReqVersionsTestPlanItems();
        this.addSprintRequirementSyncExtenders();
        this.addCustomFieldValues();
        this.addAttachmentList();
        this.addSprintEntities();
        this.logReferenceEntitiesComplete();
    }

    private void addSprintEntities() {
        this.workingTables.addEntity(Tables.SPRINT.CLN_ID, () -> this.makeSelectClause(Tables.SPRINT.CLN_ID).from((TableLike)Tables.SPRINT).where(Tables.SPRINT.CLN_ID.in(this.sprintIds)));
    }

    @Override
    protected SelectConditionStep<Record3<Long, String, String>> selectSprintRequirementSyncExtenders() {
        return this.makeSelectClause(Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.SPRINT_REQ_SYNC_ID).from((TableLike)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER).innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.SPRINT_REQ_VERSION_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID)).where(Tables.SPRINT_REQ_VERSION.SPRINT_ID.in(this.sprintIds));
    }

    @Override
    protected Condition getSprintReqVersionPredicate() {
        return Tables.SPRINT_REQ_VERSION.SPRINT_ID.in(this.sprintIds);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

