/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.attachment.ExternalContentCoordinates;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.library.structures.LibraryGraph;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.domain.testcase.TestStepVisitor;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.deletion.BoundToLockedMilestonesReport;
import org.squashtest.tm.service.deletion.BoundToMultipleMilestonesReport;
import org.squashtest.tm.service.deletion.LinkedToIterationPreviewReport;
import org.squashtest.tm.service.deletion.MilestoneModeNoFolderDeletion;
import org.squashtest.tm.service.deletion.NotDeletablePreviewReport;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.deletion.SingleOrMultipleMilestonesReport;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.deletion.AbstractNodeDeletionHandler;
import org.squashtest.tm.service.internal.deletion.LockedFileInferenceGraph;
import org.squashtest.tm.service.internal.deletion.TestCaseNodeDeletionHandlerImpl$AjcClosure1;
import org.squashtest.tm.service.internal.deletion.TestCaseNodeDeletionHandlerImpl$AjcClosure3;
import org.squashtest.tm.service.internal.deletion.TestCaseNodeDeletionHandlerImpl$AjcClosure5;
import org.squashtest.tm.service.internal.repository.AutomatedTestDao;
import org.squashtest.tm.service.internal.repository.AutomationRequestDao;
import org.squashtest.tm.service.internal.repository.CustomSprintReqVersionDao;
import org.squashtest.tm.service.internal.repository.FolderDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.TestCaseDeletionDao;
import org.squashtest.tm.service.internal.repository.TestCaseFolderDao;
import org.squashtest.tm.service.internal.repository.TestPlanItemDao;
import org.squashtest.tm.service.internal.testcase.TestCaseCallTreeFinder;
import org.squashtest.tm.service.internal.testcase.TestCaseNodeDeletionHandler;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.testcase.CallStepManagerService;
import org.squashtest.tm.service.testcase.DatasetModificationService;
import org.squashtest.tm.service.testcase.ParameterModificationService;
import org.squashtest.tm.service.testcase.TestCaseImportanceManagerService;

@Component(value="squashtest.tm.service.deletion.TestCaseNodeDeletionHandler")
@Transactional
public class TestCaseNodeDeletionHandlerImpl
extends AbstractNodeDeletionHandler<TestCaseLibraryNode, TestCaseFolder>
implements TestCaseNodeDeletionHandler {
    private static final String TEST_CASES_TYPE = "test-cases";
    @Inject
    private TestCaseFolderDao folderDao;
    @Inject
    private TestCaseDao leafDao;
    @Inject
    private TestCaseDeletionDao deletionDao;
    @Inject
    private TestCaseImportanceManagerService testCaseImportanceManagerService;
    @Inject
    private DatasetModificationService datasetService;
    @Inject
    private ParameterModificationService parameterService;
    @Inject
    private PrivateCustomFieldValueService customValueService;
    @Inject
    private TestCaseCallTreeFinder calltreeFinder;
    @Inject
    private AutomatedTestDao autoTestDao;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private AutomationRequestDao requestDao;
    @Inject
    private CallStepManagerService callStepManagerService;
    @Inject
    private TestPlanItemDao testPlanItemDao;
    @Inject
    private CustomSprintReqVersionDao customSprintReqVersionDao;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    @Override
    protected FolderDao<TestCaseFolder, TestCaseLibraryNode> getFolderDao() {
        return this.folderDao;
    }

    @Override
    protected List<SuppressionPreviewReport> diagnoseSuppression(List<Long> nodeIds) {
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        LinkedList<SuppressionPreviewReport> preview = new LinkedList<SuppressionPreviewReport>();
        this.reportLocksByCallSteps(nodeIds, preview);
        this.reportExecutedTestCases(nodeIds, preview);
        this.reportLocksByMilestones(nodeIds, preview);
        if (activeMilestone.isPresent()) {
            List<Long>[] separatedIds = this.deletionDao.separateFolderFromTestCaseIds(nodeIds);
            this.reportNoFoldersAllowed(separatedIds[0], preview);
            this.reportMultipleMilestoneBinding(separatedIds[1], preview);
        }
        return preview;
    }

    protected void reportMultipleMilestoneBinding(List<Long> testCaseIds, List<SuppressionPreviewReport> preview) {
        List<Long> list = testCaseIds;
        TestCaseDao testCaseDao = this.leafDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)testCaseDao, list);
        Object[] objectArray = new Object[]{this, testCaseDao, list, joinPoint};
        TestCaseNodeDeletionHandlerImpl$AjcClosure1 testCaseNodeDeletionHandlerImpl$AjcClosure1 = new TestCaseNodeDeletionHandlerImpl$AjcClosure1(objectArray);
        List boundNodes = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(testCaseNodeDeletionHandlerImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
        if (!boundNodes.isEmpty()) {
            if (testCaseIds.size() == boundNodes.size()) {
                preview.add(new BoundToMultipleMilestonesReport(TEST_CASES_TYPE));
            } else {
                preview.add(new SingleOrMultipleMilestonesReport(TEST_CASES_TYPE));
            }
        }
    }

    protected void reportNoFoldersAllowed(List<Long> folderIds, List<SuppressionPreviewReport> preview) {
        if (!folderIds.isEmpty()) {
            preview.add(new MilestoneModeNoFolderDeletion(TEST_CASES_TYPE));
        }
    }

    protected void reportExecutedTestCases(List<Long> nodeIds, List<SuppressionPreviewReport> preview) {
        LinkedToIterationPreviewReport previewAffectedNodes = this.previewAffectedNodes(nodeIds);
        if (previewAffectedNodes != null) {
            preview.add(previewAffectedNodes);
        }
    }

    protected void reportLocksByCallSteps(List<Long> nodeIds, List<SuppressionPreviewReport> preview) {
        NotDeletablePreviewReport report = this.previewLockedNodes(nodeIds);
        if (report != null) {
            preview.add(report);
        }
    }

    protected void reportLocksByMilestones(List<Long> nodeIds, List<SuppressionPreviewReport> preview) {
        List<Long> lockedNodes = this.deletionDao.findTestCasesWhichMilestonesForbidsDeletion(nodeIds);
        if (!lockedNodes.isEmpty()) {
            preview.add(new BoundToLockedMilestonesReport(TEST_CASES_TYPE));
        }
    }

    @Override
    protected List<Long> detectLockedNodes(List<Long> nodeIds) {
        ArrayList<Long> lockedCandidateIds = new ArrayList<Long>();
        ArrayList<Long> candidateIds = new ArrayList<Long>(nodeIds);
        List<Long> lockedByMilestoneRule = this.getLockedByMilestoneRule(nodeIds);
        lockedCandidateIds.addAll(lockedByMilestoneRule);
        candidateIds.removeAll(lockedByMilestoneRule);
        LockedFileInferenceGraph graph = this.createCallTestCaseGraph(candidateIds);
        graph.setCandidatesToDeletion(candidateIds);
        graph.resolveLockedFiles();
        List<LockedFileInferenceGraph.Node> lockedCandidates = graph.collectLockedCandidates();
        for (LockedFileInferenceGraph.Node node : lockedCandidates) {
            lockedCandidateIds.add(((NamedReference)node.getKey()).getId());
        }
        return lockedCandidateIds;
    }

    @Override
    protected OperationReport batchDeleteNodes(List<Long> ids) {
        OperationReport report = new OperationReport();
        if (!ids.isEmpty()) {
            DeletableIds deletableIds = this.findSeparateIds(ids);
            List<Long> folderIds = deletableIds.getFolderIds();
            List<Long> tcIds = deletableIds.getTestCaseIds();
            List<Long> stepIds = this.deletionDao.findTestSteps(tcIds);
            List<Long> testCaseAttachmentIds = this.deletionDao.findTestCaseAttachmentListIds(tcIds);
            List<Long> testStepAttachmentIds = this.deletionDao.findTestStepAttachmentListIds(stepIds);
            List<Long> testCaseFolderAttachmentIds = this.deletionDao.findTestCaseFolderAttachmentListIds(folderIds);
            testCaseAttachmentIds.addAll(testStepAttachmentIds);
            testCaseAttachmentIds.addAll(testCaseFolderAttachmentIds);
            List<ExternalContentCoordinates> listPairContentIDListID = this.attachmentManager.getListIDbyContentIdForAttachmentLists(testCaseAttachmentIds);
            List automationRequestIds = this.requestDao.getReqIdsByTcIds(tcIds);
            this.deletionDao.removeAutomationRequestLibraryContent(automationRequestIds);
            this.deletionDao.removeCampaignTestPlanInboundReferences(tcIds);
            this.deletionDao.removeOrSetIterationTestPlanInboundReferencesToNull(tcIds);
            this.deletionDao.setExecutionInboundReferencesToNull(tcIds);
            this.deletionDao.setExecStepInboundReferencesToNull(stepIds);
            this.deletionDao.removeFromVerifyingTestStepsList(stepIds);
            this.deletionDao.removeFromVerifyingTestCaseLists(tcIds);
            this.customValueService.deleteAllCustomFieldValues(BindableEntity.TEST_STEP, stepIds);
            this.deletionDao.removeAllSteps(stepIds);
            this.attachmentManager.removeAttachmentsAndLists(testStepAttachmentIds);
            this.customValueService.deleteAllCustomFieldValues(BindableEntity.TESTCASE_FOLDER, folderIds);
            this.customValueService.deleteAllCustomFieldValues(BindableEntity.TEST_CASE, tcIds);
            this.datasetService.removeAllByTestCaseIds(tcIds);
            this.parameterService.removeAllByTestCaseIds(tcIds);
            this.customSprintReqVersionDao.removeTestPlanItemOrNullifyReferencedTestCase(tcIds);
            this.deletionDao.removeEntities(deletableIds.getAllIds());
            this.attachmentManager.deleteContents(listPairContentIDListID);
            report.addRemoved(folderIds, "folder");
            report.addRemoved(tcIds, "test-case");
            this.autoTestDao.pruneOrphans();
        }
        return report;
    }

    @Override
    protected OperationReport batchUnbindFromMilestone(List<Long> ids) {
        List<Long> remainingIds = this.deletionDao.findRemainingTestCaseIds(ids);
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        List<Long> lockedIds = this.deletionDao.findTestCasesWhichMilestonesForbidsDeletion(remainingIds);
        remainingIds.removeAll(lockedIds);
        OperationReport report = new OperationReport();
        this.deletionDao.unbindFromMilestone(remainingIds, activeMilestone.get().getId());
        report.addRemoved(remainingIds, "test-case");
        return report;
    }

    @Override
    public void deleteStep(final TestCase owner, TestStep step) {
        int index = owner.getPositionOfStep(step.getId().longValue());
        if (index == -1) {
            return;
        }
        owner.getSteps().remove(index);
        LinkedList<Long> stepId = new LinkedList<Long>();
        stepId.add(step.getId());
        this.deletionDao.setExecStepInboundReferencesToNull(stepId);
        TestStepVisitor testStepVisitor = new TestStepVisitor(){

            public void visit(ActionTestStep visited) {
                TestCaseNodeDeletionHandlerImpl.this.customValueService.deleteAllCustomFieldValues((BoundEntity)visited);
                TestCaseNodeDeletionHandlerImpl.this.deleteActionStep(visited);
                TestCaseNodeDeletionHandlerImpl.this.customValueService.deleteAllCustomFieldValues((BoundEntity)visited);
            }

            public void visit(CallTestStep visited) {
                TestCaseNodeDeletionHandlerImpl.this.doDeleteTestStep((TestStep)visited);
                TestCaseNodeDeletionHandlerImpl.this.deleteOrphanDatasetParamValues(visited.isDelegateParameterValues(), owner.getId());
                TestCaseNodeDeletionHandlerImpl.this.testCaseImportanceManagerService.changeImportanceIfCallStepRemoved(visited.getCalledTestCase(), owner);
            }

            public void visit(KeywordTestStep visited) {
                TestCaseNodeDeletionHandlerImpl.this.doDeleteTestStep((TestStep)visited);
            }
        };
        step.accept(testStepVisitor);
    }

    protected NotDeletablePreviewReport previewLockedNodes(List<Long> nodeIds) {
        NotDeletablePreviewReport report = null;
        ArrayList<Long> candidateIds = new ArrayList<Long>(nodeIds);
        List<Long> lockedByMilestoneRule = this.getLockedByMilestoneRule(nodeIds);
        candidateIds.removeAll(lockedByMilestoneRule);
        LockedFileInferenceGraph graph = this.createCallTestCaseGraph(candidateIds);
        graph.setCandidatesToDeletion(candidateIds);
        graph.resolveLockedFiles();
        if (graph.hasLockedFiles()) {
            report = new NotDeletablePreviewReport();
            for (LockedFileInferenceGraph.Node node : graph.collectLockedCandidates()) {
                report.addName(node.getName());
            }
            for (LockedFileInferenceGraph.Node node : graph.collectLockers()) {
                report.addWhy(node.getName());
            }
        }
        return report;
    }

    private List<Long> getLockedByMilestoneRule(List<Long> nodeIds) {
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        List<Long> lockedByMilestoneRule = activeMilestone.isPresent() ? this.lockedByMilestoneMilestoneMode(nodeIds, activeMilestone.get().getId()) : this.lockedByMilestoneNormalMode(nodeIds);
        return lockedByMilestoneRule;
    }

    protected LockedFileInferenceGraph createCallTestCaseGraph(List<Long> candidatesId) {
        LibraryGraph<NamedReference, LibraryGraph.SimpleNode<NamedReference>> calltree = this.calltreeFinder.getCallerGraph(candidatesId);
        LockedFileInferenceGraph graph = new LockedFileInferenceGraph();
        graph.init(calltree);
        return graph;
    }

    private LinkedToIterationPreviewReport previewAffectedNodes(List<Long> nodeIds) {
        LinkedToIterationPreviewReport report = null;
        List linkedNodes = this.leafDao.findAllLinkedToIteration(nodeIds);
        if (!linkedNodes.isEmpty()) {
            report = new LinkedToIterationPreviewReport();
            for (TestCase node : linkedNodes) {
                report.addName(node.getName());
            }
        }
        return report;
    }

    private void deleteActionStep(ActionTestStep step) {
        AttachmentList attachmentList = step.getAttachmentList();
        List<ExternalContentCoordinates> listPairContenIDListID = this.getExternalAttachmentContentCoordinatesOfObject((AttachmentHolder)step);
        this.doDeleteTestStep((TestStep)step);
        this.attachmentManager.removeAttachmentsAndLists(this.makeListAttachmentListIdFordAttachmentList(attachmentList));
        this.attachmentManager.deleteContents(listPairContenIDListID);
    }

    private void doDeleteTestStep(TestStep step) {
        this.deletionDao.removeEntity(step);
    }

    private DeletableIds findSeparateIds(List<Long> ids) {
        List<Long>[] separatedIds = this.deletionDao.separateFolderFromTestCaseIds(ids);
        return new DeletableIds(separatedIds[0], separatedIds[1]);
    }

    private List<Long> lockedByMilestoneNormalMode(List<Long> nodeIds) {
        return this.deletionDao.findTestCasesWhichMilestonesForbidsDeletion(nodeIds);
    }

    private List<Long> lockedByMilestoneMilestoneMode(List<Long> nodeIds, Long milestoneId) {
        List<Long> folderIds = this.deletionDao.separateFolderFromTestCaseIds(nodeIds)[0];
        Long l = milestoneId;
        List<Long> list = nodeIds;
        TestCaseDao testCaseDao = this.leafDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)testCaseDao, list, (Object)l);
        Object[] objectArray = new Object[]{this, testCaseDao, list, l, joinPoint};
        TestCaseNodeDeletionHandlerImpl$AjcClosure3 testCaseNodeDeletionHandlerImpl$AjcClosure3 = new TestCaseNodeDeletionHandlerImpl$AjcClosure3(objectArray);
        List outOfMilestone = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(testCaseNodeDeletionHandlerImpl$AjcClosure3.linkClosureAndJoinPoint(4112));
        List<Long> list2 = nodeIds;
        TestCaseDao testCaseDao2 = this.leafDao;
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)testCaseDao2, list2);
        Object[] objectArray2 = new Object[]{this, testCaseDao2, list2, joinPoint2};
        TestCaseNodeDeletionHandlerImpl$AjcClosure5 testCaseNodeDeletionHandlerImpl$AjcClosure5 = new TestCaseNodeDeletionHandlerImpl$AjcClosure5(objectArray2);
        List belongsToMoreMilestones = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(testCaseNodeDeletionHandlerImpl$AjcClosure5.linkClosureAndJoinPoint(4112));
        List<Long> lockedByMilestones = this.deletionDao.findTestCasesWhichMilestonesForbidsDeletion(nodeIds);
        ArrayList<Long> milestoneLocked = new ArrayList<Long>(folderIds.size() + outOfMilestone.size() + belongsToMoreMilestones.size() + lockedByMilestones.size());
        milestoneLocked.addAll(folderIds);
        milestoneLocked.addAll(outOfMilestone);
        milestoneLocked.addAll(belongsToMoreMilestones);
        milestoneLocked.addAll(lockedByMilestones);
        return milestoneLocked;
    }

    private void deleteOrphanDatasetParamValues(boolean isDelegateParameterValues, Long testCaseCallerId) {
        if (isDelegateParameterValues) {
            this.callStepManagerService.deleteOrphanDatasetParamValuesByTestCaseCallerId(testCaseCallerId);
        }
    }

    @Override
    protected boolean isMilestoneMode() {
        return this.activeMilestoneHolder.getActiveMilestone().isPresent();
    }

    static {
        TestCaseNodeDeletionHandlerImpl.ajc$preClinit();
    }

    static final /* synthetic */ List findNodeIdsHavingMultipleMilestones_aroundBody0(TestCaseNodeDeletionHandlerImpl testCaseNodeDeletionHandlerImpl, TestCaseDao testCaseDao, Collection collection, JoinPoint joinPoint) {
        return testCaseDao.findNodeIdsHavingMultipleMilestones(collection);
    }

    static final /* synthetic */ List findNonBoundTestCases_aroundBody2(TestCaseNodeDeletionHandlerImpl testCaseNodeDeletionHandlerImpl, TestCaseDao testCaseDao, Collection collection, Long l, JoinPoint joinPoint) {
        return testCaseDao.findNonBoundTestCases(collection, l);
    }

    static final /* synthetic */ List findNodeIdsHavingMultipleMilestones_aroundBody4(TestCaseNodeDeletionHandlerImpl testCaseNodeDeletionHandlerImpl, TestCaseDao testCaseDao, Collection collection, JoinPoint joinPoint) {
        return testCaseDao.findNodeIdsHavingMultipleMilestones(collection);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TestCaseNodeDeletionHandlerImpl.java", TestCaseNodeDeletionHandlerImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findNodeIdsHavingMultipleMilestones", "org.squashtest.tm.service.internal.repository.TestCaseDao", "java.util.Collection", "arg0", "", "java.util.List"), 153);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findNonBoundTestCases", "org.squashtest.tm.service.internal.repository.TestCaseDao", "java.util.Collection:java.lang.Long", "arg0:arg1", "", "java.util.List"), 509);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findNodeIdsHavingMultipleMilestones", "org.squashtest.tm.service.internal.repository.TestCaseDao", "java.util.Collection", "arg0", "", "java.util.List"), 510);
    }

    private static final class DeletableIds {
        private final List<Long> folderIds;
        private final List<Long> testCaseIds;

        public DeletableIds(List<Long> folderIds, List<Long> testCaseIds) {
            this.folderIds = folderIds;
            this.testCaseIds = testCaseIds;
        }

        public List<Long> getFolderIds() {
            return this.folderIds;
        }

        public List<Long> getTestCaseIds() {
            return this.testCaseIds;
        }

        public List<Long> getAllIds() {
            ArrayList<Long> all = new ArrayList<Long>(this.folderIds.size() + this.testCaseIds.size());
            all.addAll(this.folderIds);
            all.addAll(this.testCaseIds);
            return all;
        }
    }
}

