/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.customreport;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.domain.customreport.CustomReportTreeLibraryNode;
import org.squashtest.tm.domain.tree.TreeLibraryNode;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.internal.customreport.NameResolver;

@Component
public class CRLNCopier {
    @Inject
    private NameResolver nameResolver;

    public List<CustomReportLibraryNode> copyNodes(List<CustomReportLibraryNode> nodes, CustomReportLibraryNode target, ClipboardPayload clipboardPayload) {
        ArrayList<CustomReportLibraryNode> copiedNodes = new ArrayList<CustomReportLibraryNode>();
        for (CustomReportLibraryNode node : nodes) {
            CustomReportLibraryNode copy = this.createFirstLayerCopy(node, target, clipboardPayload);
            this.nameResolver.resolveNewName(copy, target);
            target.addChild((CustomReportTreeLibraryNode)copy);
            copiedNodes.add(copy);
        }
        return copiedNodes;
    }

    private CustomReportLibraryNode createFirstLayerCopy(CustomReportLibraryNode node, CustomReportLibraryNode target, ClipboardPayload clipboardPayload) {
        CustomReportLibraryNode copy = this.createBasicCopy(node, target);
        this.filterAndProcessChildren(node, clipboardPayload, copy);
        return copy;
    }

    private void createSubTreeCopy(CustomReportLibraryNode node, CustomReportLibraryNode target, ClipboardPayload clipboardPayload) {
        CustomReportLibraryNode copy = this.createBasicCopy(node, target);
        target.addChild((CustomReportTreeLibraryNode)copy);
        this.filterAndProcessChildren(node, clipboardPayload, copy);
    }

    private void filterAndProcessChildren(CustomReportLibraryNode node, ClipboardPayload clipboardPayload, CustomReportLibraryNode copy) {
        List<CustomReportTreeLibraryNode> childrenList = node.getChildren();
        if (!clipboardPayload.shouldWhiteListBeIgnored()) {
            childrenList = childrenList.stream().filter(child -> clipboardPayload.getWhiteListNodeIds().contains(child.getId())).toList();
        }
        for (TreeLibraryNode treeLibraryNode : childrenList) {
            this.createSubTreeCopy((CustomReportLibraryNode)treeLibraryNode, copy, clipboardPayload);
        }
    }

    private CustomReportLibraryNode createBasicCopy(CustomReportLibraryNode node, CustomReportLibraryNode target) {
        CustomReportLibraryNode copy = new CustomReportLibraryNode();
        copy.setLibrary(target.getCustomReportLibrary());
        copy.setName(node.getName());
        this.copyTreeEntity(node, copy);
        return copy;
    }

    private void copyTreeEntity(CustomReportLibraryNode node, CustomReportLibraryNode copy) {
        CustomReportTreeEntity treeEntity = node.getEntity().createCopy();
        treeEntity.setProject(copy.getCustomReportLibrary().getProject());
        copy.setEntity(treeEntity);
        copy.setEntityType(node.getEntityType());
    }
}

