/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.customfield;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.MultiValueMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.IdentifiedUtil;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.customfield.RenderingLocation;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.exception.campaign.SprintClosedException;
import org.squashtest.tm.service.annotation.CachableType;
import org.squashtest.tm.service.annotation.CacheResult;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.audit.AuditModificationService;
import org.squashtest.tm.service.internal.copier.BoundEntityCopy;
import org.squashtest.tm.service.internal.customfield.CustomFieldValuesFactoryProvider;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueServiceImpl$AjcClosure11;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueServiceImpl$AjcClosure5;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueServiceImpl$AjcClosure7;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueServiceImpl$AjcClosure9;
import org.squashtest.tm.service.internal.customfield.ValueEditionStatusStrategy;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomFieldCustomExportDto;
import org.squashtest.tm.service.internal.repository.BoundEntityDao;
import org.squashtest.tm.service.internal.repository.CustomFieldBindingDao;
import org.squashtest.tm.service.internal.repository.CustomFieldValueDao;
import org.squashtest.tm.service.internal.repository.CustomReportLibraryNodeDao;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;
import org.squashtest.tm.service.internal.repository.hibernate.customfieldvaluesfactory.AbstractCustomFieldValuesFactory;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service(value="squashtest.tm.service.CustomFieldValueManagerService")
@Transactional
public class PrivateCustomFieldValueServiceImpl
implements PrivateCustomFieldValueService {
    private static final Logger LOGGER;
    @Inject
    CustomReportLibraryNodeDao customReportLibraryNodeDao;
    @Inject
    @Named(value="defaultEditionStatusStrategy")
    private ValueEditionStatusStrategy defaultEditionStatusStrategy;
    @Inject
    @Named(value="requirementBoundEditionStatusStrategy")
    private ValueEditionStatusStrategy requirementBoundEditionStatusStrategy;
    @Inject
    private CustomFieldValueDao customFieldValueDao;
    @Inject
    private CustomFieldBindingDao customFieldBindingDao;
    @Inject
    private BoundEntityDao boundEntityDao;
    @Inject
    private PermissionEvaluationService permissionService;
    @Inject
    private AuditModificationService auditModificationService;
    @Inject
    private CustomFieldValuesFactoryProvider factoryProvider;
    @Inject
    private SprintDisplayDao sprintDisplayDao;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        PrivateCustomFieldValueServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(PrivateCustomFieldValueServiceImpl.class);
    }

    public void setPermissionService(PermissionEvaluationService permissionService) {
        this.permissionService = permissionService;
    }

    @Override
    @Transactional(readOnly=true)
    public boolean hasCustomFields(BoundEntity boundEntity) {
        return this.boundEntityDao.hasCustomField(boundEntity.getBoundEntityId(), boundEntity.getBoundEntityType());
    }

    @Override
    @Transactional(readOnly=true)
    public boolean hasCustomFields(Long boundEntityId, BindableEntity bindableEntity) {
        return this.boundEntityDao.hasCustomField(boundEntityId, bindableEntity);
    }

    @Override
    @Transactional(readOnly=true)
    public List<CustomFieldValue> findAllCustomFieldValues(BoundEntity boundEntity) {
        if (!this.permissionService.canRead(boundEntity) && !this.permissionService.hasRole("ROLE_TA_API_CLIENT")) {
            throw new AccessDeniedException("Access is denied");
        }
        return this.customFieldValueDao.findAllCustomValues(boundEntity.getBoundEntityId(), boundEntity.getBoundEntityType());
    }

    @Override
    @Transactional(readOnly=true)
    public List<CustomFieldValue> findAllCustomFieldValues(long boundEntityId, BindableEntity bindableEntity) {
        BoundEntity boundEntity = this.boundEntityDao.findBoundEntity(boundEntityId, bindableEntity);
        if (!this.permissionService.canRead(boundEntity)) {
            throw new AccessDeniedException("Access is denied");
        }
        return this.findAllCustomFieldValues(boundEntity);
    }

    @Override
    public List<CustomFieldValue> findAllCustomFieldValues(Collection<? extends BoundEntity> boundEntities) {
        Map<BindableEntity, List<Long>> compositeIds = this.breakEntitiesIntoCompositeIds(boundEntities);
        ArrayList<CustomFieldValue> result = new ArrayList<CustomFieldValue>();
        for (Map.Entry<BindableEntity, List<Long>> entry : compositeIds.entrySet()) {
            BindableEntity bindableEntity = entry.getKey();
            Collection collection = entry.getValue();
            CustomFieldValueDao customFieldValueDao = this.customFieldValueDao;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)customFieldValueDao, (Object)collection, (Object)bindableEntity);
            Object[] objectArray = new Object[]{this, customFieldValueDao, collection, bindableEntity, joinPoint};
            PrivateCustomFieldValueServiceImpl$AjcClosure1 privateCustomFieldValueServiceImpl$AjcClosure1 = new PrivateCustomFieldValueServiceImpl$AjcClosure1(objectArray);
            result.addAll((List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(privateCustomFieldValueServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112)));
        }
        return result;
    }

    @Override
    public List<CustomFieldValue> findAllCustomFieldValues(Collection<? extends BoundEntity> boundEntities, Collection<CustomField> restrictedToThoseCustomfields) {
        Map<BindableEntity, List<Long>> compositeIds = this.breakEntitiesIntoCompositeIds(boundEntities);
        ArrayList<CustomFieldValue> result = new ArrayList<CustomFieldValue>();
        for (Map.Entry<BindableEntity, List<Long>> entry : compositeIds.entrySet()) {
            Collection<CustomField> collection = restrictedToThoseCustomfields;
            BindableEntity bindableEntity = entry.getKey();
            List<Long> list = entry.getValue();
            CustomFieldValueDao customFieldValueDao = this.customFieldValueDao;
            Object[] objectArray = new Object[]{list, bindableEntity, collection};
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)customFieldValueDao, (Object[])objectArray);
            Object[] objectArray2 = new Object[]{this, customFieldValueDao, list, bindableEntity, collection, joinPoint};
            PrivateCustomFieldValueServiceImpl$AjcClosure3 privateCustomFieldValueServiceImpl$AjcClosure3 = new PrivateCustomFieldValueServiceImpl$AjcClosure3(objectArray2);
            result.addAll((List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(privateCustomFieldValueServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112)));
        }
        return result;
    }

    @Override
    public List<CustomFieldValue> findAllCustomFieldValuesOfCustomField(long cufId) {
        return this.customFieldValueDao.findAllCustomValuesOfCustomField(cufId);
    }

    @Override
    public void cascadeCustomFieldValuesCreation(CustomFieldBinding binding) {
        BindableEntity boundEntity = binding.getBoundEntity();
        AbstractCustomFieldValuesFactory factory = this.factoryProvider.getFactory(boundEntity);
        factory.insertValues(binding);
    }

    @Override
    public void cascadeCustomFieldValuesCreationNotCreatedFolderYet(CustomFieldBinding binding, BoundEntity entity) {
        CustomFieldValue value = binding.createNewValue();
        value.setBoundEntity(entity);
        this.customFieldValueDao.save(value);
    }

    @Override
    public void batchFolderCustomFieldValuesCreation(List<CustomFieldBinding> bindings, List<? extends BoundEntity> entities) {
        List newValues = entities.stream().flatMap(entity -> bindings.stream().map(binding -> {
            CustomFieldValue value = binding.createNewValue();
            value.setBoundEntity(entity);
            return value;
        })).toList();
        this.customFieldValueDao.saveAll(newValues);
    }

    @Override
    public void cascadeCustomFieldValuesDeletion(CustomFieldBinding binding) {
        this.customFieldValueDao.deleteAllForBinding(binding.getId());
    }

    @Override
    public void cascadeCustomFieldValuesDeletion(List<Long> customFieldBindingIds) {
        this.customFieldValueDao.deleteAllFromBindings(customFieldBindingIds);
    }

    @Override
    public void createAllCustomFieldValues(BoundEntity entity, Project project) {
        this.createAllCustomFieldValues(entity, project, Collections.emptyMap());
    }

    @Override
    public void createAllCustomFieldValues(BoundEntity entity, Project project, Map<Long, RawValue> initialCustomFieldValues) {
        LOGGER.debug("creating customfield values for entity {}#{}", new Object[]{entity.getBoundEntityType(), entity.getBoundEntityId()});
        if (project == null) {
            project = entity.getProject();
        }
        List<CustomFieldBinding> bindings = this.optimizedFindCustomField(entity, project);
        if (LOGGER.isTraceEnabled()) {
            List<String> codes = bindings.stream().map(b -> b.getCustomField().getCode()).toList();
            LOGGER.trace("creating values for customfields : {}", new Object[]{codes});
        }
        List<CustomFieldBinding> whatIsAlreadyBound = this.customFieldBindingDao.findEffectiveBindingsForEntity(entity.getBoundEntityId(), entity.getBoundEntityType());
        bindings.removeAll(whatIsAlreadyBound);
        for (CustomFieldBinding binding : bindings) {
            CustomFieldValue value = binding.createNewValue();
            Long customFieldId = value.getCustomField().getId();
            if (initialCustomFieldValues.containsKey(customFieldId)) {
                RawValue newValue = initialCustomFieldValues.get(customFieldId);
                newValue.setValueFor(value);
            }
            value.setBoundEntity(entity);
            this.customFieldValueDao.save(value);
        }
    }

    @Override
    public void createAllCustomFieldValues(Collection<? extends BoundEntity> entities, Project p) {
        if (entities.isEmpty()) {
            return;
        }
        BoundEntity firstEntity = entities.iterator().next();
        Project project = p;
        if (p == null) {
            project = firstEntity.getProject();
        }
        List<CustomFieldBinding> bindings = this.optimizedFindCustomField(firstEntity, project);
        MultiValueMap bindingPerEntities = this.findEffectiveBindings(entities);
        for (BoundEntity boundEntity : entities) {
            Collection<Object> toBeBound = bindings;
            Collection effectiveBindings = bindingPerEntities.getCollection((Object)boundEntity.getBoundEntityId());
            if (effectiveBindings != null) {
                toBeBound = CollectionUtils.subtract(bindings, (Collection)effectiveBindings);
            }
            for (CustomFieldBinding toBind : toBeBound) {
                CustomFieldValue value = toBind.createNewValue();
                value.setBoundEntity(boundEntity);
                this.customFieldValueDao.save(value);
            }
        }
    }

    @Override
    public void deleteAllCustomFieldValues(BoundEntity entity) {
        this.customFieldValueDao.deleteAllForEntity(entity.getBoundEntityId(), entity.getBoundEntityType());
    }

    @Override
    public void deleteAllCustomFieldValues(BindableEntity entityType, List<Long> entityIds) {
        List<Long> list = entityIds;
        BindableEntity bindableEntity = entityType;
        CustomFieldValueDao customFieldValueDao = this.customFieldValueDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)customFieldValueDao, (Object)bindableEntity, list);
        Object[] objectArray = new Object[]{this, customFieldValueDao, bindableEntity, list, joinPoint};
        PrivateCustomFieldValueServiceImpl$AjcClosure5 privateCustomFieldValueServiceImpl$AjcClosure5 = new PrivateCustomFieldValueServiceImpl$AjcClosure5(objectArray);
        SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(privateCustomFieldValueServiceImpl$AjcClosure5.linkClosureAndJoinPoint(4112));
    }

    @Override
    public void copyCustomFieldValues(BoundEntity source, BoundEntity recipient) {
        List<CustomFieldValue> sourceValues = this.customFieldValueDao.findAllCustomValues(source.getBoundEntityId(), source.getBoundEntityType());
        for (CustomFieldValue value : sourceValues) {
            CustomFieldValue copy = value.copy();
            copy.setBoundEntity(recipient);
            this.customFieldValueDao.save(copy);
        }
    }

    @Override
    public boolean areValuesEditable(long boundEntityId, BindableEntity bindableEntity) {
        return this.editableStrategy(bindableEntity).isEditable(boundEntityId, bindableEntity);
    }

    @Override
    public List<CustomFieldValue> findAllForEntityAndRenderingLocation(BoundEntity boundEntity, RenderingLocation renderingLocation) {
        return this.customFieldValueDao.findAllForEntityAndRenderingLocation(boundEntity.getBoundEntityId(), boundEntity.getBoundEntityType(), renderingLocation);
    }

    @Override
    public void copyCustomFieldValues(Map<Long, BoundEntity> copiedEntityBySourceId, BindableEntity bindableEntityType) {
        if (copiedEntityBySourceId.isEmpty()) {
            return;
        }
        Set<Long> sourceEntitiesIds = copiedEntityBySourceId.keySet();
        BindableEntity bindableEntity = bindableEntityType;
        Set<Long> set = sourceEntitiesIds;
        CustomFieldValueDao customFieldValueDao = this.customFieldValueDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)customFieldValueDao, set, (Object)bindableEntity);
        Object[] objectArray = new Object[]{this, customFieldValueDao, set, bindableEntity, joinPoint};
        PrivateCustomFieldValueServiceImpl$AjcClosure7 privateCustomFieldValueServiceImpl$AjcClosure7 = new PrivateCustomFieldValueServiceImpl$AjcClosure7(objectArray);
        List sourceValues = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(privateCustomFieldValueServiceImpl$AjcClosure7.linkClosureAndJoinPoint(4112));
        for (CustomFieldValue cufSource : sourceValues) {
            BoundEntity targetCopy = copiedEntityBySourceId.get(cufSource.getBoundEntityId());
            CustomFieldValue copy = cufSource.copy();
            copy.setBoundEntity(targetCopy);
            this.customFieldValueDao.save(copy);
        }
    }

    @Override
    public void copyCustomFieldValues(List<BoundEntityCopy> boundEntityCopies) {
        if (boundEntityCopies.isEmpty()) {
            return;
        }
        Map<BindableEntity, List<BoundEntityCopy>> copiesByEntity = boundEntityCopies.stream().collect(Collectors.groupingBy(boundEntityCopy -> boundEntityCopy.copy().getBoundEntityType()));
        for (Map.Entry<BindableEntity, List<BoundEntityCopy>> entry : copiesByEntity.entrySet()) {
            Map<Long, BoundEntity> copiedEntityBySourceId = entry.getValue().stream().collect(Collectors.toMap(BoundEntityCopy::originId, BoundEntityCopy::copy));
            this.copyCustomFieldValues(copiedEntityBySourceId, entry.getKey());
        }
    }

    @Override
    public void copyCustomFieldValuesOnProjectChanged(List<BoundEntityCopy> boundEntityCopies, Long projectId) {
        if (boundEntityCopies.isEmpty()) {
            return;
        }
        Map<BindableEntity, List<BoundEntityCopy>> copiesByEntity = boundEntityCopies.stream().collect(Collectors.groupingBy(boundEntityCopy -> boundEntityCopy.copy().getBoundEntityType()));
        for (Map.Entry<BindableEntity, List<BoundEntityCopy>> entry : copiesByEntity.entrySet()) {
            Map<Long, BoundEntity> copiedEntityBySource = entry.getValue().stream().collect(Collectors.toMap(BoundEntityCopy::originId, BoundEntityCopy::copy));
            this.copyCustomFieldValuesOnProjectChanged(entry.getKey(), copiedEntityBySource, projectId);
        }
    }

    private void copyCustomFieldValuesOnProjectChanged(BindableEntity bindableEntity, Map<Long, BoundEntity> copyBySourceId, Long projectId) {
        BindableEntity bindableEntity2 = bindableEntity;
        Set<Long> set = copyBySourceId.keySet();
        CustomFieldValueDao customFieldValueDao = this.customFieldValueDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)customFieldValueDao, set, (Object)bindableEntity2);
        Object[] objectArray = new Object[]{this, customFieldValueDao, set, bindableEntity2, joinPoint};
        PrivateCustomFieldValueServiceImpl$AjcClosure9 privateCustomFieldValueServiceImpl$AjcClosure9 = new PrivateCustomFieldValueServiceImpl$AjcClosure9(objectArray);
        Map<Long, List<CustomFieldValue>> sourceValues = ((List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(privateCustomFieldValueServiceImpl$AjcClosure9.linkClosureAndJoinPoint(4112))).stream().collect(Collectors.groupingBy(cfv -> cfv.getCustomField().getId()));
        List<CustomFieldBinding> projectBindings = this.optimizedFindCustomField(bindableEntity, projectId);
        for (CustomFieldBinding binding : projectBindings) {
            List values = sourceValues.getOrDefault(binding.getCustomField().getId(), Collections.emptyList());
            if (values.isEmpty()) {
                for (BoundEntity entity : copyBySourceId.values()) {
                    CustomFieldValue updatedCUFValue = binding.createNewValue();
                    updatedCUFValue.setBoundEntity(entity);
                    this.customFieldValueDao.save(updatedCUFValue);
                }
                continue;
            }
            for (CustomFieldValue cufSource : values) {
                BoundEntity targetCopy = copyBySourceId.get(cufSource.getBoundEntityId());
                CustomFieldValue copy = cufSource.copy();
                copy.setBinding(binding);
                copy.setBoundEntity(targetCopy);
                this.customFieldValueDao.save(copy);
            }
        }
    }

    @Override
    public void copyCustomFieldValuesContent(BoundEntity source, BoundEntity recipient) {
        List<CustomFieldValueDao.CustomFieldValuesPair> pairs = this.customFieldValueDao.findPairedCustomFieldValues(source.getBoundEntityType(), source.getBoundEntityId(), recipient.getBoundEntityId());
        for (CustomFieldValueDao.CustomFieldValuesPair pair : pairs) {
            pair.copyContent();
        }
    }

    @Override
    public void changeValue(long customFieldValueId, RawValue newValue) {
        CustomFieldValue changedValue = (CustomFieldValue)this.customFieldValueDao.getReferenceById(customFieldValueId);
        BoundEntity boundEntity = this.boundEntityDao.findBoundEntity(changedValue);
        this.checkParentSprintStatus(boundEntity);
        if (!this.permissionService.hasMoreThanRead(boundEntity)) {
            throw new AccessDeniedException("access is denied");
        }
        newValue.setValueFor(changedValue);
        this.auditModificationService.updateRelatedToCustomFieldAuditableEntity(boundEntity);
    }

    private void checkParentSprintStatus(BoundEntity boundEntity) {
        SprintStatus sprintStatus;
        if (BindableEntity.EXECUTION.equals((Object)boundEntity.getBoundEntityType()) ? SprintStatus.CLOSED.equals((Object)(sprintStatus = this.sprintDisplayDao.getSprintStatusByExecutionId(boundEntity.getBoundEntityId()))) : BindableEntity.EXECUTION_STEP.equals((Object)boundEntity.getBoundEntityType()) && SprintStatus.CLOSED.equals((Object)(sprintStatus = this.sprintDisplayDao.getSprintStatusByExecutionStepId(boundEntity.getBoundEntityId())))) {
            throw new SprintClosedException();
        }
    }

    @CacheResult(type=CachableType.CUSTOM_FIELD)
    private List<CustomFieldBinding> optimizedFindCustomField(BoundEntity entity) {
        return this.customFieldBindingDao.findAllForProjectAndEntity(entity.getProject().getId(), entity.getBoundEntityType());
    }

    @CacheResult(type=CachableType.CUSTOM_FIELD)
    private List<CustomFieldBinding> optimizedFindCustomField(BoundEntity entity, Project project) {
        return this.customFieldBindingDao.findAllForProjectAndEntity(project.getId(), entity.getBoundEntityType());
    }

    private List<CustomFieldBinding> optimizedFindCustomField(BindableEntity bindableEntity, Long projectId) {
        return this.customFieldBindingDao.findAllForProjectAndEntity(projectId, bindableEntity);
    }

    @Override
    public void migrateCustomFieldValues(BoundEntity entity) {
        List<CustomFieldValue> valuesToUpdate = this.customFieldValueDao.findAllCustomValues(entity.getBoundEntityId(), entity.getBoundEntityType());
        if (entity.getProject() != null) {
            List valueIds = IdentifiedUtil.extractIds(valuesToUpdate);
            this.customFieldValueDao.deleteAllById(valueIds);
            List<CustomFieldBinding> projectBindings = this.optimizedFindCustomField(entity);
            for (CustomFieldBinding binding : projectBindings) {
                CustomFieldValue updatedCUFValue = binding.createNewValue();
                this.findUpdatedCufValue(valuesToUpdate, updatedCUFValue);
                updatedCUFValue.setBoundEntity(entity);
                this.customFieldValueDao.save(updatedCUFValue);
            }
        }
    }

    private void findUpdatedCufValue(List<CustomFieldValue> valuesToUpdate, CustomFieldValue updatedCUFValue) {
        for (CustomFieldValue formerCUFValue : valuesToUpdate) {
            if (!formerCUFValue.representsSameCustomField(updatedCUFValue)) continue;
            RawValue rawValue = formerCUFValue.asRawValue();
            rawValue.setValueFor(updatedCUFValue);
            break;
        }
    }

    @Override
    public void migrateCustomFieldValues(Collection<BoundEntity> entities) {
        for (BoundEntity entity : entities) {
            this.migrateCustomFieldValues(entity);
        }
    }

    @Override
    public Map<EntityReference, Map<Long, Object>> getCufValueMapByEntityRef(List<EntityReference> scopeEntities, Map<EntityType, List<Long>> cufIdsMapByEntityType) {
        return this.customFieldValueDao.getCufValuesMapByEntityReference(scopeEntities, cufIdsMapByEntityType);
    }

    @Override
    public List<CustomFieldCustomExportDto> findAllAvailableCufsForCustomExport(List<Long> projectIds) {
        return this.customFieldValueDao.findAllAvailableForCustomExportByProjectIds(projectIds);
    }

    @Override
    public Map<Long, List<CustomFieldValue>> getCufValuesMapByBoundEntity(List<? extends BoundEntity> boundEntities) {
        if (boundEntities.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<BindableEntity, List<Long>> compositeIds = this.breakEntitiesIntoCompositeIds(boundEntities);
        if (compositeIds.size() != 1) {
            throw new IllegalArgumentException("All entities must be of the same type");
        }
        Map.Entry<BindableEntity, List<Long>> entry = compositeIds.entrySet().iterator().next();
        return this.customFieldValueDao.getCufValuesMapByBoundEntity(entry.getKey(), entry.getValue());
    }

    private Map<BindableEntity, List<Long>> breakEntitiesIntoCompositeIds(Collection<? extends BoundEntity> boundEntities) {
        EnumMap<BindableEntity, List<Long>> segregatedEntities = new EnumMap<BindableEntity, List<Long>>(BindableEntity.class);
        for (BoundEntity boundEntity : boundEntities) {
            ArrayList<Long> idList = (ArrayList<Long>)segregatedEntities.get(boundEntity.getBoundEntityType());
            if (idList == null) {
                idList = new ArrayList<Long>();
                segregatedEntities.put(boundEntity.getBoundEntityType(), idList);
            }
            idList.add(boundEntity.getBoundEntityId());
        }
        return segregatedEntities;
    }

    private MultiValueMap findEffectiveBindings(Collection<? extends BoundEntity> entities) {
        BindableEntity type;
        Map<BindableEntity, List<Long>> compositeIds = this.breakEntitiesIntoCompositeIds(entities);
        Map.Entry<BindableEntity, List<Long>> firstEntry = compositeIds.entrySet().iterator().next();
        List<Long> entityIds = firstEntry.getValue();
        BindableEntity bindableEntity = type = firstEntry.getKey();
        List<Long> list = entityIds;
        CustomFieldBindingDao customFieldBindingDao = this.customFieldBindingDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)customFieldBindingDao, list, (Object)bindableEntity);
        Object[] objectArray = new Object[]{this, customFieldBindingDao, list, bindableEntity, joinPoint};
        PrivateCustomFieldValueServiceImpl$AjcClosure11 privateCustomFieldValueServiceImpl$AjcClosure11 = new PrivateCustomFieldValueServiceImpl$AjcClosure11(objectArray);
        List whatIsAlreadyBound = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(privateCustomFieldValueServiceImpl$AjcClosure11.linkClosureAndJoinPoint(4112));
        MultiValueMap bindingsPerEntity = new MultiValueMap();
        for (Object[] tuple : whatIsAlreadyBound) {
            Long entityId = (Long)tuple[0];
            CustomFieldBinding binding = (CustomFieldBinding)tuple[1];
            bindingsPerEntity.put((Object)entityId, (Object)binding);
        }
        return bindingsPerEntity;
    }

    private ValueEditionStatusStrategy editableStrategy(BindableEntity bindableEntity) {
        if (bindableEntity.equals((Object)BindableEntity.REQUIREMENT_VERSION)) {
            return this.requirementBoundEditionStatusStrategy;
        }
        return this.defaultEditionStatusStrategy;
    }

    @Override
    public void initCustomFieldValues(BoundEntity entity, Map<Long, RawValue> initialCustomFieldValues) {
        List<CustomFieldValue> persistentValues = this.findAllCustomFieldValues(entity);
        for (CustomFieldValue value : persistentValues) {
            Long customFieldId = value.getCufId();
            if (!initialCustomFieldValues.containsKey(customFieldId)) continue;
            RawValue newValue = initialCustomFieldValues.get(customFieldId);
            newValue.setValueFor(value);
        }
    }

    @Override
    public void initBatchCustomFieldValues(Map<? extends BoundEntity, Map<Long, RawValue>> cufByEntity) {
        if (cufByEntity.isEmpty()) {
            return;
        }
        Map<Long, List<CustomFieldValue>> customFieldValuesByEntityId = this.getCufValuesMapByBoundEntity(new ArrayList<BoundEntity>(cufByEntity.keySet()));
        if (customFieldValuesByEntityId.isEmpty()) {
            return;
        }
        for (Map.Entry<? extends BoundEntity, Map<Long, RawValue>> entry : cufByEntity.entrySet()) {
            Long entityId = entry.getKey().getBoundEntityId();
            Map<Long, RawValue> initialCustomFieldValues = entry.getValue();
            List<CustomFieldValue> customFieldValues = customFieldValuesByEntityId.get(entityId);
            if (initialCustomFieldValues == null || customFieldValues == null) continue;
            for (CustomFieldValue customFieldValue : customFieldValues) {
                Long customFieldId = customFieldValue.getCufId();
                RawValue newValue = initialCustomFieldValues.get(customFieldId);
                if (newValue == null) continue;
                newValue.setValueFor(customFieldValue);
            }
        }
    }

    static final /* synthetic */ List batchedFindAllCustomValuesFor_aroundBody0(PrivateCustomFieldValueServiceImpl privateCustomFieldValueServiceImpl, CustomFieldValueDao customFieldValueDao, Collection collection, BindableEntity bindableEntity, JoinPoint joinPoint) {
        return customFieldValueDao.batchedFindAllCustomValuesFor(collection, bindableEntity);
    }

    static final /* synthetic */ List batchedRestrictedFindAllCustomValuesFor_aroundBody2(PrivateCustomFieldValueServiceImpl privateCustomFieldValueServiceImpl, CustomFieldValueDao customFieldValueDao, List list, BindableEntity bindableEntity, Collection collection, JoinPoint joinPoint) {
        return customFieldValueDao.batchedRestrictedFindAllCustomValuesFor(list, bindableEntity, collection);
    }

    static final /* synthetic */ void deleteAllForEntities_aroundBody4(PrivateCustomFieldValueServiceImpl privateCustomFieldValueServiceImpl, CustomFieldValueDao customFieldValueDao, BindableEntity bindableEntity, List list, JoinPoint joinPoint) {
        customFieldValueDao.deleteAllForEntities(bindableEntity, list);
    }

    static final /* synthetic */ List batchedFindAllCustomValuesFor_aroundBody6(PrivateCustomFieldValueServiceImpl privateCustomFieldValueServiceImpl, CustomFieldValueDao customFieldValueDao, Collection collection, BindableEntity bindableEntity, JoinPoint joinPoint) {
        return customFieldValueDao.batchedFindAllCustomValuesFor(collection, bindableEntity);
    }

    static final /* synthetic */ List batchedFindAllCustomValuesFor_aroundBody8(PrivateCustomFieldValueServiceImpl privateCustomFieldValueServiceImpl, CustomFieldValueDao customFieldValueDao, Collection collection, BindableEntity bindableEntity, JoinPoint joinPoint) {
        return customFieldValueDao.batchedFindAllCustomValuesFor(collection, bindableEntity);
    }

    static final /* synthetic */ List findEffectiveBindingsForEntities_aroundBody10(PrivateCustomFieldValueServiceImpl privateCustomFieldValueServiceImpl, CustomFieldBindingDao customFieldBindingDao, List list, BindableEntity bindableEntity, JoinPoint joinPoint) {
        return customFieldBindingDao.findEffectiveBindingsForEntities(list, bindableEntity);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PrivateCustomFieldValueServiceImpl.java", PrivateCustomFieldValueServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "batchedFindAllCustomValuesFor", "org.squashtest.tm.service.internal.repository.CustomFieldValueDao", "java.util.Collection:org.squashtest.tm.domain.customfield.BindableEntity", "arg0:arg1", "", "java.util.List"), 152);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "batchedRestrictedFindAllCustomValuesFor", "org.squashtest.tm.service.internal.repository.CustomFieldValueDao", "java.util.List:org.squashtest.tm.domain.customfield.BindableEntity:java.util.Collection", "arg0:arg1:arg2", "", "java.util.List"), 172);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "deleteAllForEntities", "org.squashtest.tm.service.internal.repository.CustomFieldValueDao", "org.squashtest.tm.domain.customfield.BindableEntity:java.util.List", "arg0:arg1", "", "void"), 338);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "batchedFindAllCustomValuesFor", "org.squashtest.tm.service.internal.repository.CustomFieldValueDao", "java.util.Collection:org.squashtest.tm.domain.customfield.BindableEntity", "arg0:arg1", "", "java.util.List"), 383);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "batchedFindAllCustomValuesFor", "org.squashtest.tm.service.internal.repository.CustomFieldValueDao", "java.util.Collection:org.squashtest.tm.domain.customfield.BindableEntity", "arg0:arg1", "", "java.util.List"), 440);
        ajc$tjp_5 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findEffectiveBindingsForEntities", "org.squashtest.tm.service.internal.repository.CustomFieldBindingDao", "java.util.List:org.squashtest.tm.domain.customfield.BindableEntity", "entityIds:entityType", "", "java.util.List"), 640);
    }
}

