/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.ObjectIdentityRetrievalStrategy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.PreventConcurrent;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.audit.AuditModificationService;
import org.squashtest.tm.service.campaign.CreatedTestPlanItems;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.campaign.TestSuiteTestPlanManagerService;
import org.squashtest.tm.service.internal.campaign.TestSuiteTestPlanManagerServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.campaign.TestSuiteTestPlanManagerServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.campaign.TestSuiteTestPlanManagerServiceImpl$AjcClosure5;
import org.squashtest.tm.service.internal.campaign.TestSuiteTestPlanManagerServiceImpl$AjcClosure7;
import org.squashtest.tm.service.internal.dto.ExecutionSummaryDto;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.internal.repository.TestSuiteDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.security.acls.model.ObjectAclService;

@Service(value="squashtest.tm.service.TestSuiteTestPlanManagerService")
@Transactional
public class TestSuiteTestPlanManagerServiceImpl
implements TestSuiteTestPlanManagerService {
    private static final String HAS_LINK_PERMISSION_ID = "hasPermission(#suiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'LINK') ";
    private static final String HAS_LINK_PERMISSION_OBJECT = "hasPermission(#testSuite, 'LINK') ";
    @Inject
    private IterationTestPlanManagerService delegateIterationTestPlanManagerService;
    @Inject
    private TestSuiteDao testSuiteDao;
    @Inject
    private IterationTestPlanDao itemTestPlanDao;
    @Inject
    private CustomTestSuiteModificationService customTestSuiteModificationService;
    @Inject
    private AuditModificationService auditModificationService;
    @Inject
    @Qualifier(value="squashtest.core.security.ObjectIdentityRetrievalStrategy")
    private ObjectIdentityRetrievalStrategy objIdRetrievalStrategy;
    @Inject
    private ObjectAclService aclService;
    @Inject
    private UserDao userDao;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#testSuiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'READ')  or hasRole('ROLE_ADMIN')")
    public TestSuite findTestSuite(long testSuiteId) {
        return (TestSuite)this.testSuiteDao.getReferenceById(testSuiteId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#suiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'LINK')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=TestSuite.class)
    public void bindTestPlan(@Id long suiteId, List<Long> itemTestPlanIds) {
        TestSuite suite = (TestSuite)this.testSuiteDao.getReferenceById(suiteId);
        suite.bindTestPlanItemsById(itemTestPlanIds);
        this.customTestSuiteModificationService.updateExecutionStatus(List.of(suite));
        this.auditModificationService.updateAuditable((AuditableMixin)suite);
        this.auditModificationService.updateAuditable((AuditableMixin)suite.getIteration());
    }

    @Override
    public void bindTestPlanToMultipleSuites(List<Long> suiteIds, List<Long> itemTestPlanIds) {
        for (Long id : suiteIds) {
            this.bindTestPlan(id, itemTestPlanIds);
        }
    }

    @PreAuthorize(value="hasPermission(#testSuite, 'LINK')  or hasRole('ROLE_ADMIN')")
    public void bindTestPlanObj(TestSuite testSuite, List<IterationTestPlanItem> itemTestPlans) {
        testSuite.bindTestPlanItems(itemTestPlans);
        this.auditModificationService.updateAuditable((AuditableMixin)testSuite);
        this.auditModificationService.updateAuditable((AuditableMixin)testSuite.getIteration());
    }

    @PreAuthorize(value="hasPermission(#testSuite, 'LINK')  or hasRole('ROLE_ADMIN')")
    public void unbindTestPlanObj(TestSuite testSuite, List<IterationTestPlanItem> itemTestPlans) {
        testSuite.unBindTestPlan(itemTestPlans);
        this.customTestSuiteModificationService.updateExecutionStatus(List.of(testSuite));
        this.auditModificationService.updateAuditable((AuditableMixin)testSuite);
        this.auditModificationService.updateAuditable((AuditableMixin)testSuite.getIteration());
    }

    private void unbindTestPlanToMultipleSuites(List<Long> unboundTestSuiteIds, List<Long> itpIds) {
        List unboundTestSuites = this.testSuiteDao.findAllById(unboundTestSuiteIds);
        List<Long> list = itpIds;
        IterationTestPlanDao iterationTestPlanDao = this.itemTestPlanDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)iterationTestPlanDao, list);
        Object[] objectArray = new Object[]{this, iterationTestPlanDao, list, joinPoint};
        TestSuiteTestPlanManagerServiceImpl$AjcClosure1 testSuiteTestPlanManagerServiceImpl$AjcClosure1 = new TestSuiteTestPlanManagerServiceImpl$AjcClosure1(objectArray);
        List iterationTestPlanItems = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(testSuiteTestPlanManagerServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
        for (TestSuite suite : unboundTestSuites) {
            this.unbindTestPlanObj(suite, iterationTestPlanItems);
        }
    }

    @Override
    public void unbindAllTestPlansFromTestPlanItem(List<Long> itemIds) {
        List<Long> list = itemIds;
        IterationTestPlanDao iterationTestPlanDao = this.itemTestPlanDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)iterationTestPlanDao, list);
        Object[] objectArray = new Object[]{this, iterationTestPlanDao, list, joinPoint};
        TestSuiteTestPlanManagerServiceImpl$AjcClosure3 testSuiteTestPlanManagerServiceImpl$AjcClosure3 = new TestSuiteTestPlanManagerServiceImpl$AjcClosure3(objectArray);
        List items = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(testSuiteTestPlanManagerServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112));
        HashSet affectedTestSuites = new HashSet();
        items.forEach(item -> {
            boolean bl = affectedTestSuites.addAll(item.getTestSuites().stream().map(TestSuite::getId).collect(Collectors.toSet()));
        });
        this.unbindTestPlanToMultipleSuites(new ArrayList<Long>(affectedTestSuites), itemIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#suiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'LINK')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=TestSuite.class)
    public void changeTestPlanPosition(@Id long suiteId, int newIndex, List<Long> itemIds) {
        TestSuite suite = (TestSuite)this.testSuiteDao.getReferenceById(suiteId);
        List<Long> list = itemIds;
        long l = suiteId;
        TestSuiteDao testSuiteDao = this.testSuiteDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)testSuiteDao, (Object)Conversions.longObject((long)l), list);
        Object[] objectArray = new Object[]{this, testSuiteDao, Conversions.longObject((long)l), list, joinPoint};
        TestSuiteTestPlanManagerServiceImpl$AjcClosure5 testSuiteTestPlanManagerServiceImpl$AjcClosure5 = new TestSuiteTestPlanManagerServiceImpl$AjcClosure5(objectArray);
        List items = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(testSuiteTestPlanManagerServiceImpl$AjcClosure5.linkClosureAndJoinPoint(4112));
        suite.reorderTestPlan(newIndex, items);
    }

    @Override
    @PreAuthorize(value="hasPermission(#suiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'LINK')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestSuite.class, paramName="suiteId")
    @CheckBlockingMilestone(entityType=TestSuite.class)
    public CreatedTestPlanItems addTestCasesToIterationAndTestSuite(List<Long> testCaseIds, @Id long suiteId) {
        return this.addTestCasesToIterationAndTestSuiteUnsecured(testCaseIds, suiteId);
    }

    @Override
    public CreatedTestPlanItems addTestCasesToIterationAndTestSuiteUnsecured(List<Long> testCaseIds, @Id long suiteId) {
        TestSuite testSuite = (TestSuite)this.testSuiteDao.getReferenceById(suiteId);
        Iteration iteration = testSuite.getIteration();
        CreatedTestPlanItems listTestPlanItemsToAffectToTestSuite = this.delegateIterationTestPlanManagerService.addTestPlanItemsToIteration(testCaseIds, iteration);
        List<IterationTestPlanItem> itemTestPlans = this.delegateIterationTestPlanManagerService.findTestPlanItems(listTestPlanItemsToAffectToTestSuite.getItemTestPlanIds());
        this.bindTestPlanObj(testSuite, itemTestPlans);
        this.customTestSuiteModificationService.updateExecutionStatus(List.of(testSuite));
        this.auditModificationService.updateAuditable((AuditableMixin)testSuite);
        return listTestPlanItemsToAffectToTestSuite;
    }

    @Override
    @PreAuthorize(value="hasPermission(#suiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'LINK')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestSuite.class, paramName="suiteId")
    @CheckBlockingMilestone(entityType=TestSuite.class)
    public void detachTestPlanFromTestSuite(List<Long> testPlanIds, @Id long suiteId) {
        TestSuite testSuite = (TestSuite)this.testSuiteDao.getReferenceById(suiteId);
        ArrayList<IterationTestPlanItem> listTestPlanItems = new ArrayList<IterationTestPlanItem>();
        for (long testPlanId : testPlanIds) {
            IterationTestPlanItem iterTestPlanItem = (IterationTestPlanItem)this.itemTestPlanDao.getReferenceById(testPlanId);
            listTestPlanItems.add(iterTestPlanItem);
        }
        this.unbindTestPlanObj(testSuite, listTestPlanItems);
        this.customTestSuiteModificationService.updateExecutionStatus(List.of(testSuite));
    }

    @Override
    @Transactional
    @PreAuthorize(value="hasPermission(#suiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'LINK')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=TestSuite.class, paramName="suiteId")
    @CheckBlockingMilestone(entityType=TestSuite.class)
    public boolean detachTestPlanFromTestSuiteAndRemoveFromIteration(List<Long> testPlanIds, @Id long suiteId) {
        TestSuite testSuite = (TestSuite)this.testSuiteDao.getReferenceById(suiteId);
        Iteration iteration = testSuite.getIteration();
        this.auditModificationService.updateAuditable((AuditableMixin)testSuite);
        return this.delegateIterationTestPlanManagerService.removeTestPlansFromIterationObj(testPlanIds, iteration);
    }

    @Override
    public List<User> findAssignableUserForTestPlan(long testSuiteId) {
        List<String> loginList;
        TestSuite testSuite = (TestSuite)this.testSuiteDao.findById(testSuiteId).get();
        ArrayList<ObjectIdentity> entityRefs = new ArrayList<ObjectIdentity>();
        ObjectIdentity oid = this.objIdRetrievalStrategy.getObjectIdentity((Object)testSuite);
        entityRefs.add(oid);
        List<String> list = loginList = this.aclService.findUsersWithExecutePermission(entityRefs);
        UserDao userDao = this.userDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)userDao, list);
        Object[] objectArray = new Object[]{this, userDao, list, joinPoint};
        TestSuiteTestPlanManagerServiceImpl$AjcClosure7 testSuiteTestPlanManagerServiceImpl$AjcClosure7 = new TestSuiteTestPlanManagerServiceImpl$AjcClosure7(objectArray);
        return (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(testSuiteTestPlanManagerServiceImpl$AjcClosure7.linkClosureAndJoinPoint(4112));
    }

    @Override
    public Map<Long, List<ExecutionSummaryDto>> getLastExecutionStatuses(Collection<Long> itemTestPlanIds) {
        return this.delegateIterationTestPlanManagerService.getLastExecutionStatuses(itemTestPlanIds);
    }

    static {
        TestSuiteTestPlanManagerServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ List findAllByIdIn_aroundBody0(TestSuiteTestPlanManagerServiceImpl testSuiteTestPlanManagerServiceImpl, IterationTestPlanDao iterationTestPlanDao, Collection collection, JoinPoint joinPoint) {
        return iterationTestPlanDao.findAllByIdIn(collection);
    }

    static final /* synthetic */ List findAllByIdIn_aroundBody2(TestSuiteTestPlanManagerServiceImpl testSuiteTestPlanManagerServiceImpl, IterationTestPlanDao iterationTestPlanDao, Collection collection, JoinPoint joinPoint) {
        return iterationTestPlanDao.findAllByIdIn(collection);
    }

    static final /* synthetic */ List findTestPlanPartition_aroundBody4(TestSuiteTestPlanManagerServiceImpl testSuiteTestPlanManagerServiceImpl, TestSuiteDao testSuiteDao, long l, List list, JoinPoint joinPoint) {
        return testSuiteDao.findTestPlanPartition(l, list);
    }

    static final /* synthetic */ List findUsersByLoginList_aroundBody6(TestSuiteTestPlanManagerServiceImpl testSuiteTestPlanManagerServiceImpl, UserDao userDao, List list, JoinPoint joinPoint) {
        return userDao.findUsersByLoginList(list);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TestSuiteTestPlanManagerServiceImpl.java", TestSuiteTestPlanManagerServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findAllByIdIn", "org.squashtest.tm.service.internal.repository.IterationTestPlanDao", "java.util.Collection", "arg0", "", "java.util.List"), 139);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findAllByIdIn", "org.squashtest.tm.service.internal.repository.IterationTestPlanDao", "java.util.Collection", "arg0", "", "java.util.List"), 147);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findTestPlanPartition", "org.squashtest.tm.service.internal.repository.TestSuiteDao", "long:java.util.List", "arg0:arg1", "", "java.util.List"), 164);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findUsersByLoginList", "org.squashtest.tm.service.internal.repository.UserDao", "java.util.List", "arg0", "", "java.util.List"), 244);
    }
}

