/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.ObjectIdentityRetrievalStrategy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.campaign.SprintClosedException;
import org.squashtest.tm.exception.campaign.SprintNotLinkableException;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.campaign.SprintTestPlanItemManagerService;
import org.squashtest.tm.service.execution.ExecutionFinder;
import org.squashtest.tm.service.internal.campaign.CampaignNodeDeletionHandler;
import org.squashtest.tm.service.internal.campaign.SprintTestPlanItemManagerServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.repository.SprintReqVersionDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;
import org.squashtest.tm.service.internal.repository.display.SprintTestPlanItemDisplayDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;
import org.squashtest.tm.service.security.acls.model.ObjectAclService;

@Service
@Transactional
public class SprintTestPlanItemManagerServiceImpl
implements SprintTestPlanItemManagerService {
    private final CampaignNodeDeletionHandler deletionHandler;
    private final PermissionEvaluationService permissionEvaluationService;
    private final ExecutionFinder executionFinder;
    private final UserDao userDao;
    private final SprintTestPlanItemDisplayDao sprintTestPlanItemDisplayDao;
    private final ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy;
    private final ObjectAclService objectAclService;
    private final SprintReqVersionDao sprintReqVersionDao;
    private final SprintDisplayDao sprintDisplayDao;
    @PersistenceContext
    private EntityManager entityManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public SprintTestPlanItemManagerServiceImpl(CampaignNodeDeletionHandler deletionHandler, PermissionEvaluationService permissionEvaluationService, ExecutionFinder executionFinder, UserDao userDao, SprintTestPlanItemDisplayDao sprintTestPlanItemDisplayDao, @Qualifier(value="squashtest.core.security.ObjectIdentityRetrievalStrategy") ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy, ObjectAclService objectAclService, SprintReqVersionDao sprintReqVersionDao, SprintDisplayDao sprintDisplayDao) {
        this.deletionHandler = deletionHandler;
        this.permissionEvaluationService = permissionEvaluationService;
        this.executionFinder = executionFinder;
        this.userDao = userDao;
        this.sprintTestPlanItemDisplayDao = sprintTestPlanItemDisplayDao;
        this.objectIdentityRetrievalStrategy = objectIdentityRetrievalStrategy;
        this.objectAclService = objectAclService;
        this.sprintReqVersionDao = sprintReqVersionDao;
        this.sprintDisplayDao = sprintDisplayDao;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testPlanItemId, 'org.squashtest.tm.domain.campaign.testplan.TestPlanItem' ,'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public void changeDataset(long testPlanItemId, Long datasetId) {
        TestPlanItem item = this.findTestPlanItemAndCheckSprintStatus(testPlanItemId);
        if (datasetId == null) {
            item.setReferencedDataset(null);
        } else {
            Dataset dataset = (Dataset)this.entityManager.find(Dataset.class, (Object)datasetId);
            item.setReferencedDataset(dataset);
        }
    }

    @Override
    public void deleteExecutionsAndRemoveFromTestPlanItem(List<Long> executionIds, long testPlanItemId) {
        this.checkParentSprintStatus(testPlanItemId);
        this.checkDeletePermission(executionIds);
        List<Execution> executions = this.executionFinder.findAllById(executionIds);
        this.deletionHandler.deleteExecutions(executions);
        TestPlanItem testPlanItem = (TestPlanItem)this.entityManager.find(TestPlanItem.class, (Object)testPlanItemId);
        testPlanItem.removeExecutionsById(executionIds);
    }

    private void checkParentSprintStatus(long testPlanItemId) {
        SprintStatus sprintStatus = this.sprintDisplayDao.getSprintStatusByTestPlanItemId(testPlanItemId);
        if (SprintStatus.CLOSED.equals((Object)sprintStatus)) {
            throw new SprintClosedException();
        }
    }

    private void checkDeletePermission(List<Long> executionIds) {
        PermissionsUtils.checkPermission(this.permissionEvaluationService, executionIds, Permissions.WRITE.name(), Execution.class.getName());
    }

    @Override
    public void applyFastPass(List<Long> testPlanItemIds, String statusName) {
        PermissionsUtils.checkPermission(this.permissionEvaluationService, testPlanItemIds, Permissions.EXECUTE.name(), TestPlanItem.class.getName());
        List<SprintReqVersion> sprintReqVersions = this.sprintReqVersionDao.findWithSprintByTestPlanItemIds(testPlanItemIds);
        Map<SprintReqVersion, List> testPlanItemsBySprintReqVersion = sprintReqVersions.stream().collect(Collectors.toMap(sprintReqVersion -> sprintReqVersion, sprintReqVersion -> sprintReqVersion.getTestPlan().getTestPlanItems().stream().filter(item -> testPlanItemIds.contains(item.getId())).toList()));
        ExecutionStatus status = ExecutionStatus.valueOf((String)statusName);
        String login = UserContextHolder.getUsername();
        User user = this.userDao.findUserByLogin(login);
        if (testPlanItemsBySprintReqVersion.entrySet().stream().allMatch(entry -> SprintStatus.CLOSED.equals((Object)((SprintReqVersion)entry.getKey()).getSprint().getStatus()))) {
            throw new SprintClosedException();
        }
        testPlanItemsBySprintReqVersion.forEach((sprintReqVersion, testPlanItems) -> {
            if (!SprintStatus.CLOSED.equals((Object)sprintReqVersion.getSprint().getStatus())) {
                testPlanItems.forEach(testPlanItem -> testPlanItem.applyFastPass(status, user));
            }
        });
    }

    @Override
    @PreAuthorize(value="hasPermission(#testPlanItemId, 'org.squashtest.tm.domain.campaign.testplan.TestPlanItem' ,'READ')  or hasRole('ROLE_ADMIN')")
    public List<User> findAssignableUsersByTestPlanItemId(Long testPlanItemId) {
        Long campaignLibraryId = this.sprintTestPlanItemDisplayDao.findCampaignLibraryIdByTestPlanItemId(testPlanItemId);
        return this.findAssignableUsersByCampaignLibraryId(campaignLibraryId);
    }

    @Override
    public List<User> findAssignableUsersByExploratorySessionOverviewId(Long overviewId) {
        Long campaignLibraryId = this.sprintTestPlanItemDisplayDao.findCampaignLibraryIdByExploratorySessionOverviewId(overviewId);
        return this.findAssignableUsersByCampaignLibraryId(campaignLibraryId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#libraryId, 'org.squashtest.tm.domain.campaign.CampaignLibrary' ,'READ')  or hasRole('ROLE_ADMIN')")
    public List<User> findAssignableUsersByCampaignLibraryId(Long libraryId) {
        List<String> loginList;
        CampaignLibrary campaignLibrary = (CampaignLibrary)this.entityManager.find(CampaignLibrary.class, (Object)libraryId);
        ObjectIdentity oid = this.objectIdentityRetrievalStrategy.getObjectIdentity((Object)campaignLibrary);
        List<String> list = loginList = this.objectAclService.findUsersWithExecutePermission(List.of(oid));
        UserDao userDao = this.userDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)userDao, list);
        Object[] objectArray = new Object[]{this, userDao, list, joinPoint};
        SprintTestPlanItemManagerServiceImpl$AjcClosure1 sprintTestPlanItemManagerServiceImpl$AjcClosure1 = new SprintTestPlanItemManagerServiceImpl$AjcClosure1(objectArray);
        return (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(sprintTestPlanItemManagerServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
    }

    @Override
    @PreAuthorize(value="hasPermission(#testPlanItemId, 'org.squashtest.tm.domain.campaign.testplan.TestPlanItem' ,'WRITE')  or hasRole('ROLE_ADMIN')")
    public void assignUserToTestPlanItem(Long testPlanItemId, long userId) {
        TestPlanItem item = this.findTestPlanItemAndCheckSprintStatus(testPlanItemId);
        User user = (User)this.entityManager.find(User.class, (Object)userId);
        item.setAssignee(user);
    }

    private TestPlanItem findTestPlanItemAndCheckSprintStatus(Long testPlanItemId) {
        SprintReqVersion sprintReqVersion = this.sprintReqVersionDao.findWithSprintByTestPlanItemId(testPlanItemId);
        TestPlanItem item = sprintReqVersion.getTestPlan().getTestPlanItems().stream().filter(i -> i.getId().equals(testPlanItemId)).findFirst().orElseThrow();
        Sprint sprint = sprintReqVersion.getSprint();
        if (SprintStatus.CLOSED.equals((Object)sprint.getStatus())) {
            throw new SprintClosedException();
        }
        return item;
    }

    @Override
    public void deleteSprintReqVersionTestPlanItems(Long sprintReqVersionId, List<Long> testPlanItemIds) {
        SprintReqVersion sprintReqVersion = this.sprintReqVersionDao.findByIdWithTestPlanAndSprint(sprintReqVersionId);
        if (SprintStatus.CLOSED.equals((Object)sprintReqVersion.getSprint().getStatus())) {
            throw new SprintNotLinkableException();
        }
        Set<TestPlanItem> itemsToRemove = sprintReqVersion.getTestPlan().getTestPlanItems().stream().filter(item -> testPlanItemIds.contains(item.getId())).collect(Collectors.toSet());
        itemsToRemove.forEach(item -> this.checkPermissionsAndRemoveItem(sprintReqVersion, (TestPlanItem)item));
        sprintReqVersion.updateLastModificationWithCurrentUser();
    }

    private void checkPermissionsAndRemoveItem(SprintReqVersion sprintReqVersion, TestPlanItem item) {
        if (item.getExecutions().isEmpty()) {
            if (this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.DELETE.name(), item)) {
                this.doRemoveTestPlanItemFromSprintReqVersion(sprintReqVersion, item);
            }
        } else if (this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.EXTENDED_DELETE.name(), item)) {
            this.doRemoveTestPlanItemFromSprintReqVersion(sprintReqVersion, item);
        }
    }

    private void doRemoveTestPlanItemFromSprintReqVersion(SprintReqVersion sprintReqVersion, TestPlanItem item) {
        sprintReqVersion.getTestPlan().removeTestPlanItem(item);
        this.deletionHandler.deleteSprintReqVersionTestPlanItem(item);
    }

    @Override
    public void moveSprintReqVersionTestPlanItems(long sprintReqVersionId, List<Long> testPlanItemIds, int position) {
        SprintReqVersion sprintReqVersion = this.sprintReqVersionDao.findByIdWithTestPlanAndSprint(sprintReqVersionId);
        if (SprintStatus.CLOSED.equals((Object)sprintReqVersion.getSprint().getStatus())) {
            throw new SprintNotLinkableException();
        }
        List<TestPlanItem> testPlanItems = sprintReqVersion.getTestPlan().getTestPlanItems().stream().filter(item -> testPlanItemIds.contains(item.getId())).toList();
        sprintReqVersion.getTestPlan().moveItems(testPlanItems, position);
    }

    static {
        SprintTestPlanItemManagerServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ List findUsersByLoginList_aroundBody0(SprintTestPlanItemManagerServiceImpl sprintTestPlanItemManagerServiceImpl, UserDao userDao, List list, JoinPoint joinPoint) {
        return userDao.findUsersByLoginList(list);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SprintTestPlanItemManagerServiceImpl.java", SprintTestPlanItemManagerServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findUsersByLoginList", "org.squashtest.tm.service.internal.repository.UserDao", "java.util.List", "arg0", "", "java.util.List"), 201);
    }
}

