/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jooq.DSLContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.exception.execution.IterationTestPlanHasDeletedTestCaseException;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.internal.campaign.AbstractTestPlanExecutionProcessingService;
import org.squashtest.tm.service.internal.campaign.CampaignNodeDeletionHandler;
import org.squashtest.tm.service.internal.campaign.IterationExecutionProcessingServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.campaign.IterationTestPlanManager;
import org.squashtest.tm.service.internal.display.dto.execution.TestPlanResume;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.campaign.IterationTestPlanGrid;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.internal.repository.display.IterationDisplayDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.user.UserAccountService;

@Service(value="squashtest.tm.service.IterationExecutionProcessingService")
@Transactional
public class IterationExecutionProcessingServiceImpl
extends AbstractTestPlanExecutionProcessingService<Iteration> {
    private static final String CAN_EXECUTE_BY_ITERATION_ID = "hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'EXECUTE') or hasRole('ROLE_ADMIN')";
    @Inject
    private IterationDao iterationDao;
    @Inject
    private IterationDisplayDao iterationDisplayDao;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    IterationExecutionProcessingServiceImpl(CampaignNodeDeletionHandler campaignDeletionHandler, IterationTestPlanManager testPlanManager, UserAccountService userService, PermissionEvaluationService permissionEvaluationService, IterationTestPlanDao iterationTestPlanDao, DSLContext dslContext) {
        super(campaignDeletionHandler, testPlanManager, userService, permissionEvaluationService, iterationTestPlanDao, dslContext);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public Execution startResume(long iterationId) {
        return super.startResume(iterationId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public Execution relaunch(long iterationId) {
        return super.relaunch(iterationId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public TestPlanResume relaunchFilteredTestPlan(long iterationId, List<GridFilterValue> filters) {
        return super.relaunchFilteredTestPlan(iterationId, filters);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public Execution startResumeNextExecution(long iterationId, long testPlanItemId) {
        return super.startResumeNextExecution(iterationId, testPlanItemId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public void deleteAllExecutions(long iterationId) {
        super.deleteAllExecutions(iterationId);
    }

    @Override
    public boolean hasMoreExecutableItems(long iterationId, long testPlanItemId) {
        return super.hasMoreExecutableItems(iterationId, testPlanItemId);
    }

    @Override
    Iteration getTestPlanOwner(long iterationId) {
        return (Iteration)this.iterationDao.findById(iterationId);
    }

    @Override
    Iteration createTransientTestPlanOwnerWithFilteredTestPlan(long iterationId, List<IterationTestPlanItem> filteredTestPLan) {
        Iteration iteration = this.getTestPlanOwner(iterationId);
        Iteration copyIteration = iteration.createCopy();
        copyIteration.getTestPlans().clear();
        copyIteration.getTestPlans().addAll(filteredTestPLan);
        return copyIteration;
    }

    @Override
    List<IterationTestPlanItem> getTestPlan(Iteration iteration) {
        return iteration.getTestPlans();
    }

    @Override
    IterationTestPlanItem findFirstExecutableTestPlanItem(String testerLogin, Iteration iteration) {
        return iteration.findFirstExecutableTestPlanItem(testerLogin);
    }

    @Override
    IterationTestPlanItem findNextExecutableTestPlanItem(Iteration iteration, long testPlanItemId, String testerLogin) {
        return iteration.findNextExecutableTestPlanItem(testPlanItemId, testerLogin);
    }

    @Override
    IterationTestPlanItem findNextExecutableTestPlanItem(Iteration iteration, long testPlanItemId) {
        return iteration.findNextExecutableTestPlanItem(testPlanItemId);
    }

    @Override
    public List<IterationTestPlanItem> getFilteredTestPlan(long iterationId, List<GridFilterValue> filters) {
        List<Long> itemIds;
        IterationTestPlanGrid testPlanGrid = new IterationTestPlanGrid(iterationId, null, this.iterationDisplayDao, this.permissionEvaluationService);
        GridRequest gridRequest = this.prepareNonPaginatedGridRequest(filters);
        GridResponse gridResponse = testPlanGrid.getRows(gridRequest, this.dslContext);
        List<Long> list = itemIds = this.extractItemIdsFromGridResponse(gridResponse);
        IterationTestPlanDao iterationTestPlanDao = this.iterationTestPlanDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)iterationTestPlanDao, list);
        Object[] objectArray = new Object[]{this, iterationTestPlanDao, list, joinPoint};
        IterationExecutionProcessingServiceImpl$AjcClosure1 iterationExecutionProcessingServiceImpl$AjcClosure1 = new IterationExecutionProcessingServiceImpl$AjcClosure1(objectArray);
        return (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(iterationExecutionProcessingServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public TestPlanResume resumeWithFilteredTestPlan(long iterationId, List<GridFilterValue> filters) {
        return super.resumeWithFilteredTestPlan(iterationId, filters);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'EXECUTE') or hasRole('ROLE_ADMIN')")
    public TestPlanResume resumeNextExecutionOfFilteredTestPlan(long iterationId, long testPlanItemId, List<Long> partialTestPlanItemIds) {
        return super.resumeNextExecutionOfFilteredTestPlan(iterationId, testPlanItemId, partialTestPlanItemIds);
    }

    @Override
    public ActionException getTestPlanHasDeletedTestCaseException() {
        return new IterationTestPlanHasDeletedTestCaseException();
    }

    @Override
    protected TestPlanResume createNewTestPlanResume(long testPlanOwnerId, Execution execution, boolean hasNextTestCase, List<Long> partialTestPlanItemIds) {
        return new TestPlanResume.IterationTestPlanResume(testPlanOwnerId, execution, hasNextTestCase, partialTestPlanItemIds);
    }

    static {
        IterationExecutionProcessingServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ List findAllByIdIn_aroundBody0(IterationExecutionProcessingServiceImpl iterationExecutionProcessingServiceImpl, IterationTestPlanDao iterationTestPlanDao, Collection collection, JoinPoint joinPoint) {
        return iterationTestPlanDao.findAllByIdIn(collection);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("IterationExecutionProcessingServiceImpl.java", IterationExecutionProcessingServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllByIdIn", "org.squashtest.tm.service.internal.repository.IterationTestPlanDao", "java.util.Collection", "ids", "", "java.util.List"), 174);
    }
}

