/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.aspect.validation.CleanHtmlAspect;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.campaign.CustomSprintModificationService;
import org.squashtest.tm.service.campaign.SprintModificationService;
import org.squashtest.tm.service.display.sprint.SprintDisplayService;
import org.squashtest.tm.service.execution.ExploratoryExecutionService;
import org.squashtest.tm.service.internal.campaign.CustomSprintModificationServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.display.dto.sprint.SprintReqVersionDto;
import org.squashtest.tm.service.internal.library.NodeManagementService;
import org.squashtest.tm.service.internal.repository.SprintReqVersionDao;

@Transactional
@Service(value="CustomSprintModificationService")
public class CustomSprintModificationServiceImpl
implements CustomSprintModificationService {
    @Inject
    private SprintReqVersionDao sprintReqVersionDao;
    @Inject
    private SprintDisplayService sprintDisplayService;
    @Inject
    private SprintModificationService sprintModificationService;
    @Inject
    private ExploratoryExecutionService exploratoryExecutionService;
    @Inject
    @Named(value="squashtest.tm.service.internal.SprintManagementService")
    private NodeManagementService<Sprint, CampaignLibraryNode, CampaignFolder> sprintManagementService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    @PreAuthorize(value="hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint' ,'WRITE') or hasRole('ROLE_ADMIN')")
    public void rename(@Id long sprintId, String newName) {
        this.sprintManagementService.renameNode(sprintId, newName);
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint' ,'WRITE') or hasRole('ROLE_ADMIN')")
    public void updateStatusBySprintId(Long sprintId, SprintStatus newStatus) {
        this.sprintModificationService.changeStatus(sprintId, newStatus);
        if (newStatus == SprintStatus.CLOSED) {
            this.denormalizeSprintReqVersions(sprintId);
            this.exploratoryExecutionService.pauseRunningExploratoryExecutions(sprintId);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintId, 'org.squashtest.tm.domain.campaign.Sprint' ,'WRITE') or hasRole('ROLE_ADMIN')")
    public void denormalizeSprintReqVersions(Long sprintId) {
        List<SprintReqVersionDto> sprintReqVersionDtos = this.sprintDisplayService.findSprintReqVersionDtosForDenormalization(sprintId);
        Iterator<SprintReqVersionDto> iterator = sprintReqVersionDtos.iterator();
        while (iterator.hasNext()) {
            SprintReqVersionDto dto;
            SprintReqVersionDto sprintReqVersionDto = dto = iterator.next();
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)sprintReqVersionDto);
            Object[] objectArray = new Object[]{this, sprintReqVersionDto, joinPoint};
            CustomSprintModificationServiceImpl$AjcClosure1 customSprintModificationServiceImpl$AjcClosure1 = new CustomSprintModificationServiceImpl$AjcClosure1(objectArray);
            this.sprintReqVersionDao.updateForDenormalization(dto.getId(), dto.getReference(), dto.getName(), dto.getStatus(), dto.getCriticality(), dto.getCategoryLabel(), (String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(customSprintModificationServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112)));
        }
    }

    static {
        CustomSprintModificationServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ String getDescription_aroundBody0(CustomSprintModificationServiceImpl customSprintModificationServiceImpl, SprintReqVersionDto sprintReqVersionDto, JoinPoint joinPoint) {
        return sprintReqVersionDto.getDescription();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CustomSprintModificationServiceImpl.java", CustomSprintModificationServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getDescription", "org.squashtest.tm.service.internal.display.dto.sprint.SprintReqVersionDto", "", "", "", "java.lang.String"), 94);
    }
}

