/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.service.campaign.CampaignStatisticsService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.internal.repository.CampaignDao;
import org.squashtest.tm.service.internal.repository.CustomItpiLastExecutionFilterDao;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.statistics.CountOnEnum;
import org.squashtest.tm.service.statistics.campaign.CampaignTestCaseSuccessRateStatistics;
import org.squashtest.tm.service.statistics.campaign.ProgressionStatistics;
import org.squashtest.tm.service.statistics.campaign.ScheduledIteration;
import org.squashtest.tm.service.statistics.campaign.StatisticsBundle;
import org.squashtest.tm.service.statistics.campaign.TestInventoryStatistics;

@Transactional(readOnly=true)
@Service(value="CampaignStatisticsService")
public class CampaignStatisticsServiceImpl
implements CampaignStatisticsService {
    private static final String PERM_CAN_READ_CAMPAIGN = "hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'READ') ";
    private static final Logger LOGGER = LoggerFactory.getLogger(CampaignStatisticsServiceImpl.class);
    private static final String CAMPAIGN_IDS = "campaignIds";
    private static final String CAMPAIGN_ID = "campaignId";
    private static final String ITPI_IDS = "itpiIds";
    @PersistenceContext
    private EntityManager em;
    @Inject
    private CampaignDao campaignDao;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private IterationTestPlanManagerService itpManagerService;
    @Inject
    private CustomItpiLastExecutionFilterDao itpiLastExecutionFilterDao;

    @Override
    public StatisticsBundle gatherCampaignStatisticsBundle(List<Long> campaignIds, boolean lastExecutionScope) {
        boolean isSolitaryCampaign = campaignIds.size() == 1;
        StatisticsBundle bundle = lastExecutionScope ? this.initializeStatisticsBundleForLastExecutionScope(campaignIds) : this.initializeStatisticsBundle(campaignIds);
        List<TestInventoryStatistics> inventory = isSolitaryCampaign ? this.gatherSingleCampaignTestInventoryStatistics(campaignIds.get(0)) : this.gatherManyCampaignTestInventoryStatistics(campaignIds);
        ProgressionStatistics progression = isSolitaryCampaign ? this.gatherSingleCampaignProgressionStatistics(campaignIds.get(0)) : new ProgressionStatistics();
        bundle.setTestInventoryStatistics(inventory);
        bundle.setProgressionStatistics(progression);
        bundle.setSelectedIds(campaignIds);
        return bundle;
    }

    @Override
    public StatisticsBundle gatherMilestoneStatisticsBundle(boolean lastExecutionScope) {
        List<Long> campaignIds = this.filterCampaignIdsByActiveMilestone(new ArrayList<Long>());
        StatisticsBundle bundle = lastExecutionScope ? this.initializeStatisticsBundleForLastExecutionScope(campaignIds) : this.initializeStatisticsBundle(campaignIds);
        List<TestInventoryStatistics> inventory = this.gatherMilestoneTestInventoryStatistics();
        ProgressionStatistics progression = new ProgressionStatistics();
        bundle.setTestInventoryStatistics(inventory);
        bundle.setProgressionStatistics(progression);
        return bundle;
    }

    @Override
    public StatisticsBundle gatherMultiStatisticsBundle(Map<Long, String> campaignNameMap, boolean lastExecutionScope) {
        List<Long> campaignIds = new ArrayList<Long>(campaignNameMap.keySet());
        campaignIds = this.filterCampaignIdsByActiveMilestone(campaignIds);
        StatisticsBundle bundle = lastExecutionScope ? this.initializeStatisticsBundleForLastExecutionScope(campaignIds) : this.initializeStatisticsBundle(campaignIds);
        List<TestInventoryStatistics> inventory = this.gatherMultiCampaignTestInventoryStatistics(campaignNameMap, campaignIds);
        ProgressionStatistics progression = new ProgressionStatistics();
        bundle.setTestInventoryStatistics(inventory);
        bundle.setProgressionStatistics(progression);
        bundle.setSelectedIds(campaignIds);
        return bundle;
    }

    private StatisticsBundle initializeStatisticsBundle(List<Long> campaignIds) {
        StatisticsBundle bundle = new StatisticsBundle();
        Map<ExecutionStatus, Integer> testcaseStatuses = this.gatherTestCaseStatusStatistics(campaignIds);
        Map<TestCaseImportance, Integer> testcaseImportance = this.gatherNonExecutedTestCaseImportanceStatistics(campaignIds);
        CampaignTestCaseSuccessRateStatistics testcaseSuccessRate = this.gatherTestCaseSuccessRateStatistics(campaignIds);
        bundle.setTestCaseStatusStatistics(testcaseStatuses);
        bundle.setNonExecutedTestCaseImportanceStatistics(testcaseImportance);
        bundle.setTestCaseSuccessRateStatistics(testcaseSuccessRate);
        return bundle;
    }

    private StatisticsBundle initializeStatisticsBundleForLastExecutionScope(List<Long> campaignIds) {
        StatisticsBundle bundle = new StatisticsBundle();
        List<Long> itpiIdsInScope = this.itpiLastExecutionFilterDao.gatherLatestItpiIdsForTCInScopeForCampaign(campaignIds);
        LinkedHashMap<ExecutionStatus, Integer> testcaseStatuses = this.gatherTestCaseStatusStatisticsForLastExecScope(itpiIdsInScope);
        Map<TestCaseImportance, Integer> testcaseImportance = this.gatherNonExecutedTestCaseImportanceStatisticsForLastExecScope(itpiIdsInScope);
        CampaignTestCaseSuccessRateStatistics testcaseSuccessRate = this.gatherTestCaseSuccessRateStatisticsForLastExecScope(itpiIdsInScope);
        bundle.setTestCaseStatusStatistics(testcaseStatuses);
        bundle.setNonExecutedTestCaseImportanceStatistics(testcaseImportance);
        bundle.setTestCaseSuccessRateStatistics(testcaseSuccessRate);
        return bundle;
    }

    private List<Long> filterCampaignIdsByActiveMilestone(List<Long> campaignIds) {
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent() && !campaignIds.isEmpty()) {
            return this.campaignDao.filterByMilestone(campaignIds, activeMilestone.get().getId());
        }
        if (activeMilestone.isPresent()) {
            return this.campaignDao.findAllIdsByMilestone(activeMilestone.get().getId());
        }
        return campaignIds;
    }

    private Map<ExecutionStatus, Integer> gatherTestCaseStatusStatistics(List<Long> campaignIds) {
        List<Object[]> tuples = this.fetchCommonTuples("CampaignStatistics.globaltestinventory", CAMPAIGN_IDS, campaignIds);
        return CountOnEnum.fromTuples(tuples, ExecutionStatus.class).getStatistics(ExecutionStatus::getCanonicalStatus, ExecutionStatus.getCanonicalStatusSet());
    }

    private LinkedHashMap<ExecutionStatus, Integer> gatherTestCaseStatusStatisticsForLastExecScope(List<Long> itpiIds) {
        List<Object[]> tuples = this.fetchCommonTuples("CampaignStatistics.globaltestinventorybylastexecution", ITPI_IDS, itpiIds);
        return CountOnEnum.fromTuples(tuples, ExecutionStatus.class).getStatistics(ExecutionStatus::getCanonicalStatus, ExecutionStatus.getCanonicalStatusSet());
    }

    private CampaignTestCaseSuccessRateStatistics gatherTestCaseSuccessRateStatistics(List<Long> campaignIds) {
        List<Object[]> tuples = this.fetchCommonTuples("CampaignStatistics.successRate", CAMPAIGN_IDS, campaignIds);
        return CampaignTestCaseSuccessRateStatistics.fromTuples(tuples);
    }

    private CampaignTestCaseSuccessRateStatistics gatherTestCaseSuccessRateStatisticsForLastExecScope(List<Long> itpiIds) {
        List<Object[]> tuples = this.fetchCommonTuples("CampaignStatistics.successRateByLastExecution", ITPI_IDS, itpiIds);
        return CampaignTestCaseSuccessRateStatistics.fromTuples(tuples);
    }

    private Map<TestCaseImportance, Integer> gatherNonExecutedTestCaseImportanceStatistics(List<Long> campaignIds) {
        List<Object[]> tuples = this.fetchCommonTuples("CampaignStatistics.nonexecutedTestcaseImportance", CAMPAIGN_IDS, campaignIds);
        return CountOnEnum.fromTuples(tuples, TestCaseImportance.class).getStatistics();
    }

    private Map<TestCaseImportance, Integer> gatherNonExecutedTestCaseImportanceStatisticsForLastExecScope(List<Long> itpiIds) {
        List<Object[]> tuples = this.fetchCommonTuples("CampaignStatistics.nonexecutedTestcaseImportanceByLastExecution", ITPI_IDS, itpiIds);
        return CountOnEnum.fromTuples(tuples, TestCaseImportance.class).getStatistics();
    }

    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'READ')  or hasRole('ROLE_ADMIN')")
    public List<TestInventoryStatistics> gatherManyCampaignTestInventoryStatistics(List<Long> campaignIds) {
        Query query = this.em.createNamedQuery("CampaignStatistics.testinventorybycampaigns");
        query.setParameter(CAMPAIGN_IDS, campaignIds);
        List tuples = query.getResultList();
        return this.processTestInventory(Collections.emptyMap(), tuples);
    }

    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'READ')  or hasRole('ROLE_ADMIN')")
    public List<TestInventoryStatistics> gatherSingleCampaignTestInventoryStatistics(long campaignId) {
        Query query = this.em.createNamedQuery("CampaignStatistics.testinventorybycampaign");
        query.setParameter(CAMPAIGN_ID, (Object)campaignId);
        List tuples = query.getResultList();
        return this.processTestInventory(Collections.emptyMap(), tuples);
    }

    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'READ')  or hasRole('ROLE_ADMIN')")
    public ProgressionStatistics gatherSingleCampaignProgressionStatistics(long campaignId) {
        ProgressionStatistics progression = new ProgressionStatistics();
        Query query = this.em.createNamedQuery("CampaignStatistics.findScheduledIterations");
        query.setParameter("id", (Object)campaignId);
        List scheduledIterations = query.getResultList();
        Query requery = this.em.createNamedQuery("CampaignStatistics.findExecutionsHistory");
        requery.setParameter("id", (Object)campaignId);
        requery.setParameter("nonterminalStatuses", (Object)ExecutionStatus.getNonTerminatedStatusSet());
        List executionHistory = requery.getResultList();
        try {
            progression.setScheduledIterations(scheduledIterations);
            progression.getScheduledIterations().forEach(scheduledIteration -> scheduledIteration.setName(scheduledIteration.getName()));
            ScheduledIteration.checkIterationsDatesIntegrity(scheduledIterations);
            progression.computeSchedule();
            progression.computeCumulativeTestPerDate(executionHistory);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.info("CampaignStatistics : could not generate campaign progression statistics for campaign {}: some iterations scheduled dates are wrong", new Object[]{campaignId});
            progression.addi18nErrorMessage(ex.getMessage());
        }
        return progression;
    }

    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'READ')  or hasRole('ROLE_ADMIN')")
    public List<TestInventoryStatistics> gatherMilestoneTestInventoryStatistics() {
        Query query = this.em.createNamedQuery("CampaignStatistics.testinventorybymilestone");
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        List tuples = Collections.emptyList();
        if (activeMilestone.isPresent()) {
            Long milestoneId = activeMilestone.get().getId();
            query.setParameter("id", (Object)milestoneId);
            tuples = query.getResultList();
        }
        return this.processTestInventory(Collections.emptyMap(), tuples);
    }

    public List<TestInventoryStatistics> gatherMultiCampaignTestInventoryStatistics(Map<Long, String> campaignNameMap, List<Long> campaignIds) {
        List tuples = Collections.emptyList();
        if (!campaignIds.isEmpty()) {
            Query query = this.em.createNamedQuery("MultiCampaignStatistics.testinventory");
            query.setParameter(CAMPAIGN_IDS, campaignIds);
            tuples = query.getResultList();
        }
        return this.processTestInventory(campaignNameMap, tuples);
    }

    private List<Object[]> fetchCommonTuples(String queryName, String idParameterName, List<Long> ids) {
        List res = Collections.emptyList();
        if (!ids.isEmpty()) {
            Query query = this.em.createNamedQuery(queryName);
            query.setParameter(idParameterName, ids);
            res = query.getResultList();
        }
        return res;
    }

    private List<TestInventoryStatistics> processTestInventory(Map<Long, String> campaignNameMap, List<Object[]> res) {
        TestInventoryStatistics newStatistics = new TestInventoryStatistics();
        Long currentId = null;
        LinkedList<TestInventoryStatistics> result = new LinkedList<TestInventoryStatistics>();
        for (Object[] tuple : res) {
            Long id = (Long)tuple[0];
            if (!id.equals(currentId)) {
                newStatistics = new TestInventoryStatistics();
                String name = campaignNameMap.get(id) != null ? campaignNameMap.get(id) : (String)tuple[1];
                newStatistics.setName(name);
                result.add(newStatistics);
                currentId = id;
            }
            ExecutionStatus status = (ExecutionStatus)tuple[2];
            Long howmany = (Long)tuple[3];
            if (status == null) continue;
            newStatistics.setNumber(howmany.intValue(), status);
        }
        result.sort((a, b) -> a.getName().compareToIgnoreCase(b.getName()));
        return result;
    }
}

