/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Table;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.jooq.domain.tables.ItemTestPlanExecution;
import org.squashtest.tm.service.campaign.AutomatedExecutionCreationService;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.denormalizedfield.PrivateDenormalizedFieldValueService;
import org.squashtest.tm.service.internal.repository.ExecutionDao;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;

@Service
@Transactional
public class AutomatedExecutionCreationServiceImpl
implements AutomatedExecutionCreationService {
    @Inject
    private PrivateCustomFieldValueService customFieldValuesService;
    @Inject
    private ExecutionDao executionDao;
    @Inject
    private PrivateDenormalizedFieldValueService denormalizedFieldValueService;
    @Inject
    private IterationTestPlanDao iterationTestPlanDao;
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    DSLContext dslContext;

    @Override
    public Map<Long, Long> createAutomatedExecutions(AutomatedSuite suite, List<IterationTestPlanItem> itemTestPlan, Project project) {
        ArrayList<Execution> createdExecutions = new ArrayList<Execution>();
        HashMap<Long, Long> itemExecutionMap = new HashMap<Long, Long>();
        itemTestPlan.forEach(item -> this.createExecution((IterationTestPlanItem)item, suite, (Map<Long, Long>)itemExecutionMap, (List<Execution>)createdExecutions));
        this.entityManager.flush();
        this.entityManager.clear();
        this.insertBatchIemTestPlanExecutionLink(itemExecutionMap);
        this.addExternalFields(createdExecutions, project);
        return itemExecutionMap;
    }

    private void insertBatchIemTestPlanExecutionLink(Map<Long, Long> itemExecutionMap) {
        Map nextItemExecutionOrderMap = this.iterationTestPlanDao.getNextTestPlanExecutionOrders(itemExecutionMap.keySet());
        ArrayList inserts = new ArrayList();
        itemExecutionMap.forEach((itemId, executionId) -> {
            Integer executionOrder = (Integer)nextItemExecutionOrderMap.get(itemId);
            if (executionOrder != null) {
                inserts.add(this.dslContext.insertInto((Table)ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION).set((Field)ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID, itemId).set((Field)ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID, executionId).set((Field)ItemTestPlanExecution.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ORDER, (Object)executionOrder));
            }
        });
        this.dslContext.batch(inserts).execute();
    }

    private void createExecution(IterationTestPlanItem item, AutomatedSuite suite, Map<Long, Long> itemExecutionMap, List<Execution> createdExecutions) {
        Execution execution = item.createExecution(null, null);
        AutomatedExecutionExtender extender = new AutomatedExecutionExtender();
        extender.setExecution(execution);
        execution.setAutomatedExecutionExtender(extender);
        this.executionDao.save(execution);
        item.notifyAutomatedExecutionAddition(execution);
        suite.addExtender(execution.getAutomatedExecutionExtender());
        createdExecutions.add(execution);
        itemExecutionMap.put(item.getId(), execution.getId());
    }

    private void createCustomFieldsForExecutionAndExecutionSteps(List<Execution> executions, Project project) {
        this.customFieldValuesService.createAllCustomFieldValues(executions, project);
        List steps = executions.stream().flatMap(exec -> exec.getSteps().stream()).toList();
        this.customFieldValuesService.createAllCustomFieldValues(steps, project);
    }

    private void createDenormalizedFieldsForExecutionAndExecutionSteps(List<Execution> executions) {
        Map<Long, List<DenormalizedFieldHolder>> map = executions.stream().map(DenormalizedFieldHolder.class::cast).collect(Collectors.groupingBy(holder -> ((Execution)holder).getReferencedTestCase().getId()));
        this.denormalizedFieldValueService.createBatchDenormalizedFieldValues(map, BindableEntity.TEST_CASE);
        this.denormalizedFieldValueService.createAllDenormalizedFieldValuesForSteps(executions);
    }

    private void addExternalFields(List<Execution> createdExecutions, Project project) {
        this.createCustomFieldsForExecutionAndExecutionSteps(createdExecutions, project);
        this.createDenormalizedFieldsForExecutionAndExecutionSteps(createdExecutions);
        this.entityManager.flush();
        this.entityManager.clear();
    }
}

