/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.bugtracker;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.springframework.util.Assert;
import org.squashtest.csp.core.bugtracker.core.UnknownConnectorKindException;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerProviderDescriptor;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.service.internal.bugtracker.adapter.AdvancedBugtrackerConnectorAdapter;
import org.squashtest.tm.service.internal.bugtracker.adapter.InternalBugtrackerConnector;
import org.squashtest.tm.service.internal.bugtracker.adapter.OslcBugtrackerConnectorAdapter;
import org.squashtest.tm.service.internal.bugtracker.adapter.SimpleBugtrackerConnectorAdapter;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnector;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnectorProvider;
import org.squashtest.tm.service.spi.BugTrackerConnector;
import org.squashtest.tm.service.spi.BugTrackerConnectorProvider;
import org.squashtest.tm.service.spi.OAuth2ConfigurationHandler;
import org.squashtest.tm.service.spi.OslcBugTrackerConnector;
import org.squashtest.tm.service.spi.OslcBugTrackerConnectorProvider;

public class BugTrackerConnectorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BugTrackerConnectorFactory.class);
    private static final String PROVIDER_BUGTRACKER_KIND = "provider.bugTrackerKind";
    private static final String REGISTERING_CONNECTOR_KIND = "Registering Connector provider for bug trackers of kind '{}'";
    private final Map<String, BugTrackerConnectorProvider> providerByKind = new ConcurrentHashMap<String, BugTrackerConnectorProvider>(2);
    private final Map<String, AdvancedBugTrackerConnectorProvider> advancedProviderByKind = new ConcurrentHashMap<String, AdvancedBugTrackerConnectorProvider>(2);
    private final Map<String, OslcBugTrackerConnectorProvider> oslcProviderByKind = new ConcurrentHashMap<String, OslcBugTrackerConnectorProvider>(2);
    private Collection<BugTrackerConnectorProvider> providers = Collections.emptyList();
    private Collection<AdvancedBugTrackerConnectorProvider> advancedProviders = Collections.emptyList();
    private Collection<OslcBugTrackerConnectorProvider> oslcProviders = Collections.emptyList();

    public Set<String> getProviderKinds() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.providerByKind.keySet());
        result.addAll(this.advancedProviderByKind.keySet());
        result.addAll(this.oslcProviderByKind.keySet());
        return result;
    }

    public InternalBugtrackerConnector createConnector(BugTracker bugTracker) {
        InternalBugtrackerConnector connector;
        String kind = bugTracker.getKind();
        LOGGER.debug("Creating Connector for bug tracker of kind {}", new Object[]{kind});
        if (this.isSimpleConnector(kind)) {
            connector = this.createAndWrapSimpleConnector(bugTracker);
        } else if (this.isAdvancedConnector(kind)) {
            connector = this.createAndWrapAdvancedConnector(bugTracker);
        } else if (this.isOslcConnector(kind)) {
            connector = this.createAndWrapOslcConnector(bugTracker);
        } else {
            throw new UnknownConnectorKindException(kind);
        }
        return connector;
    }

    @PostConstruct
    public void registerBugTrackers() {
        Assert.notNull(this.providers, (String)"'providers' property should not be null");
        for (BugTrackerConnectorProvider provider : this.providers) {
            this.registerProvider(provider);
        }
        Assert.notNull(this.advancedProviders, (String)"'advancedProviders' property should not be null");
        for (AdvancedBugTrackerConnectorProvider advancedProvider : this.advancedProviders) {
            this.registerAdvancedProvider(advancedProvider);
        }
        Assert.notNull(this.oslcProviders, (String)"'oslcProviders' property should not be null");
        for (OslcBugTrackerConnectorProvider oslcProvider : this.oslcProviders) {
            this.registerOslcProvider(oslcProvider);
        }
    }

    private boolean isSimpleConnector(String kind) {
        return this.providerByKind.containsKey(kind);
    }

    private boolean isAdvancedConnector(String kind) {
        return this.advancedProviderByKind.containsKey(kind);
    }

    public boolean isOslcConnector(String kind) {
        return this.oslcProviderByKind.containsKey(kind);
    }

    private InternalBugtrackerConnector createAndWrapSimpleConnector(BugTracker bugTracker) {
        BugTrackerConnectorProvider provider = this.providerByKind.get(bugTracker.getKind());
        BugTrackerConnector connector = provider.createConnector(bugTracker);
        return new SimpleBugtrackerConnectorAdapter(connector);
    }

    private InternalBugtrackerConnector createAndWrapAdvancedConnector(BugTracker bugTracker) {
        AdvancedBugTrackerConnectorProvider provider = this.advancedProviderByKind.get(bugTracker.getKind());
        AdvancedBugTrackerConnector connector = provider.createConnector(bugTracker);
        return new AdvancedBugtrackerConnectorAdapter(connector);
    }

    private InternalBugtrackerConnector createAndWrapOslcConnector(BugTracker bugTracker) {
        OslcBugTrackerConnectorProvider provider = this.oslcProviderByKind.get(bugTracker.getKind());
        OslcBugTrackerConnector connector = provider.createConnector(bugTracker);
        return new OslcBugtrackerConnectorAdapter(connector);
    }

    private void registerProvider(BugTrackerConnectorProvider provider) {
        String kind = provider.getBugTrackerKind();
        if (kind == null) {
            throw new NullArgumentException(PROVIDER_BUGTRACKER_KIND);
        }
        LOGGER.info(REGISTERING_CONNECTOR_KIND, new Object[]{kind});
        this.providerByKind.put(kind, provider);
    }

    private void registerAdvancedProvider(AdvancedBugTrackerConnectorProvider provider) {
        String kind = provider.getBugTrackerKind();
        if (kind == null) {
            throw new NullArgumentException(PROVIDER_BUGTRACKER_KIND);
        }
        LOGGER.info(REGISTERING_CONNECTOR_KIND, new Object[]{kind});
        this.advancedProviderByKind.put(kind, provider);
    }

    private void registerOslcProvider(OslcBugTrackerConnectorProvider provider) {
        String kind = provider.getBugTrackerKind();
        if (kind == null) {
            throw new NullArgumentException(PROVIDER_BUGTRACKER_KIND);
        }
        LOGGER.info(REGISTERING_CONNECTOR_KIND, new Object[]{kind});
        this.oslcProviderByKind.put(kind, provider);
    }

    public void setProviders(@NotNull Collection<BugTrackerConnectorProvider> providers) {
        Collection<BugTrackerConnectorProvider> collection = providers;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(collection);
        this.providers = providers;
    }

    public void setAdvancedProviders(@NotNull Collection<AdvancedBugTrackerConnectorProvider> advancedProviders) {
        Collection<AdvancedBugTrackerConnectorProvider> collection = advancedProviders;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(collection);
        this.advancedProviders = advancedProviders;
    }

    public void setOslcProviders(@NotNull Collection<OslcBugTrackerConnectorProvider> oslcProviders) {
        Collection<OslcBugTrackerConnectorProvider> collection = oslcProviders;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(collection);
        this.oslcProviders = oslcProviders;
    }

    public BugTrackerProviderDescriptor findDescriptor(String kind) {
        if (this.providerByKind.containsKey(kind)) {
            return this.providerByKind.get(kind).getDescriptor();
        }
        if (this.advancedProviderByKind.containsKey(kind)) {
            return this.advancedProviderByKind.get(kind).getDescriptor();
        }
        if (this.oslcProviderByKind.containsKey(kind)) {
            return this.oslcProviderByKind.get(kind).getDescriptor();
        }
        throw new UnknownConnectorKindException(kind);
    }

    public OAuth2ConfigurationHandler findOauth2Handler(BugTracker bugTracker) {
        String kind = bugTracker.getKind();
        if (this.providerByKind.containsKey(kind)) {
            return this.providerByKind.get(kind).getOAuth2ConfigurationHandler();
        }
        if (this.advancedProviderByKind.containsKey(kind)) {
            return this.advancedProviderByKind.get(kind).getOAuth2ConfigurationHandler();
        }
        if (this.oslcProviderByKind.containsKey(kind)) {
            return this.oslcProviderByKind.get(kind).getOAuth2ConfigurationHandler();
        }
        throw new UnknownConnectorKindException(kind);
    }
}

