/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.testcase.excel;

import java.util.Arrays;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.poi.ss.usermodel.Row;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.service.internal.batchimport.TestCaseInstruction;
import org.squashtest.tm.service.internal.batchimport.TestCaseTarget;
import org.squashtest.tm.service.internal.batchimport.excel.CannotCoerceException;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.AbstractInstructionBuilder;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.StdColumnDef;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TestCaseSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.WorksheetDef;

class TestCaseInstructionBuilder
extends AbstractInstructionBuilder<TestCaseSheetColumn, TestCaseInstruction> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseInstructionBuilder.class);

    public TestCaseInstructionBuilder(@NotNull WorksheetDef<TestCaseSheetColumn> worksheetDef) {
        super(worksheetDef);
    }

    @Override
    protected TestCaseInstruction createInstruction(Row row) {
        StdColumnDef<TestCaseSheetColumn> columnDef = this.worksheetDef.getColumnDef(TestCaseSheetColumn.TC_KIND);
        TestCaseKind testCaseKind = null;
        if (columnDef != null) {
            try {
                testCaseKind = (TestCaseKind)this.getValue(row, columnDef);
            }
            catch (CannotCoerceException cce) {
                String testCaseKinds = Arrays.stream(TestCaseKind.values()).map(Enum::toString).collect(Collectors.joining(","));
                LOGGER.debug("The value for TC_KIND does not exist for the corresponded enum. Authorized values are : {}. Then, default value STANDARD will be assigned.", new Object[]{testCaseKinds, cce});
            }
        }
        if (testCaseKind == null) {
            testCaseKind = TestCaseKind.STANDARD;
        }
        return new TestCaseInstruction(new TestCaseTarget(), (TestCase)(switch (testCaseKind) {
            case TestCaseKind.GHERKIN -> this.getBlankScriptedTestCase(row);
            case TestCaseKind.KEYWORD -> KeywordTestCase.createBlankKeywordTestCase();
            default -> TestCase.createBlankTestCase();
        }));
    }

    private ScriptedTestCase getBlankScriptedTestCase(Row row) {
        String script = (String)this.getValue(row, this.worksheetDef.getColumnDef(TestCaseSheetColumn.TC_SCRIPT));
        return ScriptedTestCase.createBlankScriptedTestCase((String)script);
    }
}

