/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.testcase.excel;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Value;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.exception.SheetCorruptedException;
import org.squashtest.tm.service.batchimport.excel.TemplateMismatchException;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.internal.batchimport.DatasetInstruction;
import org.squashtest.tm.service.internal.batchimport.DatasetParamValueInstruction;
import org.squashtest.tm.service.internal.batchimport.DatasetTarget;
import org.squashtest.tm.service.internal.batchimport.Instruction;
import org.squashtest.tm.service.internal.batchimport.LinkedLowLevelRequirementInstruction;
import org.squashtest.tm.service.internal.batchimport.LinkedLowLevelRequirementTarget;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.ParameterInstruction;
import org.squashtest.tm.service.internal.batchimport.ParameterTarget;
import org.squashtest.tm.service.internal.batchimport.RequirementLinkInstruction;
import org.squashtest.tm.service.internal.batchimport.RequirementLinkTarget;
import org.squashtest.tm.service.internal.batchimport.RequirementVersionInstruction;
import org.squashtest.tm.service.internal.batchimport.RequirementVersionTarget;
import org.squashtest.tm.service.internal.batchimport.StepInstruction;
import org.squashtest.tm.service.internal.batchimport.TestCaseInstruction;
import org.squashtest.tm.service.internal.batchimport.TestCaseTarget;
import org.squashtest.tm.service.internal.batchimport.TestStepTarget;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.LinkedLowLevelRequirementInstructionBuilder;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.LinkedLowLevelRequirementsSheetColumn;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.RequirementInstructionBuilder;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.RequirementLinkInstructionBuilder;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.RequirementLinksSheetColumn;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.RequirementSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.AbstractInstructionBuilder;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.CoverageInstruction;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.CoverageInstructionBuilder;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.CoverageSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.CoverageTarget;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.DatasetInstructionBuilder;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.DatasetParamValueInstructionBuilder;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.DatasetParamValuesSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.DatasetSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.ExcelWorkbookParserBuilder;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.ParameterInstructionBuilder;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.ParameterSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.StepInstructionBuilder;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.StepSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TemplateColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TemplateWorksheet;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TestCaseInstructionBuilder;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TestCaseSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.UnknownColumnDef;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.WorkbookMetaData;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.WorksheetDef;

public class ExcelWorkbookParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelWorkbookParser.class);
    private static final String RAWTYPES = "rawtypes";
    private static final String UNCHECKED = "unchecked";
    @Inject
    @Value(value="${uploadfilter.upload.import.maxLinesPerSheetForExcelImport:100}")
    private int maxLines;
    private Workbook workbook;
    private final WorkbookMetaData wmd;
    private final Map<TemplateWorksheet, List<Instruction<?>>> instructionsByWorksheet = new EnumMap(TemplateWorksheet.class);
    private final Map<TemplateWorksheet, Factory<?>> instructionBuilderFactoryByWorksheet = new EnumMap(TemplateWorksheet.class);

    ExcelWorkbookParser(@NotNull Workbook workbook, @NotNull WorkbookMetaData wmd) {
        this.workbook = workbook;
        this.wmd = wmd;
        this.instructionsByWorksheet.put(TemplateWorksheet.TEST_CASES_SHEET, new ArrayList());
        this.instructionsByWorksheet.put(TemplateWorksheet.STEPS_SHEET, new ArrayList());
        this.instructionsByWorksheet.put(TemplateWorksheet.PARAMETERS_SHEET, new ArrayList());
        this.instructionsByWorksheet.put(TemplateWorksheet.DATASETS_SHEET, new ArrayList());
        this.instructionsByWorksheet.put(TemplateWorksheet.DATASET_PARAM_VALUES_SHEET, new ArrayList());
        this.instructionsByWorksheet.put(TemplateWorksheet.REQUIREMENT_SHEET, new ArrayList());
        this.instructionsByWorksheet.put(TemplateWorksheet.COVERAGE_SHEET, new ArrayList());
        this.instructionsByWorksheet.put(TemplateWorksheet.REQUIREMENT_LINKS_SHEET, new ArrayList());
        this.instructionsByWorksheet.put(TemplateWorksheet.LINKED_LOW_LEVEL_REQS_SHEET, new ArrayList());
        this.instructionBuilderFactoryByWorksheet.put(TemplateWorksheet.REQUIREMENT_SHEET, new Factory<RequirementSheetColumn>(){

            @Override
            public AbstractInstructionBuilder<?, ?> create(WorksheetDef<RequirementSheetColumn> wd) {
                return new RequirementInstructionBuilder(wd);
            }
        });
        this.instructionBuilderFactoryByWorksheet.put(TemplateWorksheet.TEST_CASES_SHEET, new Factory<TestCaseSheetColumn>(){

            @Override
            public AbstractInstructionBuilder<?, ?> create(WorksheetDef<TestCaseSheetColumn> wd) {
                return new TestCaseInstructionBuilder(wd);
            }
        });
        this.instructionBuilderFactoryByWorksheet.put(TemplateWorksheet.STEPS_SHEET, new Factory<StepSheetColumn>(){

            @Override
            public AbstractInstructionBuilder<?, ?> create(WorksheetDef<StepSheetColumn> wd) {
                return new StepInstructionBuilder(wd);
            }
        });
        this.instructionBuilderFactoryByWorksheet.put(TemplateWorksheet.PARAMETERS_SHEET, new Factory<ParameterSheetColumn>(){

            @Override
            public AbstractInstructionBuilder<?, ?> create(WorksheetDef<ParameterSheetColumn> wd) {
                return new ParameterInstructionBuilder(wd);
            }
        });
        this.instructionBuilderFactoryByWorksheet.put(TemplateWorksheet.DATASETS_SHEET, new Factory<DatasetSheetColumn>(){

            @Override
            public AbstractInstructionBuilder<?, ?> create(WorksheetDef<DatasetSheetColumn> wd) {
                return new DatasetInstructionBuilder(wd);
            }
        });
        this.instructionBuilderFactoryByWorksheet.put(TemplateWorksheet.DATASET_PARAM_VALUES_SHEET, new Factory<DatasetParamValuesSheetColumn>(){

            @Override
            public AbstractInstructionBuilder<?, ?> create(WorksheetDef<DatasetParamValuesSheetColumn> wd) {
                return new DatasetParamValueInstructionBuilder(wd);
            }
        });
        this.instructionBuilderFactoryByWorksheet.put(TemplateWorksheet.COVERAGE_SHEET, new Factory<CoverageSheetColumn>(){

            @Override
            public AbstractInstructionBuilder<?, ?> create(WorksheetDef<CoverageSheetColumn> wd) {
                return new CoverageInstructionBuilder(wd);
            }
        });
        this.instructionBuilderFactoryByWorksheet.put(TemplateWorksheet.REQUIREMENT_LINKS_SHEET, new Factory<RequirementLinksSheetColumn>(){

            @Override
            public AbstractInstructionBuilder<?, ?> create(WorksheetDef<RequirementLinksSheetColumn> wd) {
                return new RequirementLinkInstructionBuilder(wd);
            }
        });
        this.instructionBuilderFactoryByWorksheet.put(TemplateWorksheet.LINKED_LOW_LEVEL_REQS_SHEET, new Factory<LinkedLowLevelRequirementsSheetColumn>(){

            @Override
            public AbstractInstructionBuilder<?, ?> create(WorksheetDef<LinkedLowLevelRequirementsSheetColumn> wd) {
                return new LinkedLowLevelRequirementInstructionBuilder(wd);
            }
        });
    }

    public LogTrain logUnknownHeaders() {
        LogTrain logs = new LogTrain();
        for (WorksheetDef<? extends TemplateColumn> wd : this.wmd.getWorksheetDefs()) {
            Collection<UnknownColumnDef> unknowns = wd.getUnknownColumns();
            for (UnknownColumnDef unknown : unknowns) {
                LogEntry.Builder builder = LogEntry.failure().atLine(0).forTarget(this.createDummyTarget(wd)).withMessage("message.import.log.error.unknowncolumnheader", unknown.getHeader()).withImpact("message.import.log.impact.columnIgnored", null);
                logs.addEntry(builder.build());
            }
        }
        return logs;
    }

    private Target createDummyTarget(WorksheetDef<?> def) {
        return switch (def.getWorksheetType()) {
            case TemplateWorksheet.TEST_CASES_SHEET -> new TestCaseTarget();
            case TemplateWorksheet.STEPS_SHEET -> new TestStepTarget();
            case TemplateWorksheet.DATASETS_SHEET, TemplateWorksheet.DATASET_PARAM_VALUES_SHEET -> new DatasetTarget();
            case TemplateWorksheet.PARAMETERS_SHEET -> new ParameterTarget();
            case TemplateWorksheet.REQUIREMENT_SHEET -> new RequirementVersionTarget();
            case TemplateWorksheet.COVERAGE_SHEET -> new CoverageTarget();
            case TemplateWorksheet.REQUIREMENT_LINKS_SHEET -> new RequirementLinkTarget();
            case TemplateWorksheet.LINKED_LOW_LEVEL_REQS_SHEET -> new LinkedLowLevelRequirementTarget();
            default -> throw new IllegalArgumentException("sheet '" + def.getSheetName() + "' is unknown and contains errors in its column headers");
        };
    }

    public ExcelWorkbookParser parse() {
        LOGGER.info("Parsing test-cases excel workbook {}", new Object[]{this.workbook});
        if (this.workbook == null) {
            throw new IllegalStateException("No workbook available for parsing. Maybe you released this parser's resources by mistake.");
        }
        for (WorksheetDef<? extends TemplateColumn> wd : this.wmd.getWorksheetDefs()) {
            this.processWorksheet(wd);
        }
        LOGGER.debug("Done parsing test-cases workbook", new Object[0]);
        return this;
    }

    private void processWorksheet(WorksheetDef<?> worksheetDef) {
        LOGGER.debug("Processing worksheet {}", new Object[]{worksheetDef.getWorksheetType()});
        Sheet sheet = this.workbook.getSheet(worksheetDef.getSheetName());
        AbstractInstructionBuilder<?, ?> instructionBuilder = this.instructionBuilderFactoryByWorksheet.get((Object)worksheetDef.getWorksheetType()).create(worksheetDef);
        int i = 1;
        while (i <= sheet.getLastRowNum()) {
            LOGGER.trace("Creating instruction for row {}", new Object[]{i});
            Row row = sheet.getRow(i);
            if (!this.isEmpty(row)) {
                Object instruction = instructionBuilder.build(row);
                this.instructionsByWorksheet.get((Object)worksheetDef.getWorksheetType()).add((Instruction<?>)instruction);
            }
            ++i;
        }
    }

    public ExcelWorkbookParser releaseResources() {
        this.workbook = null;
        return this;
    }

    public List<TestCaseInstruction> getTestCaseInstructions() {
        return this.instructionsByWorksheet.get((Object)TemplateWorksheet.TEST_CASES_SHEET);
    }

    public List<StepInstruction> getTestStepInstructions() {
        return this.instructionsByWorksheet.get((Object)TemplateWorksheet.STEPS_SHEET);
    }

    public List<ParameterInstruction> getParameterInstructions() {
        return this.instructionsByWorksheet.get((Object)TemplateWorksheet.PARAMETERS_SHEET);
    }

    public List<DatasetInstruction> getDatasetInstructions() {
        return this.instructionsByWorksheet.get((Object)TemplateWorksheet.DATASETS_SHEET);
    }

    public List<DatasetParamValueInstruction> getDatasetParamValuesInstructions() {
        return this.instructionsByWorksheet.get((Object)TemplateWorksheet.DATASET_PARAM_VALUES_SHEET);
    }

    public List<RequirementVersionInstruction> getRequirementVersionInstructions() {
        return this.instructionsByWorksheet.get((Object)TemplateWorksheet.REQUIREMENT_SHEET);
    }

    public List<CoverageInstruction> getCoverageInstructions() {
        return this.instructionsByWorksheet.get((Object)TemplateWorksheet.COVERAGE_SHEET);
    }

    public List<RequirementLinkInstruction> getRequirementLinkgsInstruction() {
        return this.instructionsByWorksheet.get((Object)TemplateWorksheet.REQUIREMENT_LINKS_SHEET);
    }

    public List<LinkedLowLevelRequirementInstruction> getLinkedLowLevelRequirementInstruction() {
        return this.instructionsByWorksheet.get((Object)TemplateWorksheet.LINKED_LOW_LEVEL_REQS_SHEET);
    }

    public boolean isEmpty(Row row) {
        boolean isEmpty = true;
        if (row != null) {
            Iterator iterator = row.cellIterator();
            while (iterator.hasNext()) {
                Cell c = (Cell)iterator.next();
                if (StringUtils.isBlank((CharSequence)c.toString())) continue;
                isEmpty = false;
                break;
            }
        }
        return isEmpty;
    }

    public static final ExcelWorkbookParser createParser(File xls) throws SheetCorruptedException, TemplateMismatchException {
        return new ExcelWorkbookParserBuilder(xls).build();
    }

    private static interface Factory<C extends Enum<C>> {
        public AbstractInstructionBuilder<?, ?> create(WorksheetDef<C> var1);
    }
}

