/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.LinkedList;
import java.util.List;
import org.squashtest.tm.service.importer.ImportMode;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.service.importer.Target;

public class LogTrain {
    private List<LogEntry> entries = new LinkedList<LogEntry>();
    private boolean criticalErrors = false;

    public void addEntry(LogEntry entry) {
        if (entry != null) {
            this.entries.add(entry);
            if (entry.getStatus() == ImportStatus.FAILURE) {
                this.criticalErrors = true;
            }
        }
    }

    void addEntries(List<LogEntry> entries) {
        for (LogEntry entry : entries) {
            this.addEntry(entry);
        }
    }

    void append(LogTrain train) {
        this.addEntries(train.entries);
    }

    public List<LogEntry> getEntries() {
        return this.entries;
    }

    public boolean hasCriticalErrors() {
        return this.criticalErrors;
    }

    public boolean hasNoErrorWhatsoever() {
        return this.entries.isEmpty();
    }

    public void setForAll(int lineNumber) {
        for (LogEntry entry : this.entries) {
            entry.setLine(lineNumber);
        }
    }

    public void setForAll(ImportMode mode) {
        for (LogEntry entry : this.entries) {
            entry.setMode(mode);
        }
    }

    void setForAll(Target target) {
        for (LogEntry entry : this.entries) {
            entry.setTarget(target);
        }
    }
}

