/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchexport;

import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.squashtest.tm.service.internal.batchexport.models.CoverageModel;
import org.squashtest.tm.service.internal.library.HibernatePathService;
import org.squashtest.tm.service.internal.library.PathService;
import org.squashtest.tm.service.internal.repository.hibernate.EasyConstructorResultTransformer;

public final class ExportDaoUtils {
    private ExportDaoUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void setPathForCoverage(EntityManager em, PathService pathService, List<CoverageModel> coverageModels) {
        for (CoverageModel model : coverageModels) {
            model.setReqPath(ExportDaoUtils.getRequirementPath(em, model.getRequirementId(), model.getRequirementProjectName()));
            model.setTcPath(pathService.buildTestCasePath(model.getTcId()));
        }
    }

    public static String getRequirementPath(EntityManager em, Long requirementId, String requirementProjectName) {
        StringBuilder sb = new StringBuilder("\u001f");
        sb.append(requirementProjectName);
        sb.append("\u001f");
        String pathFromFolder = ExportDaoUtils.getPathFromFolder(em, requirementId);
        String pathFromParents = ExportDaoUtils.getPathFromParentsRequirements(em, requirementId);
        sb.append(pathFromFolder);
        sb.append(pathFromParents);
        return HibernatePathService.escapePath(sb.toString());
    }

    private static String getPathFromFolder(EntityManager em, Long requirementId) {
        String result = ExportDaoUtils.requirementVersionQuery(em, "requirement.findReqFolderPath", requirementId, "");
        return result.isEmpty() ? result : String.valueOf(result) + "\u001f";
    }

    private static String getPathFromParentsRequirements(EntityManager em, Long requirementId) {
        return ExportDaoUtils.requirementVersionQuery(em, "requirement.findReqParentPath", requirementId, "");
    }

    public static <R> R requirementVersionQuery(EntityManager em, String queryName, Long requirementId, R defaultValue) {
        Session session = ExportDaoUtils.getStatelessSession(em);
        Query q = session.getNamedQuery(queryName);
        q.setParameter("requirementId", (Object)requirementId);
        Object result = q.uniqueResult();
        return (R)(result != null ? result : defaultValue);
    }

    public static <R> List<R> loadModels(EntityManager em, String queryName, List<Long> ids, String paramName, Class<R> resclass) {
        ids = !ids.isEmpty() ? ids : Collections.singletonList(-1L);
        Session session = ExportDaoUtils.getStatelessSession(em);
        Query q = session.getNamedQuery(queryName);
        q.setParameterList(paramName, ids, (Type)LongType.INSTANCE);
        q.setResultTransformer((ResultTransformer)new EasyConstructorResultTransformer(resclass));
        return q.list();
    }

    public static Session getStatelessSession(EntityManager em) {
        Session s = (Session)em.unwrap(Session.class);
        s.setHibernateFlushMode(FlushMode.MANUAL);
        return s;
    }
}

