/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.attachment;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.commons.io.IOUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.hibernate.JDBCException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentContent;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.attachment.ExternalContentCoordinates;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.execution.ConsumerForExploratoryExecution;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.execution.ExecutionVisitor;
import org.squashtest.tm.domain.execution.ExploratoryExecutionRunningState;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.exception.attachment.AttachmentException;
import org.squashtest.tm.exception.campaign.SprintClosedException;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.attachment.RawAttachment;
import org.squashtest.tm.service.attachment.UploadedData;
import org.squashtest.tm.service.audit.AuditModificationService;
import org.squashtest.tm.service.execution.ExploratoryExecutionService;
import org.squashtest.tm.service.internal.attachment.AttachmentManagerServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.display.dto.AttachmentDto;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.repository.AttachmentContentDao;
import org.squashtest.tm.service.internal.repository.AttachmentDao;
import org.squashtest.tm.service.internal.repository.AttachmentListDao;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.EntityGraphQueryBuilder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;
import org.squashtest.tm.service.user.UserAccountService;

@Service(value="squashtest.tm.service.AttachmentManagerService")
@Transactional
public class AttachmentManagerServiceImpl
implements AttachmentManagerService {
    private static final int EOF = -1;
    @PersistenceContext
    private EntityManager em;
    @Inject
    private AttachmentDao attachmentDao;
    @Inject
    private AttachmentListDao attachmentListDao;
    @Inject
    private AttachmentContentDao attachmentContentDao;
    @Inject
    private AttachmentRepository attachmentRepository;
    @Inject
    private AuditModificationService auditModificationService;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private UserAccountService userAccountService;
    @Inject
    private ExploratoryExecutionService exploratoryExecutionService;
    @Inject
    private MilestoneDao milestoneDao;
    @Inject
    private SprintDisplayDao sprintDisplayDao;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    public AttachmentDto addAttachment(long attachmentListId, RawAttachment rawAttachment, EntityReference permissionOwner, EntityType holderType) throws IOException {
        this.milestoneDao.checkBlockingMilestonesOnAttachmentList(holderType, attachmentListId);
        this.checkExploratorySessionSpecificCase(permissionOwner);
        this.checkCanAttach(permissionOwner.getId(), permissionOwner.getType().getEntityClass().getName());
        this.checkParentSprintStatus(permissionOwner);
        return this.addAttachment(attachmentListId, rawAttachment, holderType);
    }

    private AttachmentDto addAttachmentWithoutPermissionCheck(long attachmentListId, RawAttachment rawAttachment, EntityReference entityReference) throws IOException {
        return this.addAttachment(attachmentListId, rawAttachment, entityReference.getType());
    }

    @Override
    public AttachmentDto addAttachment(long attachmentListId, RawAttachment rawAttachment, EntityType holderType) throws IOException {
        AttachmentContent content = this.getAttachmentRepository().createContent(rawAttachment, attachmentListId);
        Attachment attachment = new Attachment();
        AttachmentList list = this.attachmentListDao.getOne(attachmentListId);
        list.addAttachment(attachment);
        attachment.setContent(content);
        attachment.setAddedOn(new Date());
        attachment.setName(rawAttachment.getName());
        attachment.setSize(Long.valueOf(rawAttachment.getSizeInBytes()));
        this.attachmentDao.save(attachment);
        this.auditModificationService.updateRelatedToAttachmentAuditableEntity(attachmentListId, holderType);
        return new AttachmentDto(attachment);
    }

    @Override
    public AttachmentDto updateAttachmentContent(Attachment attachment, InputStream newContent) throws IOException {
        try {
            AttachmentContent content = attachment.getContent();
            byte[] byteArray = newContent.readAllBytes();
            SerialBlob newBlob = new SerialBlob(byteArray);
            content.setContent((Blob)newBlob);
            attachment.setContent(content);
            attachment.setLastModifiedOn(new Date());
            this.attachmentDao.save(attachment);
            return new AttachmentDto(attachment);
        }
        catch (SQLException e) {
            throw new JDBCException("Cannot read blob property as a stream", e);
        }
    }

    private void checkExploratorySessionSpecificCase(EntityReference permissionOwner) {
        Execution execution;
        boolean isExploratorySession;
        if (EntityType.EXECUTION.equals((Object)permissionOwner.getType()) && (isExploratorySession = TestCaseExecutionMode.EXPLORATORY.equals((Object)(execution = new EntityGraphQueryBuilder<Execution>(this.em, Execution.class, "SELECT e FROM Execution e WHERE e.id = :id").addSubGraph("automatedExecutionExtender", new String[0]).execute(Map.of("id", permissionOwner.getId()))).getExecutionMode()))) {
            this.checkExploratorySessionRunningState(execution);
        }
    }

    private void checkParentSprintStatus(EntityReference permissionOwner) {
        SprintStatus sprintStatus;
        if (EntityType.EXECUTION.equals((Object)permissionOwner.getType()) ? SprintStatus.CLOSED.equals((Object)(sprintStatus = this.sprintDisplayDao.getSprintStatusByExecutionId(permissionOwner.getId()))) : EntityType.EXPLORATORY_SESSION_OVERVIEW.equals((Object)permissionOwner.getType()) && SprintStatus.CLOSED.equals((Object)(sprintStatus = this.sprintDisplayDao.getSprintStatusBySessionOverviewId(permissionOwner.getId())))) {
            throw new SprintClosedException();
        }
    }

    private AttachmentRepository getAttachmentRepository() {
        return this.attachmentRepository;
    }

    @Override
    public Attachment findAttachment(Long attachmentId) throws AccessDeniedException {
        this.checkUserPermissionsOnProject(attachmentId);
        return this.findById(attachmentId);
    }

    private List<Attachment> findAttachmentsForDeletion(List<Long> attachmentIds) {
        return this.attachmentDao.findAttachmentsForDeletion(attachmentIds);
    }

    @Override
    public void checkReadPermissionOnProjectByAttachmentListId(Long attachmentListId) {
        UserDto user = this.userAccountService.findCurrentUserDto();
        if (!user.isAdmin()) {
            AttachmentHolder holder = this.attachmentListDao.findAttachmentHolder(attachmentListId);
            Long projectId = holder.getAttachmentHolderProjectId();
            PermissionsUtils.checkPermission(this.permissionEvaluationService, Collections.singletonList(projectId), Permissions.READ.name(), Project.class.getName());
        }
    }

    private Attachment findById(Long attachmentId) {
        return (Attachment)this.attachmentDao.getReferenceById(attachmentId);
    }

    private void checkUserPermissionsOnProject(Long attachmentId) throws AccessDeniedException {
        Long attachmentListId = this.attachmentListDao.findAttachmentListIdByAttachmentId(attachmentId);
        if (Objects.isNull(attachmentListId)) {
            String accessDenied = "Unauthorized access or non-existent attachment: " + attachmentId.toString();
            throw new IllegalArgumentException(accessDenied);
        }
        this.checkReadPermissionOnProjectByAttachmentListId(attachmentListId);
    }

    @Override
    public void removeListOfAttachments(@Id long attachmentListId, List<Long> attachmentIds, EntityReference permissionOwner, EntityType holderType) throws AccessDeniedException {
        this.milestoneDao.checkBlockingMilestonesOnAttachmentList(holderType, attachmentListId);
        this.checkExploratorySessionSpecificCase(permissionOwner);
        this.checkCanAttach(permissionOwner.getId(), permissionOwner.getType().getEntityClass().getName());
        this.checkParentSprintStatus(permissionOwner);
        ArrayList<ExternalContentCoordinates> externalContentCoordinates = new ArrayList<ExternalContentCoordinates>();
        List<Attachment> attachments = this.findAttachmentsForDeletion(attachmentIds);
        for (Attachment attachment : attachments) {
            Long attachmentContentId = attachment.getContent().getId();
            externalContentCoordinates.add(new ExternalContentCoordinates(Long.valueOf(attachmentListId), attachmentContentId));
        }
        this.attachmentDao.deleteAllByIdInBatch(attachmentIds);
        this.deleteContents(externalContentCoordinates);
        this.auditModificationService.updateRelatedToAttachmentAuditableEntity(attachmentListId, holderType);
    }

    private void checkExploratorySessionRunningState(Execution execution) {
        execution.accept((ExecutionVisitor)new ConsumerForExploratoryExecution(exploratoryExecution -> {
            ExploratoryExecutionRunningState currentState = this.exploratoryExecutionService.findExploratoryExecutionRunningState(exploratoryExecution.getId());
            this.exploratoryExecutionService.checkSessionIsNotStopped(currentState);
        }));
    }

    @Override
    @CheckBlockingMilestone(entityType=Attachment.class)
    public void renameAttachment(@Id long attachmentId, String newName) {
        Attachment attachment = (Attachment)this.attachmentDao.getReferenceById(attachmentId);
        AttachmentHolder holder = this.attachmentListDao.findAttachmentHolder(attachment.getAttachmentList().getId());
        EntityReference entityRef = holder.toEntityReference();
        this.checkCanAttach(entityRef.getId(), entityRef.getType().getEntityClass().getName());
        attachment.setShortName(newName);
    }

    @Override
    public Page<Attachment> findPagedAttachments(AttachmentHolder attached, Pageable pas) {
        return this.findPagedAttachments(attached.getAttachmentList().getId(), pas);
    }

    private Page<Attachment> findPagedAttachments(long attachmentListId, Pageable pageable) {
        return this.attachmentDao.findAllAttachmentsPagined(attachmentListId, pageable);
    }

    @Override
    public void writeContent(long attachmentId, OutputStream outStream) throws IOException {
        int readByte;
        InputStream is = this.getAttachmentRepository().getContentStream(attachmentId);
        do {
            if ((readByte = is.read()) == -1) continue;
            outStream.write(readByte);
        } while (readByte != -1);
        is.close();
    }

    @Override
    public void copyContent(Attachment attachment) {
        this.getAttachmentRepository().copyContent(attachment);
    }

    @Override
    public void copyContentsOnExternalRepository(AttachmentHolder attachmentHolder) {
        this.em.flush();
        AttachmentList attachmentList = attachmentHolder.getAttachmentList();
        for (Attachment attachment : attachmentList.getAllAttachments()) {
            this.copyContent(attachment);
        }
    }

    @Override
    public void batchCopyContentsOnExternalRepository(List<AttachmentHolder> attachmentHolders) {
        this.em.flush();
        for (AttachmentHolder attachmentHolder : attachmentHolders) {
            AttachmentList attachmentList = attachmentHolder.getAttachmentList();
            for (Attachment attachment : attachmentList.getAllAttachments()) {
                this.copyContent(attachment);
            }
        }
    }

    private void removeContentFromFileSystem(long attachmentListId, long attachmentContentId) {
        this.attachmentRepository.removeContent(attachmentListId, attachmentContentId);
    }

    @Override
    public List<ExternalContentCoordinates> getListIDbyContentIdForAttachmentLists(List<Long> attachmentsList) {
        return this.attachmentContentDao.getListPairContentIDListIDFromAttachmentLists(attachmentsList);
    }

    @Override
    public void deleteContents(List<ExternalContentCoordinates> contentIdListIdList) {
        ArrayList<Long> contentIds = new ArrayList<Long>();
        for (ExternalContentCoordinates coord : contentIdListIdList) {
            contentIds.add(coord.getContentId());
        }
        this.removeOrphanAttachmentContents(contentIds);
        if (this.attachmentRepository.getClass().getSimpleName().contains("FileSystemAttachmentRepository")) {
            for (ExternalContentCoordinates externalCoord : contentIdListIdList) {
                this.removeContentFromFileSystem(externalCoord.getAttachmentListId(), externalCoord.getContentId());
            }
        }
    }

    private void removeOrphanAttachmentContents(List<Long> contentIds) {
        if (!contentIds.isEmpty()) {
            Set<Long> notOrphans = this.attachmentContentDao.findNotOrphanAttachmentContent(contentIds);
            contentIds.removeAll(notOrphans);
            if (!contentIds.isEmpty()) {
                this.attachmentContentDao.deleteByIds(contentIds);
            }
        }
    }

    @Override
    public void removeAttachmentsAndLists(List<Long> attachmentListIds) {
        if (!attachmentListIds.isEmpty()) {
            Set<Long> attachmentIds = this.attachmentDao.findAllAttachmentsFromLists(attachmentListIds);
            if (!attachmentIds.isEmpty()) {
                this.attachmentDao.removeAllAttachments(attachmentIds);
            }
            this.attachmentDao.removeAllAttachmentsLists(attachmentListIds);
        }
    }

    @Override
    public List<Long> getAttachmentsListsFromRequirementFolders(List<Long> requirementLibraryNodeIds) {
        return this.attachmentDao.findAttachmentsListsFromRequirementFolder(requirementLibraryNodeIds);
    }

    @Override
    public List<ExternalContentCoordinates> getListPairContentIDListIDForExecutionSteps(Collection<ExecutionStep> executionSteps) {
        ArrayList<Long> executionStepsIds = new ArrayList<Long>();
        for (ExecutionStep executionStep : executionSteps) {
            executionStepsIds.add(executionStep.getId());
        }
        return this.attachmentDao.getListPairContentIDListIDForExecutionSteps(executionStepsIds);
    }

    @Override
    public List<ExternalContentCoordinates> getListPairContentIDListIDForExecutionIds(List<Long> executionStepsIds) {
        List<Long> list = executionStepsIds;
        AttachmentDao attachmentDao = this.attachmentDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)attachmentDao, list);
        Object[] objectArray = new Object[]{this, attachmentDao, list, joinPoint};
        AttachmentManagerServiceImpl$AjcClosure1 attachmentManagerServiceImpl$AjcClosure1 = new AttachmentManagerServiceImpl$AjcClosure1(objectArray);
        return (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(attachmentManagerServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
    }

    @Override
    public List<ExternalContentCoordinates> getListPairContentIDListIDForAutomatedSuiteIds(List<String> automatedSuiteIds) {
        return this.attachmentDao.getListPairContentIDListIDForAutomatedSuiteIds(automatedSuiteIds);
    }

    @Override
    public String addAttachmentsFromRichText(String html, Long attachmentListId, EntityReference entityReference) {
        Document document = Jsoup.parse((String)html);
        Elements elements = document.select("img");
        if (!elements.isEmpty()) {
            elements.forEach(element -> {
                String imageSrc = element.attr("src");
                if (this.imageIsBase64(imageSrc)) {
                    String imageName = this.getImageName((Element)element, imageSrc);
                    this.addAttachmentFromBase64(attachmentListId, entityReference, (Element)element, imageSrc, imageName);
                }
            });
            return document.body().html();
        }
        return html;
    }

    @Override
    public String copyAttachmentsFromRichText(String html, Long attachmentListId, Long copiedAttachmentListId, EntityReference entityReference) {
        Document document = Jsoup.parse((String)html);
        Elements elements = document.select("img");
        if (elements.isEmpty()) {
            return html;
        }
        elements.forEach(element -> {
            String imageSrc = element.attr("src");
            if (this.imageIsAttachment(imageSrc, copiedAttachmentListId)) {
                this.processCopyAttachmentImage((Element)element, imageSrc, attachmentListId, entityReference);
            }
        });
        return document.body().html();
    }

    @Override
    public String updateRichTextUrlsOnEntityCopy(AttachmentList sourceAttachmentList, AttachmentList copyAttachmentList, String richText) {
        Long sourceAttachmentListId = sourceAttachmentList.getId();
        String attachmentListUrl = String.format("/backend/attach-list/%d/attachments/download/", sourceAttachmentListId);
        if (richText != null && richText.contains(attachmentListUrl)) {
            String currentRichText = richText;
            StringBuilder richTextBuilder = new StringBuilder(richText);
            sourceAttachmentList.getAllAttachments().stream().filter(sourceAttachment -> AttachmentManagerServiceImpl.isSourcePresent(sourceAttachment, sourceAttachmentListId, currentRichText)).forEach(sourceAttachment -> copyAttachmentList.getAllAttachments().stream().filter(copyAttachment -> this.isTheCopiedAttachment(sourceAttachment.getId(), copyAttachment.getId())).forEach(copyAttachment -> this.replaceSourceUrl((Attachment)sourceAttachment, (Attachment)copyAttachment, attachmentListUrl, copyAttachmentList, richTextBuilder)));
            richText = richTextBuilder.toString();
        }
        return richText;
    }

    @Override
    public void removeAttachmentsAndContents(List<Long> attachmentListIds, List<ExternalContentCoordinates> externalContentCoordinates) {
        Set<Long> attachmentIds = this.attachmentDao.findAllAttachmentsFromLists(attachmentListIds);
        if (!attachmentIds.isEmpty()) {
            this.attachmentDao.removeAllAttachments(attachmentIds);
        }
        this.deleteContents(externalContentCoordinates);
    }

    private void replaceSourceUrl(Attachment sourceAttachment, Attachment copyAttachment, String baseSourceUrl, AttachmentList copyAttachmentList, StringBuilder richTextBuilder) {
        String sourceUrl = String.valueOf(baseSourceUrl) + sourceAttachment.getId();
        String copyURL = String.format("/backend/attach-list/%d/attachments/download/%d", copyAttachmentList.getId(), copyAttachment.getId());
        int startIndex = richTextBuilder.indexOf(sourceUrl);
        if (startIndex != -1) {
            richTextBuilder.replace(startIndex, startIndex + sourceUrl.length(), copyURL);
        }
    }

    private static boolean isSourcePresent(Attachment sourceAttachment, Long sourceAttachmentListId, String richText) {
        String originalURL = String.format("/backend/attach-list/%d/attachments/download/%d", sourceAttachmentListId, sourceAttachment.getId());
        return richText.contains(originalURL);
    }

    private boolean isTheCopiedAttachment(Long sourceAttachmentId, Long copyAttachmentId) {
        try {
            return IOUtils.contentEquals((InputStream)this.attachmentRepository.getContentStream(sourceAttachmentId), (InputStream)this.attachmentRepository.getContentStream(copyAttachmentId));
        }
        catch (IOException e) {
            throw new AttachmentException((Throwable)e);
        }
    }

    private void processCopyAttachmentImage(Element element, String imageSrc, Long attachmentListId, EntityReference entityReference) {
        Long attId = this.extractAttachmentIdFromSrc(imageSrc);
        Attachment attachment = (Attachment)this.attachmentDao.getReferenceById(attId);
        try {
            InputStream stream = attachment.getContent().getStream();
            UploadedData uploadedData = new UploadedData(stream, attachment.getName(), stream.available());
            AttachmentDto attachmentDto = this.addAttachmentWithoutPermissionCheck(attachmentListId, uploadedData, entityReference);
            element.attr("src", this.buildFileUploadUrl(attachmentListId, attachmentDto.getId()));
        }
        catch (IOException e) {
            throw new AttachmentException((Throwable)e);
        }
    }

    private Long extractAttachmentIdFromSrc(String imageSrc) {
        String idString = imageSrc.substring(imageSrc.lastIndexOf("/") + 1);
        return Long.parseLong(idString);
    }

    private boolean imageIsAttachment(String imageSrc, Long copiedAttachmentListId) {
        return imageSrc.contains("/backend/attach-list/" + copiedAttachmentListId + "/attachments/download/");
    }

    private String getImageName(Element element, String imageBase64) {
        String imageName = element.attr("alt");
        if (imageName.isEmpty()) {
            return this.generateDefaultImageName(imageBase64);
        }
        return imageName;
    }

    private String generateDefaultImageName(String imageBase64) {
        String defaultImageName = "image.";
        String[] parts = imageBase64.split(",");
        String mediaType = parts[0];
        String extension = mediaType.substring("data:image/".length());
        if (extension.contains(";")) {
            extension = extension.substring(0, extension.indexOf(";"));
        }
        return String.valueOf(defaultImageName) + extension;
    }

    private void addAttachmentFromBase64(Long attachmentListId, EntityReference entityReference, Element element, String imageSrc, String imageName) {
        String base64Image = imageSrc.split(",")[1];
        byte[] imageBytes = Base64.getDecoder().decode(base64Image);
        ByteArrayInputStream targetStream = new ByteArrayInputStream(imageBytes);
        try {
            UploadedData uploadedData = new UploadedData(targetStream, imageName, ((InputStream)targetStream).available());
            AttachmentDto attachmentDto = this.addAttachmentWithoutPermissionCheck(attachmentListId, uploadedData, entityReference);
            element.attr("src", this.buildFileUploadUrl(attachmentListId, attachmentDto.getId()));
        }
        catch (IOException e) {
            throw new AttachmentException((Throwable)e);
        }
    }

    private String buildFileUploadUrl(Long attachmentListId, Long attachmentId) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        StringBuilder builder = new StringBuilder();
        builder.append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort());
        builder.append(request.getContextPath());
        builder.append("/backend/attach-list/");
        builder.append(attachmentListId);
        builder.append("/attachments/download/");
        builder.append(attachmentId);
        return builder.toString();
    }

    private boolean imageIsBase64(String imageSrc) {
        String regex = "^data:image\\/(png|jpeg|jpg|gif|svg|bmp);base64,([A-Za-z0-9+/]+={0,2})$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(imageSrc);
        return matcher.matches();
    }

    private void checkCanAttach(long entityId, String entityClassName) {
        String[] roles = new String[]{"ROLE_ADMIN", "ROLE_TA_API_CLIENT"};
        String permissionName = Project.class.getName().equals(entityClassName) ? Permissions.MANAGE_PROJECT.name() : Permissions.ATTACH.name();
        boolean permission = this.permissionEvaluationService.hasRoleOrPermissionOnObject(roles, permissionName, (Long)entityId, entityClassName);
        if (!permission) {
            throw new AccessDeniedException("Access is denied");
        }
    }

    static {
        AttachmentManagerServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ List getListPairContentIDListIDForExecutions_aroundBody0(AttachmentManagerServiceImpl attachmentManagerServiceImpl, AttachmentDao attachmentDao, List list, JoinPoint joinPoint) {
        return attachmentDao.getListPairContentIDListIDForExecutions(list);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AttachmentManagerServiceImpl.java", AttachmentManagerServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "getListPairContentIDListIDForExecutions", "org.squashtest.tm.service.internal.repository.AttachmentDao", "java.util.List", "arg0", "", "java.util.List"), 452);
    }
}

