/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.validation.constraints.NotNull;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.UnauthorizedPasswordChange;
import org.squashtest.tm.domain.acl.AclGroup;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.domain.users.Team;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.domain.users.UsersGroup;
import org.squashtest.tm.exception.IllegalUserGroupTransitionException;
import org.squashtest.tm.exception.NotAllowedByLicenseException;
import org.squashtest.tm.exception.user.ActiveUserDeleteException;
import org.squashtest.tm.exception.user.LoginAlreadyExistsException;
import org.squashtest.tm.exception.user.MilestoneOwnerDeleteException;
import org.squashtest.tm.exception.user.UserWithSynchronisationsDeleteException;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.display.user.UserDisplayService;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.display.dto.MilestonePossibleOwnerDto;
import org.squashtest.tm.service.internal.dto.DetailedUserDto;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.repository.ProfileDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.RemoteSynchronisationDao;
import org.squashtest.tm.service.internal.repository.TeamDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.internal.repository.UsersGroupDao;
import org.squashtest.tm.service.internal.security.UserBuilder;
import org.squashtest.tm.service.license.LicenseHelperService;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.milestone.MilestoneManagerService;
import org.squashtest.tm.service.project.ProjectFilterModificationService;
import org.squashtest.tm.service.security.AdministratorAuthenticationService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.acls.model.ObjectAclService;
import org.squashtest.tm.service.user.AuthenticatedUser;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.service.user.UserAdministrationService;

@Service(value="squashtest.tm.service.AdministrationService")
@Transactional
public class UserAdministrationServiceImpl
implements UserAdministrationService {
    private static final String PLUGIN_LICENSE_EXPIRATION = "plugin.license.expiration";
    private static final String ACTIVATED_USER_EXCESS = "activated.user.excess";
    public static final String AUTOMATION_WORKSPACE_URL = "/automation-workspace";
    public static final String HOME_WORKSPACE_URL = "/home-workspace";
    @Inject
    private UserAccountService userAccountService;
    @Inject
    private UserDisplayService userDisplayService;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private UserDao userDao;
    @Inject
    private UsersGroupDao groupDao;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private TeamDao teamDao;
    @Inject
    private ObjectAclService aclService;
    @Inject
    private AdministratorAuthenticationService adminAuthentService;
    @Inject
    private MilestoneManagerService milestoneManagerService;
    @Inject
    private FeatureManager features;
    @Inject
    private LicenseHelperService licenseHelperService;
    @Inject
    private SessionRegistry sessionRegistry;
    @Inject
    private RemoteSynchronisationDao remoteSynchronisationDao;
    @Inject
    private ProjectFilterModificationService projectFilterModificationService;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private UltimateLicenseAvailabilityService ultimateLicenseAvailabilityService;
    @Inject
    private ProfileDao profileDao;
    @PersistenceContext
    private EntityManager em;

    public void setAdministratorAuthenticationService(AdministratorAuthenticationService adminService) {
        this.adminAuthentService = adminService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Override
    public void modifyUserFirstName(long userId, String newName) {
        this.userAccountService.modifyUserFirstName(userId, newName);
    }

    @Override
    public void modifyUserLastName(long userId, String newName) {
        this.userAccountService.modifyUserLastName(userId, newName);
    }

    @Override
    public void modifyUserLogin(long userId, String newLogin) {
        this.userAccountService.modifyUserLogin(userId, newLogin);
    }

    @Override
    public void modifyUserEmail(long userId, String newEmail) {
        this.userAccountService.modifyUserEmail(userId, newEmail);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public AuthenticatedUser findUserById(long userId) {
        User user = (User)this.userDao.getReferenceById(userId);
        boolean hasAuth = this.adminAuthentService.userExists(user.getLogin());
        return new AuthenticatedUser(user, hasAuth);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public List<UsersGroup> findAllUsersGroupOrderedByQualifiedName() {
        return this.groupDao.findAllGroupsOrderedByQualifiedName();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void addUser(User user, long groupId, String password) {
        this.licenseHelperService.assertLicenseAllowsToAddOrActivateUser();
        this.createUserWithoutCredentials(user, groupId);
        this.adminAuthentService.createNewUserPassword(user.getLogin(), password, user.getActive(), true, true, true, new ArrayList<GrantedAuthority>());
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void setUserGroupAuthority(long userId, long groupId) {
        UsersGroup group = (UsersGroup)this.groupDao.getReferenceById(groupId);
        if ("squashtest.authz.group.tm.TestAutomationServer".equals(group.getQualifiedName())) {
            throw new IllegalUserGroupTransitionException();
        }
        User user = (User)this.userDao.getReferenceById(userId);
        if ("squashtest.authz.group.tm.TestAutomationServer".equals(user.getGroup().getQualifiedName())) {
            throw new IllegalUserGroupTransitionException();
        }
        user.setGroup(group);
        this.aclService.refreshAcls();
        this.expireSessionInformationIfUserIsLogged(user.getLogin());
    }

    private void expireSessionInformationIfUserIsLogged(String login) {
        UserDetails user = this.sessionRegistry.getAllPrincipals().stream().map(springUser -> (UserDetails)springUser).filter(inspectedUser -> login.equals(inspectedUser.getUsername())).findAny().orElse(null);
        if (Objects.nonNull(user)) {
            List targetUserSessionInformationList = this.sessionRegistry.getAllSessions((Object)user, false);
            targetUserSessionInformationList.forEach(SessionInformation::expireNow);
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deactivateUser(long userId) {
        User user = (User)this.userDao.getReferenceById(userId);
        this.checkHasSynchronisations(user);
        this.checkActiveUser(user);
        this.userAccountService.deactivateUser(userId);
        this.adminAuthentService.deactivateAccount(user.getLogin());
        this.aclService.refreshAcls();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void activateUser(long userId) {
        this.userAccountService.activateUser(userId);
        User user = (User)this.userDao.getReferenceById(userId);
        this.adminAuthentService.activateAccount(user.getLogin());
        this.aclService.refreshAcls();
        this.aclService.refreshAcls();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deactivateUsers(Collection<Long> userIds) {
        for (Long id : userIds) {
            this.deactivateUser(id);
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void activateUsers(Collection<Long> userIds) {
        for (Long id : userIds) {
            this.activateUser(id);
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteUsers(Collection<Long> userIds) {
        this.checkUsersOwnMilestones(userIds);
        for (Long id : userIds) {
            User user = (User)this.userDao.getReferenceById(id);
            this.checkHasSynchronisations(user);
            this.checkActiveUser(user);
            this.projectFilterModificationService.removeProjectFiltersByUserLogin(user.getLogin());
            this.userAccountService.deleteUser(id);
            this.adminAuthentService.deleteAccount(user.getLogin());
            this.userDao.delete(user);
        }
        this.aclService.refreshAcls();
    }

    private void checkUsersOwnMilestones(Collection<Long> userIds) {
        if (this.milestoneManagerService.hasMilestone(new ArrayList<Long>(userIds))) {
            throw new MilestoneOwnerDeleteException();
        }
    }

    private void checkHasSynchronisations(User user) {
        if (!this.remoteSynchronisationDao.findByOwnerId(user.getId()).isEmpty()) {
            throw new UserWithSynchronisationsDeleteException();
        }
    }

    private void checkActiveUser(User user) {
        String activeUserName = UserContextHolder.getUsername();
        if (user.getLogin().equals(activeUserName)) {
            throw new ActiveUserDeleteException();
        }
    }

    @Override
    public List<RemoteSynchronisation> getSynchronisationsByUser(Long userId) {
        return this.remoteSynchronisationDao.findByOwnerId(userId);
    }

    @Override
    public List<Project> findAllProjects() {
        return this.projectDao.findAll();
    }

    @Override
    public Map<String, String> findPostLoginInformation() {
        UserDto current;
        String excess;
        HashMap<String, String> result = new HashMap<String, String>();
        String expiration = this.configurationService.findConfiguration(PLUGIN_LICENSE_EXPIRATION);
        if (this.hasInformation(expiration, excess = this.configurationService.findConfiguration(ACTIVATED_USER_EXCESS)) && (current = this.userAccountService.findCurrentUserDto()).isAdmin()) {
            if (expiration != null && !expiration.isEmpty()) {
                this.retrieveInformationDate(result, expiration);
            }
            if (excess != null && !excess.isEmpty()) {
                this.retrieveInformationUser(result, excess);
            }
        }
        return result;
    }

    private Map<String, String> retrieveInformationDate(Map<String, String> result, String expiration) {
        Integer expi = Integer.parseInt(expiration);
        if (expi < 0) {
            String messageDate = "warning3";
            result.put("messageDate", messageDate);
            result.put("daysRemaining", expi.toString());
        }
        return result;
    }

    private Map<String, String> retrieveInformationUser(Map<String, String> result, String excess) {
        String[] excesses = excess.split("-");
        if (excesses.length == 3 && !Boolean.parseBoolean(excesses[2])) {
            result.put("messageUser", "warning2");
            result.put("currentUserNb", excesses[0]);
            result.put("maxUserNb", excesses[1]);
        }
        return result;
    }

    private boolean hasInformation(String informationDate, String informationUser) {
        return informationDate != null && !informationDate.isEmpty() || informationUser != null && !informationUser.isEmpty();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void resetUserPassword(long userId, String newPassword) {
        User user = (User)this.userDao.getReferenceById(userId);
        this.adminAuthentService.resetUserPassword(user.getLogin(), newPassword);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deassociateTeams(long userId, List<Long> teamIds) {
        User user = (User)this.userDao.getReferenceById(userId);
        List teams = this.teamDao.findAllById(teamIds);
        for (Team team : teams) {
            team.removeMember(user);
        }
        user.removeTeams(teamIds);
        this.aclService.refreshAcls();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Set<String> associateToTeams(long userId, List<Long> teamIds) {
        User user = (User)this.userDao.getReferenceById(userId);
        List teams = this.teamDao.findAllById(teamIds);
        Set<String> teamsWithCustomProfiles = this.removeTeamsWithCustomProfile(teams, teamIds);
        for (Team team : teams) {
            team.addMember(user);
            user.addTeam(team);
        }
        this.aclService.refreshAcls();
        return teamsWithCustomProfiles;
    }

    private Set<String> removeTeamsWithCustomProfile(List<Team> teams, List<Long> teamIds) {
        if (this.ultimateLicenseAvailabilityService.isAvailable()) {
            return Collections.emptySet();
        }
        HashSet<String> teamsWithCustomProfiles = new HashSet<String>();
        Map teamsAndProfileNames = this.profileDao.findProfileNamesByPartyIds(teamIds);
        teamsAndProfileNames.forEach((teamId, profileNames) -> this.removeTeamWithCustomProfile(teams, (long)teamId, (List<String>)profileNames, (Set<String>)teamsWithCustomProfiles));
        return teamsWithCustomProfiles;
    }

    private void removeTeamWithCustomProfile(List<Team> teams, long teamId, List<String> profileNames, Set<String> teamsWithCustomProfiles) {
        String teamName;
        if (profileNames.stream().anyMatch(profileName -> !AclGroup.isSystem((String)profileName)) && Objects.nonNull(teamName = this.findTeamNameById(teams, teamId))) {
            teamsWithCustomProfiles.add(teamName);
            teams.removeIf(team -> team.getId().equals(teamId));
        }
    }

    private String findTeamNameById(List<Team> teams, Long teamId) {
        return teams.stream().filter(team -> team.getId().equals(teamId)).map(Team::getName).findFirst().orElse(null);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public List<Team> findAllNonAssociatedTeams(long userId) {
        return this.teamDao.findAllNonAssociatedTeams(userId);
    }

    @Override
    public User findByLogin(String login) {
        String string = login;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        return this.userDao.findUserByLogin(login);
    }

    @Override
    public User createUserFromLogin(@NotNull String login) throws LoginAlreadyExistsException {
        String string = login;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        this.licenseHelperService.assertLicenseAllowsToAddOrActivateUser();
        String loginTrim = login.trim();
        this.checkLoginAvailability(loginTrim);
        User user = User.createFromLogin((String)loginTrim);
        UsersGroup defaultGroup = this.groupDao.findByQualifiedName("squashtest.authz.group.tm.User");
        user.setGroup(defaultGroup);
        this.userDao.save(user);
        return user;
    }

    @Override
    public void createUserWithoutCredentials(User user, long groupId) {
        this.checkLoginAvailability(user.getLogin());
        UsersGroup group = (UsersGroup)this.groupDao.getReferenceById(groupId);
        user.setGroup(group);
        this.userDao.save(user);
    }

    @Override
    public void createUserWithoutCredentials(User user, String usergroupName) {
        this.checkLoginAvailability(user.getLogin());
        UsersGroup group = this.groupDao.findByQualifiedName(usergroupName);
        user.setGroup(group);
        this.userDao.save(user);
    }

    @Override
    public void createAuthentication(long userId, String password) throws LoginAlreadyExistsException {
        if (!this.adminAuthentService.canModifyUser()) {
            throw new UnauthorizedPasswordChange("The authentication service do not allow users to change their passwords using Squash");
        }
        User user = (User)this.userDao.getReferenceById(userId);
        if (this.adminAuthentService.userExists(user.getLogin())) {
            throw new LoginAlreadyExistsException("Authentication data for user '" + user.getLogin() + "' already exists");
        }
        UserDetails auth = UserBuilder.forUser(user.getLogin()).password(password).active(user.getActive()).build();
        this.adminAuthentService.createUser(auth);
    }

    @Override
    public List<MilestonePossibleOwnerDto> findAllAdminOrManager() {
        this.permissionEvaluationService.checkAtLeastOneMilestoneManagementPermissionOrAdmin();
        return this.userDao.findAllAdminOrManager();
    }

    @Override
    public User createAdministrator(User user, String password) throws LoginAlreadyExistsException, NotAllowedByLicenseException {
        this.licenseHelperService.assertLicenseAllowsToAddOrActivateUser();
        UsersGroup admin = this.groupDao.findByQualifiedName("squashtest.authz.group.core.Admin");
        user.normalize();
        this.addUser(user, admin.getId(), password);
        return user;
    }

    @Override
    public void checkLoginAvailability(String login) {
        boolean caseInsensitive = this.features.isEnabled(FeatureManager.Feature.CASE_INSENSITIVE_LOGIN);
        if (caseInsensitive && this.userDao.findUserByCiLogin(login) != null || !caseInsensitive && this.userDao.findUserByLogin(login) != null) {
            throw new LoginAlreadyExistsException("User " + login + " cannot be created because it already exists");
        }
    }

    @Override
    public List<String> findAllDuplicateLogins() {
        return ((Session)this.em.unwrap(Session.class)).getNamedQuery("User.findAllDuplicateLogins").list();
    }

    @Override
    public String findCaseAwareLogin(String login) {
        Query query = ((Session)this.em.unwrap(Session.class)).getNamedQuery("User.findCaseAwareLogin");
        query.setParameter("login", (Object)login);
        return (String)query.uniqueResult();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public int countAllActiveUsers() {
        return this.userDao.countAllActiveUsers();
    }

    @Override
    public void changeCanDeleteFromFront(List<Long> userIds, boolean canDeleteFromFront) {
        List users = this.userDao.findAllById(userIds);
        users.forEach(user -> user.setCanDeleteFromFront(canDeleteFromFront));
    }

    @Override
    public void changeCanDeleteFromFront(long userId, boolean canDeleteFromFront) {
        User user = (User)this.userDao.getReferenceById(userId);
        user.setCanDeleteFromFront(canDeleteFromFront);
    }

    @Override
    public String findLoginByUserId(long userId) {
        return this.userDao.findUserLoginById(userId);
    }

    @Override
    public String getDefaultAuthenticatedRedirectUrlForUserAuthority() {
        return this.isUserProgrammerButNotTester() ? AUTOMATION_WORKSPACE_URL : HOME_WORKSPACE_URL;
    }

    private boolean isUserProgrammerButNotTester() {
        DetailedUserDto currentUser = this.userDisplayService.findCurrentUser();
        return currentUser.isAutomationProgrammer() && !currentUser.isFunctionalTester();
    }
}

