/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.thirdpartyserver;

import javax.inject.Inject;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.servers.AuthenticationPolicy;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.service.internal.repository.ThirdPartyServerDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.ServerAuthConfiguration;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.thirdpartyserver.ThirdPartyServerCredentialsService;

@Service(value="ThirdPartyServerCredentialsService")
@Transactional
public class ThirdPartyServerCredentialsServiceImpl
implements ThirdPartyServerCredentialsService {
    @Inject
    private StoredCredentialsManager credentialsManager;
    @Inject
    private ThirdPartyServerDao thirdPartyServerDao;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public boolean isCredentialsServiceAvailable() {
        return this.credentialsManager.isSecretConfigured();
    }

    @Override
    public void storeCredentials(long serverId, ManageableCredentials credentials) {
        this.permissionEvaluationService.checkAtLeastOneProjectManagementPermissionOrAdmin();
        this.credentialsManager.storeAppLevelCredentials(serverId, credentials);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public ManageableCredentials findCredentials(long serverId) {
        return this.credentialsManager.findAppLevelCredentials(serverId);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteCredentials(long serverId) {
        this.credentialsManager.deleteAppLevelCredentials(serverId);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void storeAuthConfiguration(long serverId, ServerAuthConfiguration conf) {
        this.credentialsManager.storeServerAuthConfiguration(serverId, conf);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public ServerAuthConfiguration findAuthConfiguration(long serverId) {
        return this.credentialsManager.findServerAuthConfiguration(serverId);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteAuthConfiguration(long serverId) {
        this.credentialsManager.deleteServerAuthConfiguration(serverId);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeAuthenticationPolicy(long serverId, AuthenticationPolicy policy) {
        ThirdPartyServer tracker = (ThirdPartyServer)this.thirdPartyServerDao.getReferenceById(serverId);
        tracker.setAuthenticationPolicy(policy);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeAuthenticationProtocol(long serverId, AuthenticationProtocol protocol) {
        ThirdPartyServer tracker = (ThirdPartyServer)this.thirdPartyServerDao.getReferenceById(serverId);
        tracker.setAuthenticationProtocol(protocol);
        this.credentialsManager.deleteAppLevelCredentials(serverId);
        this.credentialsManager.deleteServerAuthConfiguration(serverId);
    }
}

