/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.testplanretriever;

import java.util.List;
import javax.inject.Inject;
import javax.persistence.NoResultException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.IterationTestPlanDao;
import org.squashtest.tm.service.internal.repository.TestSuiteDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;
import org.squashtest.tm.service.testautomation.model.AutomatedSuiteCreationSpecification;
import org.squashtest.tm.service.testautomation.testplanretriever.RestTestPlanFinder;
import org.squashtest.tm.service.testautomation.testplanretriever.exception.NoITPIFoundException;
import org.squashtest.tm.service.testautomation.testplanretriever.exception.NotFoundTargetUUIDException;
import org.squashtest.tm.service.user.UserAccountService;

@Service
@Transactional
public class RestTestPlanFinderImpl
implements RestTestPlanFinder {
    @Inject
    private IterationDao iterationDao;
    @Inject
    private TestSuiteDao testSuiteDao;
    @Inject
    private IterationTestPlanDao iterationTestPlanDao;
    @Inject
    private PermissionEvaluationService permissionService;
    @Inject
    private UserAccountService userAccountService;

    @Override
    public Iteration findIterationByUuid(String uuid) throws NotFoundTargetUUIDException {
        try {
            return this.iterationDao.findByUUID(uuid);
        }
        catch (NoResultException | EmptyResultDataAccessException throwable) {
            throw new NotFoundTargetUUIDException();
        }
    }

    @Override
    public TestSuite findTestSuiteByUuid(String uuid) throws NotFoundTargetUUIDException {
        try {
            return this.testSuiteDao.findByUUID(uuid);
        }
        catch (NoResultException | EmptyResultDataAccessException throwable) {
            throw new NotFoundTargetUUIDException();
        }
    }

    @Override
    public List<Long> getItemTestPlanIdsByIterationUuid(String uuid) throws NoITPIFoundException {
        List items = this.iterationTestPlanDao.getITPIsByIterationUUIDAndIsAutomated(uuid);
        if (items.isEmpty()) {
            throw new NoITPIFoundException();
        }
        return items;
    }

    @Override
    public List<Long> getItemTestPlanIdsByTestSuiteUuid(String uuid) throws NoITPIFoundException {
        List items = this.iterationTestPlanDao.getITPIsByTestSuiteUUIDAndIsAutomated(uuid);
        if (items.isEmpty()) {
            throw new NoITPIFoundException();
        }
        return items;
    }

    @Override
    public List<Long> getItemTestPlanIdsByIterationId(Long iterationId) {
        return this.iterationDao.findTestPlanIds(iterationId);
    }

    @Override
    public List<Long> getItemTestPlanIdsByTestSuiteId(Long testSuiteId) {
        return this.testSuiteDao.getTestPlanIds(testSuiteId);
    }

    @Override
    public List<Long> getItemTestPlanIdsFromSpecification(AutomatedSuiteCreationSpecification specification) {
        List<Long> itemTestPlanIds = specification.getTestPlanSubsetIds();
        boolean hasTestPlanSubset = itemTestPlanIds != null && !itemTestPlanIds.isEmpty();
        EntityType entityType = specification.getContext().getType();
        Long entityId = specification.getContext().getId();
        if (hasTestPlanSubset) {
            PermissionsUtils.checkPermission(this.permissionService, itemTestPlanIds, Permissions.EXECUTE.name(), IterationTestPlanItem.class.getName());
            return itemTestPlanIds;
        }
        return this.findItpiList(entityId, entityType);
    }

    private List<Long> findItpiList(Long entityId, EntityType entityType) {
        if (EntityType.ITERATION.equals((Object)entityType)) {
            return this.filterWithUserPermissionsOnItpi(entityId);
        }
        return this.iterationTestPlanDao.findAllByTestSuiteId(entityId);
    }

    private List<Long> filterWithUserPermissionsOnItpi(Long iterationId) {
        if (!this.currentUserCanReadUnassigned(iterationId)) {
            String login = this.userAccountService.findCurrentUser().getLogin();
            return this.iterationTestPlanDao.findAllByIterationIdAndLogin(iterationId, login);
        }
        return this.iterationTestPlanDao.findAllByIterationId(iterationId);
    }

    private boolean currentUserCanReadUnassigned(Long iterationId) {
        return this.permissionService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.READ_UNASSIGNED.name(), iterationId, "org.squashtest.tm.domain.campaign.Iteration");
    }
}

