/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.httpclient;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.opentestfactory.messages.Status;
import org.squashtest.tm.core.foundation.lang.UrlUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.service.internal.dto.WorkflowDto;
import org.squashtest.tm.service.internal.testautomation.codec.ObjectMapperFactory;
import org.squashtest.tm.service.internal.testautomation.httpclient.ClientRuntimeException;
import org.squashtest.tm.service.internal.testautomation.httpclient.MessageRefusedException;
import org.squashtest.tm.service.internal.testautomation.httpclient.RequestConfigurationFactory;
import org.squashtest.tm.service.internal.testautomation.httpclient.Response;
import org.squashtest.tm.service.internal.testautomation.httpclient.SquashAutomWorkflowClient;
import org.squashtest.tm.service.internal.testautomation.httpclient.UnexpectedServerResponseException;
import org.squashtest.tm.service.internal.testautomation.model.messages.ChannelStatus;
import org.squashtest.tm.service.internal.testautomation.model.messages.KillWorkflowStatus;
import org.squashtest.tm.service.internal.testautomation.model.messages.VersionStatus;
import org.squashtest.tm.service.internal.testautomation.model.messages.Workflow;
import org.squashtest.tm.service.internal.testautomation.model.messages.WorkflowData;
import org.squashtest.tm.service.internal.testautomation.model.messages.WorkflowHandle;
import org.squashtest.tm.service.internal.testautomation.model.messages.WorkflowsStatus;
import org.squashtest.tm.service.orchestrator.model.OrchestratorConfVersions;
import org.squashtest.tm.service.orchestrator.model.OrchestratorResponse;
import org.squashtest.tm.service.testautomation.model.AutomatedExecutionEnvironment;

public class SquashAutomWorkflowClientImpl
implements SquashAutomWorkflowClient,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SquashAutomWorkflowClientImpl.class);
    private static final int HTTP_ERROR_CODE = 400;
    private static final String PATH_TO_CHANNELS_ENDPOINT = "./channels";
    private static final String PATH_TO_WORKFLOWS_ENDPOINT = "./workflows";
    private static final String PATH_TO_VERSION_ENDPOINT = "./version";
    private static final String PATH_TO_LOGS_ENDPOINT = "/logs";
    private static final String GET_WORKFLOWS_PARAM = "?expand=manifest";
    private static final String NO_TOKEN_DEBUG_MESSAGE = "No authentication token, sending anonymously";
    private static final String GENERIC_REST_CALL_ERROR_MESSAGE = "Failed to manage REST call for technical reasons";
    private final String authToken;
    private final String receptionEndpoint;
    private final String observerEndpoint;
    private final String killSwitchEndpoint;
    private final int timeoutSeconds;

    public SquashAutomWorkflowClientImpl(String receptionEndpoint, String observerEndpoint, String killSwitchEndpoint, String authToken, int timeoutSeconds) {
        this.receptionEndpoint = receptionEndpoint;
        this.observerEndpoint = observerEndpoint;
        this.killSwitchEndpoint = killSwitchEndpoint;
        this.authToken = authToken;
        this.timeoutSeconds = timeoutSeconds;
    }

    @Override
    public List<AutomatedExecutionEnvironment> getAllAccessibleEnvironments(TestAutomationServer server) throws MessageRefusedException {
        ChannelStatus channelStatus = this.performJsonGetRestCall(this.buildChannelsUrl(), ChannelStatus.class);
        return channelStatus.getAutomatedExecutionEnvironments();
    }

    @Override
    public OrchestratorResponse<OrchestratorConfVersions> fetchOrchestratorConfVersions(TestAutomationServer server) throws MessageRefusedException, UnexpectedServerResponseException {
        VersionStatus versionStatus = this.performJsonGetRestCall(this.buildVersionUrl(), VersionStatus.class);
        return new OrchestratorResponse<OrchestratorConfVersions>(versionStatus.getOrchestratorConfigurations(), true);
    }

    @Override
    public OrchestratorResponse<List<WorkflowDto>> fetchProjectWorkflows(TestAutomationServer server, Long projectId) throws MessageRefusedException {
        WorkflowsStatus workflowsStatus = this.performJsonGetRestCall(this.buildWorkflowsUrl(), WorkflowsStatus.class);
        List<WorkflowDto> workflows = workflowsStatus.getProjectWorkflows(projectId.toString()).stream().map(WorkflowData::toWorkflowDto).toList();
        return new OrchestratorResponse<List<WorkflowDto>>(workflows, true);
    }

    @Override
    public OrchestratorResponse<String> fetchWorkflowLogs(String workflowId) throws MessageRefusedException {
        String logs = this.performStringGetRestCall(this.buildWorkflowLogsUrl(workflowId));
        return new OrchestratorResponse<String>(logs, true);
    }

    @Override
    public OrchestratorResponse<Void> killWorkflow(TestAutomationServer server, Long projectId, String workflowId) throws MessageRefusedException {
        try {
            KillWorkflowStatus response = this.performJsonDeleteCall(this.buildKillWorkflowUrl(workflowId), KillWorkflowStatus.class);
            if (response.getCode() == 200) {
                return new OrchestratorResponse<Void>(true);
            }
            LOGGER.error("Failed to kill workflow {} on project {} : {}", new Object[]{workflowId, projectId, response.getMessage()});
            return new OrchestratorResponse<Void>(false);
        }
        catch (MalformedURLException | ClientRuntimeException ex) {
            LOGGER.error("Failed to kill workflow {} on project {} : {}, check URL validity", new Object[]{workflowId, projectId, ex.getMessage()});
            return new OrchestratorResponse<Void>(false);
        }
    }

    private String buildWorkflowsUrl() {
        String baseUrl = StringUtils.isBlank((CharSequence)this.observerEndpoint) ? this.receptionEndpoint : this.observerEndpoint;
        return UrlUtils.appendPath((String)baseUrl, (String)"./workflows?expand=manifest").toExternalForm();
    }

    private String buildWorkflowLogsUrl(String workflowId) {
        String baseUrl = StringUtils.isBlank((CharSequence)this.observerEndpoint) ? this.receptionEndpoint : this.observerEndpoint;
        return UrlUtils.appendPath((String)baseUrl, (String)("./workflows/" + workflowId + PATH_TO_LOGS_ENDPOINT)).toExternalForm();
    }

    private String buildKillWorkflowUrl(String workflowId) throws MalformedURLException {
        if (!StringUtils.isBlank((CharSequence)this.killSwitchEndpoint)) {
            return UrlUtils.appendPath((String)this.killSwitchEndpoint, (String)("./workflows/" + workflowId)).toExternalForm();
        }
        String baseUrl = StringUtils.isBlank((CharSequence)this.observerEndpoint) ? this.receptionEndpoint : this.observerEndpoint;
        URL originalUrl = new URL(baseUrl);
        URL killSwitchUrl = new URL(originalUrl.getProtocol(), originalUrl.getHost(), 7776, originalUrl.getFile());
        LOGGER.warn("No KillSwitchUrl, using constructed default (BaseUrl: " + originalUrl + ", Port: " + 7776 + " => " + killSwitchUrl + ")", new Object[0]);
        return UrlUtils.appendPath((String)killSwitchUrl.toString(), (String)("./workflows/" + workflowId)).toExternalForm();
    }

    public String buildChannelsUrl() {
        String baseUrl = StringUtils.isBlank((CharSequence)this.observerEndpoint) ? this.receptionEndpoint : this.observerEndpoint;
        return UrlUtils.appendPath((String)baseUrl, (String)PATH_TO_CHANNELS_ENDPOINT).toExternalForm();
    }

    public String buildVersionUrl() {
        String baseUrl = StringUtils.isBlank((CharSequence)this.observerEndpoint) ? this.receptionEndpoint : this.observerEndpoint;
        return UrlUtils.appendPath((String)baseUrl, (String)PATH_TO_VERSION_ENDPOINT).toExternalForm();
    }

    private <T extends Status<?>> T performJsonPostRestCall(Workflow workflow, String endpoint, Class<T> responseType) throws MessageRefusedException {
        try {
            String payload = ObjectMapperFactory.getJsonObjectMapper().writeValueAsString((Object)workflow);
            HttpPost request = new HttpPost();
            request.setEntity((HttpEntity)new StringEntity(payload, ContentType.APPLICATION_JSON));
            return (T)((Status)this.performRequest((HttpRequestBase)request, endpoint, responseType));
        }
        catch (IOException ex) {
            throw new ClientRuntimeException(GENERIC_REST_CALL_ERROR_MESSAGE, ex, endpoint);
        }
    }

    private String performStringGetRestCall(String endpoint) throws MessageRefusedException, UnexpectedServerResponseException {
        HttpGet request = new HttpGet();
        return this.performRequest((HttpRequestBase)request, endpoint, String.class);
    }

    private <T extends Status<?>> T performJsonGetRestCall(String endpoint, Class<T> responseType) throws MessageRefusedException, UnexpectedServerResponseException {
        HttpGet request = new HttpGet();
        return (T)((Status)this.performRequest((HttpRequestBase)request, endpoint, responseType));
    }

    private <T extends Status<?>> T performJsonDeleteCall(String endpoint, Class<T> responseType) throws MessageRefusedException {
        HttpDelete request = new HttpDelete();
        return (T)((Status)this.performRequest((HttpRequestBase)request, endpoint, responseType));
    }

    /*
     * Loose catch block
     */
    private <T> T performRequest(HttpRequestBase request, String endpoint, Class<T> responseType) throws MessageRefusedException {
        try {
            URI uri = new URI(endpoint);
            request.setURI(uri);
            request.setConfig(new RequestConfigurationFactory().getRequestConfig(uri, this.timeoutSeconds));
            this.appendAuthorizationHeaderOrLogAnonymousMode((HttpMessage)request);
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                T t;
                CloseableHttpResponse closeableResponse;
                CloseableHttpClient client;
                block18: {
                    block17: {
                        client = HttpClients.createSystem();
                        closeableResponse = client.execute((HttpUriRequest)request);
                        Response response = new Response((HttpResponse)closeableResponse);
                        t = this.handleStatusResponse(response, uri, responseType);
                        if (closeableResponse == null) break block17;
                        closeableResponse.close();
                    }
                    if (client == null) break block18;
                    client.close();
                }
                return t;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (closeableResponse != null) {
                                closeableResponse.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (client != null) {
                                client.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | URISyntaxException ex) {
            throw new ClientRuntimeException(GENERIC_REST_CALL_ERROR_MESSAGE, ex, endpoint);
        }
    }

    @Override
    public WorkflowHandle launch(Workflow workflow) throws MessageRefusedException {
        String workflowsUrl = UrlUtils.appendPath((String)this.receptionEndpoint, (String)PATH_TO_WORKFLOWS_ENDPOINT).toExternalForm();
        return this.performJsonPostRestCall(workflow, workflowsUrl, WorkflowHandle.class);
    }

    private void appendAuthorizationHeaderOrLogAnonymousMode(HttpMessage request) {
        if (StringUtils.isEmpty((CharSequence)this.authToken)) {
            LOGGER.debug(NO_TOKEN_DEBUG_MESSAGE, new Object[0]);
        } else {
            request.addHeader((Header)new BasicHeader("Authorization", "Bearer " + this.authToken));
        }
    }

    private <T> T handleStatusResponse(Response response, URI endPoint, Class<T> responseClass) throws MessageRefusedException, IOException, UnexpectedServerResponseException {
        try {
            if (response.getStatusLine().getStatusCode() >= 400) {
                if (this.hasJsonMimeType(response)) {
                    throw new MessageRefusedException(endPoint, response.getStatusLine().getStatusCode());
                }
                throw new UnexpectedServerResponseException(endPoint, response.getStatusLine());
            }
            if (responseClass == String.class) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                return (T)string;
            }
            T t = this.readValueWithJsonObjectMapper(response, responseClass);
            return t;
        }
        finally {
            response.getEntity().getContent().close();
        }
    }

    private boolean hasJsonMimeType(Response resp) {
        String jsonMimeType = ContentType.APPLICATION_JSON.getMimeType();
        String actualMimeType = resp.mimeType();
        return jsonMimeType.equals(actualMimeType);
    }

    private <T> T readValueWithJsonObjectMapper(Response response, Class<T> responseClass) throws IOException {
        return (T)ObjectMapperFactory.getJsonObjectMapper().readValue(response.getEntity().getContent(), responseClass);
    }
}

