/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.httpclient;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.opentestfactory.messages.OTFMessage;
import org.squashtest.tm.core.foundation.lang.UrlUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.internal.testautomation.codec.ObjectMapperFactory;
import org.squashtest.tm.service.internal.testautomation.httpclient.ClientRuntimeException;
import org.squashtest.tm.service.internal.testautomation.httpclient.HttpPostRequest;
import org.squashtest.tm.service.internal.testautomation.httpclient.MessageRefusedException;
import org.squashtest.tm.service.internal.testautomation.httpclient.Request;
import org.squashtest.tm.service.internal.testautomation.httpclient.RequestConfigurationFactory;
import org.squashtest.tm.service.internal.testautomation.httpclient.Response;
import org.squashtest.tm.service.internal.testautomation.httpclient.SquashAutomBusClient;
import org.squashtest.tm.service.internal.testautomation.httpclient.UnexpectedServerResponseException;
import org.squashtest.tm.service.internal.testautomation.model.messages.PublicationStatus;

public class SquashAutomBusClientImpl
implements SquashAutomBusClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SquashAutomBusClientImpl.class);
    private static final String GENERIC_REST_CALL_ERROR_MESSAGE = "Failed to manage REST call for technical reasons";
    private final String busEndpoint;
    private final String authToken;
    private final int requestTimeoutSeconds;

    public SquashAutomBusClientImpl(String busEndpoint, String authToken, int requestTimeoutSeconds) {
        this.busEndpoint = busEndpoint;
        this.authToken = authToken;
        this.requestTimeoutSeconds = requestTimeoutSeconds;
    }

    @Override
    public PublicationStatus publish(OTFMessage event) throws MessageRefusedException {
        String publicationUrl = UrlUtils.appendPath((String)this.busEndpoint, (String)"./publications").toExternalForm();
        return this.performJsonRESTCall(event, publicationUrl);
    }

    protected PublicationStatus performJsonRESTCall(OTFMessage event, String endpoint) throws MessageRefusedException {
        try {
            URI methodURI = new URI(endpoint);
            Request request = this.createRequest(methodURI, event);
            if (StringUtils.isEmpty((CharSequence)this.authToken)) {
                LOGGER.debug("No authentication token, sending anonymously", new Object[0]);
            } else {
                request.addHeader((Header)new BasicHeader("Authorization", "Bearer " + this.authToken));
            }
            Response r = request.execute();
            return this.handleResponse(r, methodURI);
        }
        catch (IOException | URISyntaxException ex) {
            throw new ClientRuntimeException(GENERIC_REST_CALL_ERROR_MESSAGE, ex, endpoint);
        }
    }

    private Request createRequest(URI endpoint, OTFMessage event) throws JsonProcessingException {
        String payload = ObjectMapperFactory.getJsonObjectMapper().writeValueAsString((Object)event);
        HttpPost request = new HttpPost(endpoint);
        request.setConfig(new RequestConfigurationFactory().getRequestConfig(endpoint, this.requestTimeoutSeconds));
        request.setEntity((HttpEntity)new StringEntity(payload, ContentType.APPLICATION_JSON));
        return new HttpPostRequest(request);
    }

    private PublicationStatus handleResponse(Response resp, URI endPoint) throws IOException, MessageRefusedException {
        try {
            if (resp.getStatusLine().getStatusCode() >= 400) {
                if (this.sameMimeType(resp)) {
                    throw new MessageRefusedException(endPoint, resp.getStatusLine().getStatusCode());
                }
                throw new UnexpectedServerResponseException(endPoint, resp.getStatusLine());
            }
            PublicationStatus publicationStatus = (PublicationStatus)((Object)ObjectMapperFactory.getJsonObjectMapper().readValue(resp.getEntity().getContent(), PublicationStatus.class));
            return publicationStatus;
        }
        finally {
            resp.getEntity().getContent().close();
        }
    }

    private boolean sameMimeType(Response resp) {
        String refCtString = ContentType.APPLICATION_JSON.getMimeType();
        String actualCTString = resp.mimeType();
        return refCtString.equals(actualCTString);
    }
}

