/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.security;

import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.UnauthorizedPasswordChange;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.internal.security.AuthenticationProviderContext;
import org.squashtest.tm.service.internal.security.SquashUserDetailsManager;
import org.squashtest.tm.service.internal.security.UserBuilder;
import org.squashtest.tm.service.security.AdministratorAuthenticationService;

@Component(value="squashtest.core.security.AdministratorAuthenticationService")
public class AdministratorAuthenticationServiceImpl
implements AdministratorAuthenticationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdministratorAuthenticationServiceImpl.class);
    @Inject
    @Named(value="squashtest.core.security.JdbcUserDetailsManager")
    private SquashUserDetailsManager userManager;
    @Inject
    @Lazy
    private PasswordEncoder encoder;
    @Inject
    @Lazy
    private AuthenticationProviderContext authenticationProviderContext;

    public void setUserDetailsManager(SquashUserDetailsManager userManager) {
        this.userManager = userManager;
    }

    public void setPasswordEncoder(PasswordEncoder encoder) {
        this.encoder = encoder;
    }

    @Override
    public boolean canModifyUser() {
        return this.authenticationProviderContext.isInternalProviderEnabled();
    }

    @Override
    public void changeAuthenticatedUserPassword(String plainOldPassword, String clearNewPassword) {
        String encNewPasswd = this.encode(clearNewPassword);
        this.userManager.changePassword(plainOldPassword, encNewPasswd);
    }

    @Override
    public boolean hasAuthenticatedUserLocalPassword() {
        UserDetails user = this.userManager.loadUserByUsername(UserContextHolder.getUsername());
        return !StringUtils.isBlank((CharSequence)user.getPassword());
    }

    private String encode(String plainNewPassword) {
        return this.encoder.encode((CharSequence)plainNewPassword);
    }

    @Override
    public void createNewUserPassword(String login, String plainTextPassword, boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, Collection<GrantedAuthority> autorities) {
        String encodedPassword = this.encode(plainTextPassword);
        User user = new User(login, encodedPassword, enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, autorities);
        this.userManager.createUser((UserDetails)user);
    }

    @Override
    public void resetAuthenticatedUserPassword(String clearNewPassword) {
        String login = UserContextHolder.getUsername();
        this.resetUserPassword(login, clearNewPassword);
    }

    @Override
    public void resetUserPassword(String login, String clearNewPassword) {
        if (!this.canModifyUser()) {
            throw new UnauthorizedPasswordChange("The authentication service do not allow users to change their passwords using Squash");
        }
        UserDetails user = this.userManager.loadUserByUsername(login);
        String encodedPassword = this.encode(clearNewPassword);
        HashSet filteredAuthorities = new HashSet();
        User updateCommand = new User(login, encodedPassword, user.isEnabled(), true, true, true, filteredAuthorities);
        LOGGER.debug("reset password for user {}", new Object[]{login});
        this.userManager.updateUser((UserDetails)updateCommand);
    }

    @Override
    public void changeUserlogin(String newLogin, String oldLogin) {
        this.userManager.changeUserLogin(newLogin, oldLogin);
    }

    @Override
    public void deactivateAccount(String login) {
        if (this.userManager.userExists(login)) {
            UserDetails oldUser = this.userManager.loadUserByUsername(login);
            HashSet filteredAuthorities = new HashSet();
            User newUser = new User(login, oldUser.getPassword(), false, oldUser.isAccountNonExpired(), oldUser.isCredentialsNonExpired(), oldUser.isAccountNonLocked(), filteredAuthorities);
            LOGGER.debug("Deactivate account for user {}", new Object[]{login});
            this.userManager.updateUser((UserDetails)newUser);
        } else {
            LOGGER.trace("User {} has no authentidation data, it can't be deactivated", new Object[]{login});
        }
    }

    @Override
    public void activateAccount(String login) {
        if (this.userManager.userExists(login)) {
            UserDetails oldUser = this.userManager.loadUserByUsername(login);
            HashSet filteredAuthorities = new HashSet();
            User newUser = new User(login, oldUser.getPassword(), true, oldUser.isAccountNonExpired(), oldUser.isCredentialsNonExpired(), oldUser.isAccountNonLocked(), filteredAuthorities);
            LOGGER.debug("Activating account for user {}", new Object[]{login});
            this.userManager.updateUser((UserDetails)newUser);
        } else {
            LOGGER.trace("User {} has no authentidation data, it can't be activated", new Object[]{login});
        }
    }

    @Override
    public void deleteAccount(String login) {
        if (this.userManager.userExists(login)) {
            this.userManager.deleteUser(login);
        } else {
            LOGGER.trace("User {} has no authentidation data, it can't be deleted", new Object[]{login});
        }
    }

    @Override
    public boolean userExists(String login) {
        return this.userManager.userExists(login);
    }

    @Override
    public void createUser(UserDetails plaintextPasswordUser) {
        String encodedPassword = this.encode(plaintextPasswordUser.getPassword());
        UserDetails user = UserBuilder.duplicate(plaintextPasswordUser).password(encodedPassword).build();
        this.userManager.createUser(user);
    }
}

