/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.scmserver;

import com.google.common.net.PercentEscaper;
import java.io.IOException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.transaction.Transactional;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.core.scm.api.exception.ScmException;
import org.squashtest.tm.core.scm.api.exception.ScmNoCredentialsException;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.scm.ScmServer;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.exception.RequiredFieldException;
import org.squashtest.tm.exception.WrongStringSizeException;
import org.squashtest.tm.exception.scm.NameAndBranchAlreadyInUseException;
import org.squashtest.tm.service.internal.dto.ScmRepositoryDto;
import org.squashtest.tm.service.internal.repository.ScmRepositoryDao;
import org.squashtest.tm.service.internal.repository.ScmServerDao;
import org.squashtest.tm.service.internal.scmserver.ScmConnectorRegistry;
import org.squashtest.tm.service.scmserver.ScmRepositoryFilesystemService;
import org.squashtest.tm.service.scmserver.ScmRepositoryManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.service.spi.ScmConnector;

@Service
@Transactional
public class ScmRepositoryManagerServiceImpl
implements ScmRepositoryManagerService,
ApplicationListener<ApplicationReadyEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScmRepositoryManagerServiceImpl.class);
    @Inject
    private ScmConnectorRegistry scmRegistry;
    @Inject
    private ScmServerDao scmServerDao;
    @Inject
    private ScmRepositoryDao scmRepositoryDao;
    @Inject
    private CredentialsProvider credentialsProvider;
    @Inject
    private ScmRepositoryFilesystemService scmRepositoryFileSystemService;
    @Inject
    private MessageSource i18nHelper;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    @Named(value="squashtest.tm.service.ThreadPoolTaskScheduler")
    private TaskScheduler taskScheduler;
    @Value(value="${squash.path.local-git-repositories-folder:../git-repositories}")
    private String localGitRepositoriesFolder;

    private String getMessage(String i18nKey) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.i18nHelper.getMessage(i18nKey, null, locale);
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.taskScheduler.schedule(this::doCloneMissingLocalRepositories, Instant.now());
    }

    @Override
    public List<ScmRepository> findByScmServerOrderByPath(Long scmServerId) {
        this.permissionEvaluationService.checkAtLeastOneProjectManagementPermissionOrAdmin();
        return this.scmRepositoryDao.findByScmServerIdOrderByRepositoryPathAsc(scmServerId);
    }

    @Override
    public List<ScmRepository> findClonedByScmServerOrderByName(long scmServerId) {
        return this.scmRepositoryDao.findClonedByScmServerOrderByName(scmServerId);
    }

    @Override
    public Page<ScmRepository> findPagedScmRepositoriesByScmServer(Long scmServerId, Pageable pageable) {
        return this.scmRepositoryDao.findByScmServerId(scmServerId, pageable);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public ScmRepository createNewScmRepository(long scmServerId, @NotNull String name, @NotNull String branch, String workingFolderPath, boolean cloneRepository) throws IOException {
        String string = branch;
        String string2 = name;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)string2);
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$3$e2ae1e40((Object)string);
        name = name.trim();
        branch = branch.trim();
        if (workingFolderPath != null) {
            workingFolderPath = workingFolderPath.trim();
        }
        this.checkNameAndBranchAlreadyInuse(scmServerId, name, branch);
        ScmServer scmServer = (ScmServer)this.scmServerDao.getReferenceById(scmServerId);
        ScmRepository newScmRepository = new ScmRepository();
        newScmRepository.setName(name);
        newScmRepository.setWorkingBranch(branch);
        newScmRepository.setWorkingFolderPath(workingFolderPath);
        newScmRepository.setScmServer(scmServer);
        if (cloneRepository) {
            newScmRepository.setRepositoryPath(this.buildRepositoryPath(name, scmServer.getUrl()));
        } else {
            newScmRepository.setRepositoryPath("");
        }
        ScmRepository createdScmRepository = (ScmRepository)this.scmRepositoryDao.save(newScmRepository);
        if (cloneRepository) {
            this.initializeAndPrepareRepository(createdScmRepository);
        }
        return createdScmRepository;
    }

    private String buildRepositoryPath(String name, String serverUrl) {
        PercentEscaper percentEscaper = new PercentEscaper("", true);
        String urlWithoutProtocol = serverUrl.replaceFirst(".*://", "");
        String urlEncodedServerUrl = percentEscaper.escape(urlWithoutProtocol);
        int urlPortionLength = Math.min(urlEncodedServerUrl.length(), 200);
        String urlPortion = urlEncodedServerUrl.substring(0, urlPortionLength);
        String urlEncodedName = percentEscaper.escape(name);
        int namePortionLength = Math.min(urlEncodedName.length(), 50);
        String namePortion = urlEncodedName.substring(0, namePortionLength);
        String timestamp = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss").format(ZonedDateTime.now());
        return String.format("%s/%s/%s_%s", this.localGitRepositoriesFolder, urlPortion, namePortion, timestamp);
    }

    private void initializeAndPrepareRepository(ScmRepository scmRepository) throws IOException {
        Credentials credentials = this.checkAndReturnCredentials(scmRepository);
        ScmConnector connector = this.scmRegistry.createConnector(scmRepository);
        this.checkIfProtocolIsSupported(credentials, connector);
        connector.createRepository(credentials);
        connector.prepareRepository(credentials);
        this.scmRepositoryFileSystemService.createWorkingFolderIfAbsent(scmRepository);
    }

    private Credentials checkAndReturnCredentials(ScmRepository scmRepository) {
        ScmServer server = scmRepository.getScmServer();
        Optional<Credentials> maybeCredentials = this.credentialsProvider.getAppLevelCredentials((ThirdPartyServer)server);
        Supplier<ScmNoCredentialsException> throwIfNull = () -> {
            throw new ScmNoCredentialsException(String.format(this.getMessage("message.scmRepository.noCredentials"), scmRepository.getName()));
        };
        return maybeCredentials.orElseThrow(throwIfNull);
    }

    private void checkIfProtocolIsSupported(Credentials credentials, ScmConnector connector) {
        AuthenticationProtocol protocol = credentials.getImplementedProtocol();
        if (!connector.supports(protocol)) {
            throw new UnsupportedAuthenticationModeException(protocol.toString());
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public String updateBranch(long scmRepositoryId, String newBranch) throws IOException {
        this.checkFieldIsNotBlank(newBranch, "branch");
        this.checkFieldMaxSize(newBranch, "branch", 255);
        ScmRepository scmRepository = (ScmRepository)this.scmRepositoryDao.getReferenceById(scmRepositoryId);
        String formerBranch = scmRepository.getWorkingBranch();
        if (formerBranch.equals(newBranch)) {
            LOGGER.debug("Did not update the ScmRepository branch because the submitted branch is identical to the former one", new Object[0]);
            return formerBranch;
        }
        this.checkNameAndBranchAlreadyInuse(scmRepository.getScmServer().getId(), scmRepository.getName(), newBranch);
        scmRepository.setWorkingBranch(newBranch);
        this.scmRepositoryDao.save(scmRepository);
        this.prepareRepository(scmRepository);
        return newBranch;
    }

    private void prepareRepository(ScmRepository scmRepository) throws IOException {
        Credentials credentials = this.checkAndReturnCredentials(scmRepository);
        ScmConnector connector = this.scmRegistry.createConnector(scmRepository);
        this.checkIfProtocolIsSupported(credentials, connector);
        connector.prepareRepository(credentials);
        this.scmRepositoryFileSystemService.createWorkingFolderIfAbsent(scmRepository);
    }

    private void checkNameAndBranchAlreadyInuse(long scmServerId, String repositoryName, String newWorkingBranch) {
        if (this.scmRepositoryDao.isRepositoryNameAndBranchAlreadyInUse(scmServerId, repositoryName, newWorkingBranch)) {
            throw new NameAndBranchAlreadyInUseException("The name of the ScmRepository " + repositoryName + " and branch " + newWorkingBranch + " are already in use for scm server id " + scmServerId);
        }
    }

    private void checkFieldIsNotBlank(String fieldValue, String fieldName) {
        if (StringUtils.isEmpty((CharSequence)fieldValue.trim())) {
            throw new RequiredFieldException(fieldName);
        }
    }

    private void checkFieldMaxSize(String fieldValue, String fieldName, int maxSize) {
        if (fieldValue.length() > maxSize) {
            throw new WrongStringSizeException(fieldName, 0, maxSize);
        }
    }

    @Override
    public boolean isOneRepositoryBoundToProjectOrTestCase(Collection<Long> scmRepositoryIds) {
        this.permissionEvaluationService.checkAtLeastOneProjectManagementPermissionOrAdmin();
        return this.scmRepositoryDao.isOneRepositoryBoundToProjectOrTestCase(scmRepositoryIds);
    }

    @Override
    public List<ScmRepositoryDto> getAllDeclaredScmRepositories(Locale locale) {
        ArrayList<ScmRepositoryDto> repositories = new ArrayList<ScmRepositoryDto>(this.scmRepositoryDao.getAllDeclaredScmRepositories());
        repositories.add(0, new ScmRepositoryDto(0L, this.i18nHelper.getMessage("label.None", null, locale)));
        return repositories;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteScmRepositories(Collection<Long> scmRepositoriesIds) {
        this.scmRepositoryDao.releaseScmRepositoriesFromTestCases(scmRepositoriesIds);
        this.scmRepositoryDao.releaseScmRepositoriesFromProjects(scmRepositoriesIds);
        this.deleteLocalClones(scmRepositoriesIds);
        this.scmRepositoryDao.deleteByIds(scmRepositoriesIds);
    }

    private void deleteLocalClones(Collection<Long> scmRepositoriesIds) {
        List repositories = this.scmRepositoryDao.findAllById(scmRepositoriesIds);
        this.scmRepositoryFileSystemService.deleteLocalRepositories(repositories);
    }

    private void doCloneMissingLocalRepositories() {
        List allRepositories = this.scmRepositoryDao.findAll();
        allRepositories.forEach(repository -> {
            String repositoryPath = repository.getRepositoryPath();
            if (repositoryPath != null && !repositoryPath.isEmpty() && !this.scmRepositoryFileSystemService.checkLocalRepositoryExists(repositoryPath)) {
                try {
                    LOGGER.warn("The local clone of the repository " + repository.getName() + " from the SCM server " + repository.getScmServer().getFriendlyName() + " is missing at the specified path " + repository.getBaseRepositoryFolder() + ". About to create the local clone.", new Object[0]);
                    this.initializeAndPrepareRepository((ScmRepository)repository);
                }
                catch (IOException e) {
                    throw new ScmException("Error while cloning the repository " + repository.getName(), (Throwable)e);
                }
            }
        });
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void recloneScmRepository(long scmRepositoryId) {
        ScmRepository scmRepository = (ScmRepository)this.scmRepositoryDao.getReferenceById(scmRepositoryId);
        this.scmRepositoryFileSystemService.deleteLocalRepositories(List.of(scmRepository));
        this.taskScheduler.schedule(() -> this.doRecloneScmRepository(scmRepository), Instant.now());
    }

    private void doRecloneScmRepository(ScmRepository scmRepository) {
        try {
            this.initializeAndPrepareRepository(scmRepository);
        }
        catch (IOException e) {
            throw new ScmException("Error while cloning the repository " + scmRepository.getName(), (Throwable)e);
        }
    }
}

