/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate.loaders;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Stream;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.Subgraph;
import javax.persistence.TypedQuery;
import org.hibernate.jpa.QueryHints;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class EntityGraphQueryBuilder<T> {
    private static final String DELIMITER = ".";
    private final EntityManager entityManager;
    private final Class<T> entityType;
    private final String baseQuery;
    private final EntityGraph<T> entityGraph;
    private final Map<String, Subgraph<?>> subgraphs = new HashMap();

    public EntityGraphQueryBuilder(EntityManager entityManager, Class<T> entityType, String baseQuery) {
        this.entityManager = entityManager;
        this.entityType = entityType;
        this.baseQuery = baseQuery;
        this.entityGraph = entityManager.createEntityGraph(entityType);
    }

    public static String buildParentAttribute(String ... attributes) {
        return String.join((CharSequence)DELIMITER, attributes);
    }

    public EntityGraphQueryBuilder<T> addAttributeNodes(String ... attributeNodes) {
        this.entityGraph.addAttributeNodes(attributeNodes);
        return this;
    }

    public EntityGraphQueryBuilder<T> addSubGraph(String attributeName, String ... subGraphAttributes) {
        Subgraph subGraph = this.entityGraph.addSubgraph(attributeName);
        subGraph.addAttributeNodes(subGraphAttributes);
        this.subgraphs.put(attributeName, subGraph);
        return this;
    }

    public EntityGraphQueryBuilder<T> addSubGraph(String attributeName, Class<?> aClass, String ... subGraphAttributes) {
        Subgraph subGraph = this.entityGraph.addSubgraph(attributeName, aClass);
        subGraph.addAttributeNodes(subGraphAttributes);
        this.subgraphs.put(aClass.getSimpleName(), subGraph);
        return this;
    }

    public EntityGraphQueryBuilder<T> addSubgraphToSubgraph(String parentAttributeName, String attributeName, String ... subGraphAttributes) {
        Subgraph<?> parentSubgraph = this.subgraphs.get(parentAttributeName);
        if (parentSubgraph == null) {
            throw new IllegalArgumentException("Parent subgraph not found for: " + parentAttributeName);
        }
        Subgraph subGraph = parentSubgraph.addSubgraph(attributeName);
        subGraph.addAttributeNodes(subGraphAttributes);
        this.subgraphs.put(String.join((CharSequence)DELIMITER, parentAttributeName, attributeName), subGraph);
        return this;
    }

    public T execute(Map<String, Object> parameters) {
        TypedQuery<T> query = this.buildQuery(parameters);
        return (T)query.getSingleResult();
    }

    public List<T> executeList(Map<String, Object> parameters) {
        TypedQuery<T> query = this.buildQuery(parameters);
        return query.getResultList();
    }

    public List<T> executeDistinctList(Map<String, Object> parameters) {
        TypedQuery<T> query = this.buildDistinctQuery(parameters);
        return query.getResultList();
    }

    public Page<T> executePageable(Map<String, Object> parameters, Pageable pageable, String countQuery) {
        TypedQuery<T> query = pageable.getSort().isUnsorted() ? this.buildQuery(parameters) : this.buildSortedQuery(parameters, pageable.getSort());
        query.setFirstResult((int)pageable.getOffset());
        query.setMaxResults(pageable.getPageSize());
        List resultList = query.getResultList();
        TypedQuery typedCountQuery = this.entityManager.createQuery(countQuery, Long.class);
        if (parameters != null) {
            parameters.forEach((arg_0, arg_1) -> ((TypedQuery)typedCountQuery).setParameter(arg_0, arg_1));
        }
        long total = (Long)typedCountQuery.getSingleResult();
        return new PageImpl(resultList, pageable, total);
    }

    private TypedQuery<T> buildSortedQuery(Map<String, Object> parameters, Sort sort) {
        StringJoiner sortingJoiner = new StringJoiner(", ", " ORDER BY ", "");
        sort.forEach(order -> {
            String property = order.getProperty();
            String direction = order.isAscending() ? "ASC" : "DESC";
            sortingJoiner.add(String.valueOf(property) + " " + direction);
        });
        String sortedQuery = this.baseQuery.concat(sortingJoiner.toString());
        TypedQuery query = this.entityManager.createQuery(sortedQuery, this.entityType);
        query.setHint(QueryHints.HINT_FETCHGRAPH, this.entityGraph);
        if (parameters != null) {
            parameters.forEach((arg_0, arg_1) -> ((TypedQuery)query).setParameter(arg_0, arg_1));
        }
        return query;
    }

    public Stream<T> executeStream(Map<String, Object> parameters) {
        TypedQuery<T> query = this.buildQuery(parameters);
        return query.getResultStream();
    }

    private TypedQuery<T> buildQuery(Map<String, Object> parameters) {
        TypedQuery query = this.entityManager.createQuery(this.baseQuery, this.entityType);
        query.setHint(QueryHints.HINT_FETCHGRAPH, this.entityGraph);
        if (parameters != null) {
            parameters.forEach((arg_0, arg_1) -> ((TypedQuery)query).setParameter(arg_0, arg_1));
        }
        return query;
    }

    private TypedQuery<T> buildDistinctQuery(Map<String, Object> parameters) {
        TypedQuery<T> query = this.buildQuery(parameters);
        query.setHint("hibernate.query.passDistinctThrough", (Object)false);
        return query;
    }
}

