/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.IntegerType;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record1;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.users.QUser;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.MilestonePossibleOwnerDto;
import org.squashtest.tm.service.internal.repository.CustomUserDao;
import org.squashtest.tm.service.internal.repository.hibernate.SqLIdResultTransformer;

public class UserDaoImpl
implements CustomUserDao {
    private static final String FIND_ALL_ADMIN = "SELECT  member.PARTY_ID FROM  CORE_GROUP_MEMBER member inner join CORE_GROUP_AUTHORITY cga on cga.GROUP_ID=member.GROUP_ID WHERE cga.AUTHORITY = 'ROLE_ADMIN' ";
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private DSLContext dsl;

    @Override
    public List<MilestonePossibleOwnerDto> findAllAdminOrManager() {
        return this.dsl.selectDistinct((SelectField)Tables.CORE_USER.PARTY_ID.as("ID"), (SelectField)Tables.CORE_USER.LOGIN, (SelectField)Tables.CORE_USER.FIRST_NAME, (SelectField)Tables.CORE_USER.LAST_NAME).from((TableLike)Tables.CORE_USER).where(Tables.CORE_USER.PARTY_ID.in((Select)this.dsl.select((SelectField)Tables.CORE_GROUP_MEMBER.PARTY_ID).from((TableLike)Tables.CORE_GROUP_MEMBER).join((TableLike)Tables.CORE_GROUP_AUTHORITY).on(Tables.CORE_GROUP_MEMBER.GROUP_ID.eq((Field)Tables.CORE_GROUP_AUTHORITY.GROUP_ID)).where(Tables.CORE_GROUP_AUTHORITY.AUTHORITY.eq((Object)"ROLE_ADMIN")).union((Select)this.dsl.select((SelectField)Tables.CORE_USER.PARTY_ID).from((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).join((TableLike)Tables.CORE_USER).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.eq((Field)Tables.CORE_USER.PARTY_ID)).join((TableLike)Tables.ACL_GROUP_PERMISSION).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID.eq((Field)Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID)).where(Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK.eq((Object)Permissions.MANAGE_MILESTONE.getMask()))).union((Select)this.dsl.select((SelectField)Tables.CORE_TEAM_MEMBER.USER_ID).from((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).join((TableLike)Tables.CORE_TEAM).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.eq((Field)Tables.CORE_TEAM.PARTY_ID)).join((TableLike)Tables.CORE_TEAM_MEMBER).on(Tables.CORE_TEAM.PARTY_ID.eq((Field)Tables.CORE_TEAM_MEMBER.TEAM_ID)).join((TableLike)Tables.ACL_GROUP_PERMISSION).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID.eq((Field)Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID)).where(Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK.eq((Object)Permissions.MANAGE_MILESTONE.getMask()))))).fetchInto(MilestonePossibleOwnerDto.class);
    }

    @Override
    public List<User> findAllAdmin() {
        NativeQuery query = ((Session)this.entityManager.unwrap(Session.class)).createNativeQuery(FIND_ALL_ADMIN);
        query.setResultTransformer((ResultTransformer)new SqLIdResultTransformer());
        List ids = query.list();
        return ((JPAQuery)new JPAQueryFactory(this.entityManager).selectFrom((EntityPath)QUser.user).where((Predicate)QUser.user.id.in((Collection)ids))).fetch();
    }

    @Override
    public Long findUserId(String login) {
        return (Long)this.dsl.select((SelectField)Tables.CORE_USER.PARTY_ID).from((TableLike)Tables.CORE_USER).where(Tables.CORE_USER.LOGIN.eq((Object)login)).fetchOne((Field)Tables.CORE_USER.PARTY_ID);
    }

    @Override
    public int countAllActiveUsers() {
        Record1 count = (Record1)this.dsl.selectCount().from((TableLike)Tables.CORE_USER).where(Tables.CORE_USER.ACTIVE.isTrue()).fetchOne();
        return Objects.nonNull(count) ? (Integer)count.value1() : IntegerType.ZERO;
    }

    @Override
    public String findUserLoginById(long userId) {
        return (String)this.dsl.select((SelectField)Tables.CORE_USER.LOGIN).from((TableLike)Tables.CORE_USER).where(Tables.CORE_USER.PARTY_ID.eq((Object)userId)).fetchOneInto(String.class);
    }

    @Override
    public List<String> filterActiveUserLogins(Collection<String> logins) {
        return this.dsl.select((SelectField)Tables.CORE_USER.LOGIN).from((TableLike)Tables.CORE_USER).where(Tables.CORE_USER.LOGIN.in(logins).and(Tables.CORE_USER.ACTIVE.eq((Object)Boolean.TRUE))).fetchInto(String.class);
    }
}

