/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.squashtest.tm.domain.campaign.TestPlanStatistics;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStatusReport;
import org.squashtest.tm.service.internal.repository.CustomTestSuiteDao;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.EntityGraphQueryBuilder;
import org.squashtest.tm.service.statistics.CountOnEnum;

public class TestSuiteDaoImpl
implements CustomTestSuiteDao {
    private static final String TEST_SUITE_COUNT_STATUS = "TestSuite.countStatuses";
    private static final String TEST_SUITE_IDS = "testSuiteIds";
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public TestPlanStatistics getTestSuiteStatistics(long testSuiteId) {
        Query q = this.entityManager.createNamedQuery(TEST_SUITE_COUNT_STATUS);
        q.setParameter("id", (Object)testSuiteId);
        List result = q.getResultList();
        LinkedHashMap<ExecutionStatus, Integer> canonicalStatusMap = CountOnEnum.fromTuples(result, ExecutionStatus.class).getStatistics(ExecutionStatus::getCanonicalStatus, ExecutionStatus.getCanonicalStatusSet());
        return new TestPlanStatistics(canonicalStatusMap);
    }

    @Override
    public Map<Long, ExecutionStatusReport> getStatusReport(List<Long> ids) {
        HashMap<Long, ExecutionStatusReport> reportsMap = new HashMap<Long, ExecutionStatusReport>();
        Query query = this.entityManager.createNamedQuery("TestSuite.getReportsByIds");
        query.setParameter("ids", ids);
        List tuples = query.getResultList();
        if (tuples.isEmpty()) {
            ids.stream().forEach(id -> {
                ExecutionStatusReport executionStatusReport = reportsMap.put((Long)id, new ExecutionStatusReport());
            });
        } else {
            for (Object[] tuple : tuples) {
                Long testId = (Long)tuple[0];
                ExecutionStatus execution = (ExecutionStatus)tuple[1];
                Long count = (Long)tuple[2];
                ExecutionStatusReport report = reportsMap.computeIfAbsent(testId, k -> new ExecutionStatusReport());
                report.set(execution.getCanonicalStatus(), count.intValue());
            }
        }
        return reportsMap;
    }

    @Override
    public List<Long> findAllIdsByExecutionIds(List<Long> executionIds) {
        if (executionIds.isEmpty()) {
            return new ArrayList<Long>();
        }
        Query query = this.entityManager.createNamedQuery("TestSuite.findAllIdsByExecutionIds");
        query.setParameter("executionIds", executionIds);
        return query.getResultList();
    }

    @Override
    public List<TestSuite> findAllByIds(Collection<Long> suiteIds) {
        if (suiteIds.isEmpty()) {
            return new ArrayList<TestSuite>();
        }
        Query query = this.entityManager.createNamedQuery("TestSuite.findAllByIds");
        query.setParameter("suiteIds", suiteIds);
        return query.getResultList();
    }

    @Override
    public List<TestSuite> findTestSuitesWhereMilestoneIsNotLocked(Collection<Long> suiteIds) {
        if (suiteIds.isEmpty()) {
            return new ArrayList<TestSuite>();
        }
        Query query = this.entityManager.createNamedQuery("TestSuite.findTestSuitesWhereMilestoneIsNoteLocked");
        query.setParameter("suiteIds", suiteIds);
        return query.getResultList();
    }

    @Override
    public List<Long> findTestSuiteAttachmentListIds(Collection<Long> testSuiteIds) {
        if (!testSuiteIds.isEmpty()) {
            Query query = this.entityManager.createNamedQuery("TestSuite.findAllAttachmentLists");
            query.setParameter(TEST_SUITE_IDS, testSuiteIds);
            return query.getResultList();
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> findTestSuitesAutomatedSuiteIds(Collection<Long> testSuiteIds) {
        if (!testSuiteIds.isEmpty()) {
            Query query = this.entityManager.createNamedQuery("TestSuite.findTestSuitesAutomatedSuiteIds");
            query.setParameter(TEST_SUITE_IDS, testSuiteIds);
            return query.getResultList();
        }
        return Collections.emptyList();
    }

    @Override
    public void removeTestSuites(Collection<Long> testSuiteIds) {
        Query query = this.entityManager.createNamedQuery("TestSuite.removeAll");
        query.setParameter(TEST_SUITE_IDS, testSuiteIds);
        query.executeUpdate();
    }

    @Override
    public TestSuite findByUUID(String targetUUID) {
        return (TestSuite)this.entityManager.createQuery("SELECT ts FROM TestSuite ts WHERE ts.uuid = :uuid", TestSuite.class).setParameter("uuid", (Object)targetUUID).getSingleResult();
    }

    @Override
    public List<TestSuite> loadNodeForPaste(Collection<Long> testSuiteIds) {
        String testPlanSession = EntityGraphQueryBuilder.buildParentAttribute("testPlan", "exploratorySessionOverview");
        String testPlanSessionAttachmentList = EntityGraphQueryBuilder.buildParentAttribute(testPlanSession, "attachmentList");
        return new EntityGraphQueryBuilder<TestSuite>(this.entityManager, TestSuite.class, "SELECT DISTINCT ts FROM TestSuite ts WHERE ts.id IN :ids").addAttributeNodes("attachmentList", "testPlan").addSubGraph("attachmentList", "attachments").addSubgraphToSubgraph("attachmentList", "attachments", "content").addSubGraph("testPlan", "exploratorySessionOverview").addSubgraphToSubgraph("testPlan", "exploratorySessionOverview", "attachmentList").addSubgraphToSubgraph(testPlanSession, "attachmentList", "attachments").addSubgraphToSubgraph(testPlanSessionAttachmentList, "attachments", "content").executeDistinctList(Map.of("ids", testSuiteIds));
    }
}

