/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.PartyPreference;
import org.squashtest.tm.domain.users.preferences.CorePartyPreference;
import org.squashtest.tm.service.internal.repository.CustomPartyPreferenceDao;

public class PartyPreferenceDaoImpl
implements CustomPartyPreferenceDao {
    private static final String PARTY_ID = "partyId";
    @PersistenceContext
    EntityManager em;

    @Override
    public Map<String, String> findAllPreferencesForParty(Party party) {
        return this.findAllPreferencesForParty(party.getId());
    }

    @Override
    public Map<String, String> findAllPreferencesForParty(long partyId) {
        HashMap<String, String> result = new HashMap<String, String>();
        Query q = this.em.createNamedQuery("partyPreference.findAllForParty");
        q.setParameter(PARTY_ID, (Object)partyId);
        List prefs = q.getResultList();
        for (PartyPreference pref : prefs) {
            result.put(pref.getPreferenceKey(), pref.getPreferenceValue());
        }
        return result;
    }

    @Override
    public PartyPreference findByPartyAndPreferenceKey(Party party, String preferenceKey) {
        return this.findByPartyAndPreferenceKey(party.getId(), preferenceKey);
    }

    @Override
    public PartyPreference findByPartyAndPreferenceKey(long partyId, String preferenceKey) {
        PartyPreference preference;
        Query q = this.em.createNamedQuery("partyPreference.findByPartyAndKey");
        q.setParameter(PARTY_ID, (Object)partyId);
        q.setParameter("preferenceKey", (Object)preferenceKey);
        try {
            preference = (PartyPreference)q.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
        return preference;
    }

    @Override
    public void removeFavoriteDashboardPreferenceByPartyIdAndDashboardId(long partyId, String dashboardId) {
        List<String> preferenceKeys = Arrays.asList(CorePartyPreference.FAVORITE_DASHBOARD_CAMPAIGN.getPreferenceKey(), CorePartyPreference.FAVORITE_DASHBOARD_HOME.getPreferenceKey(), CorePartyPreference.FAVORITE_DASHBOARD_REQUIREMENT.getPreferenceKey(), CorePartyPreference.FAVORITE_DASHBOARD_TEST_CASE.getPreferenceKey());
        Query q = this.em.createNamedQuery("partyPreference.removeFavoriteDashboardByPartyId");
        q.setParameter(PARTY_ID, (Object)partyId);
        q.setParameter("preferenceKeys", preferenceKeys);
        q.setParameter("dashboardId", (Object)dashboardId);
        q.executeUpdate();
    }

    @Override
    public void removeFavoriteDashboardPreferenceByPreferenceKeyAndDashboardId(long partyId, String dashboardId, String preferenceKey) {
        Query q = this.em.createNamedQuery("partyPreference.removeFavoriteDashboardByPreferenceKey");
        q.setParameter(PARTY_ID, (Object)partyId);
        q.setParameter("preferenceKey", (Object)preferenceKey);
        q.setParameter("dashboardId", (Object)dashboardId);
        q.executeUpdate();
    }
}

