/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.SystemInfoListItemCode;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.CustomInfoListItemDao;

public class InfoListItemDaoImpl
implements CustomInfoListItemDao {
    private static final String ITEM_CODE = "itemCode";
    private static final String PROJECT_ID = "projectId";
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private DSLContext dslContext;

    @Override
    public boolean isCategoryConsistent(long projectId, String itemCode) {
        Query q = this.entityManager.createNamedQuery("infoListItem.foundCategoryInProject");
        q.setParameter(PROJECT_ID, (Object)projectId);
        q.setParameter(ITEM_CODE, (Object)itemCode);
        return (Long)q.getSingleResult() == 1L;
    }

    @Override
    public boolean isNatureConsistent(long projectId, String itemCode) {
        Query q = this.entityManager.createNamedQuery("infoListItem.foundNatureInProject");
        q.setParameter(PROJECT_ID, (Object)projectId);
        q.setParameter(ITEM_CODE, (Object)itemCode);
        return (Long)q.getSingleResult() == 1L;
    }

    @Override
    public Set<String> filterConsistentNatures(long projectId, Collection<String> itemCodes) {
        return this.dslContext.select((SelectField)Tables.INFO_LIST_ITEM.CODE).from((TableLike)Tables.PROJECT).innerJoin((TableLike)Tables.INFO_LIST_ITEM).on(Tables.PROJECT.TC_NATURES_LIST.eq((Field)Tables.INFO_LIST_ITEM.LIST_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId).and(Tables.INFO_LIST_ITEM.CODE.in(itemCodes))).groupBy(new GroupField[]{Tables.INFO_LIST_ITEM.CODE}).having(DSL.count((Field)Tables.INFO_LIST_ITEM.ITEM_ID).eq((Object)1)).fetchSet((Field)Tables.INFO_LIST_ITEM.CODE);
    }

    @Override
    public boolean isTypeConsistent(long projectId, String itemCode) {
        Query q = this.entityManager.createNamedQuery("infoListItem.foundTypeInProject");
        q.setParameter(PROJECT_ID, (Object)projectId);
        q.setParameter(ITEM_CODE, (Object)itemCode);
        return (Long)q.getSingleResult() == 1L;
    }

    @Override
    public Set<String> filterConsistentTypes(long projectId, Collection<String> itemCodes) {
        return this.dslContext.select((SelectField)Tables.INFO_LIST_ITEM.CODE).from((TableLike)Tables.PROJECT).innerJoin((TableLike)Tables.INFO_LIST_ITEM).on(Tables.PROJECT.TC_TYPES_LIST.eq((Field)Tables.INFO_LIST_ITEM.LIST_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId).and(Tables.INFO_LIST_ITEM.CODE.in(itemCodes))).groupBy(new GroupField[]{Tables.INFO_LIST_ITEM.CODE}).having(DSL.count((Field)Tables.INFO_LIST_ITEM.ITEM_ID).eq((Object)1)).fetchSet((Field)Tables.INFO_LIST_ITEM.CODE);
    }

    @Override
    public void unbindFromLibraryObjects(long infoListId) {
        InfoListItem defaultReqCat = this.findByCode(SystemInfoListItemCode.CAT_UNDEFINED.getCode());
        this.execUpdateQuery(infoListId, "infoList.setReqCatToDefault", defaultReqCat);
        InfoListItem defaultTcNat = this.findByCode(SystemInfoListItemCode.NAT_UNDEFINED.getCode());
        this.execUpdateQuery(infoListId, "infoList.setTcNatToDefault", defaultTcNat);
        InfoListItem defaultTcType = this.findByCode(SystemInfoListItemCode.TYP_UNDEFINED.getCode());
        this.execUpdateQuery(infoListId, "infoList.setTcTypeToDefault", defaultTcType);
    }

    private InfoListItem findByCode(String code) {
        return (InfoListItem)this.entityManager.createNamedQuery("InfoListItem.findByCode").setParameter("code", (Object)code).getSingleResult();
    }

    private void execUpdateQuery(long infoListId, String queryName, InfoListItem defaultParam) {
        Query query = this.entityManager.createNamedQuery(queryName);
        query.setParameter("default", (Object)defaultParam);
        query.setParameter("id", (Object)infoListId);
        query.executeUpdate();
    }

    @Override
    public boolean isUsed(long infoListItemId) {
        Query q = this.entityManager.createNamedQuery("infoListItem.isUsedInRequirements");
        q.setParameter("id", (Object)infoListItemId);
        Query q1 = this.entityManager.createNamedQuery("infoListItem.isUsedInTestCases");
        q1.setParameter("id", (Object)infoListItemId);
        return (Long)q.getSingleResult() > 0L || (Long)q1.getSingleResult() > 0L;
    }

    @Override
    public void removeInfoListItem(long infoListItemId, InfoListItem defaultItem) {
        this.execUpdateQuery(infoListItemId, "infoListItem.setReqCatToDefault", defaultItem);
        this.execUpdateQuery(infoListItemId, "infoListItem.setTcNatToDefault", defaultItem);
        this.execUpdateQuery(infoListItemId, "infoListItem.setTcTypeToDefault", defaultItem);
    }
}

