/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.TestCaseFolderDao;
import org.squashtest.tm.service.internal.repository.hibernate.ContainerIdNameStartParameterCallback;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.SetNodeContentParameter;
import org.squashtest.tm.service.internal.repository.hibernate.SetQueryParametersCallback;

@Repository
public class HibernateTestCaseFolderDao
extends HibernateEntityDao<TestCaseFolder>
implements TestCaseFolderDao {
    @Inject
    private DSLContext dsl;

    @Override
    public TestCaseFolder findByContent(TestCaseLibraryNode node) {
        SetNodeContentParameter callback = new SetNodeContentParameter((LibraryNode)node);
        return (TestCaseFolder)this.executeEntityNamedQuery("testCaseFolder.findByContent", callback);
    }

    @Override
    public List<String> findNamesInLibraryStartingWith(long libraryId, String nameStart) {
        ContainerIdNameStartParameterCallback newCallBack1 = new ContainerIdNameStartParameterCallback(libraryId, nameStart);
        return this.executeListNamedQuery("testCaseFolder.findNamesInLibraryStartingWith", newCallBack1);
    }

    @Override
    public List<Long> findAllTestCaseIdsFromFolderIds(List<Long> folderIds) {
        return this.dsl.selectDistinct((SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.TEST_CASE_FOLDER).on(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.TEST_CASE_FOLDER.TCLN_ID)).where(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(folderIds)).and(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.notIn((Select)this.dsl.select((SelectField)Tables.TEST_CASE_FOLDER.TCLN_ID).from((TableLike)Tables.TEST_CASE_FOLDER))).fetch((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID);
    }

    @Override
    public List<Long[]> findPairedContentForList(List<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        NativeQuery query = this.currentSession().createNativeQuery("select * from TCLN_RELATIONSHIP where ancestor_id in (:folderIds)");
        query.setParameterList("folderIds", ids, (Type)LongType.INSTANCE);
        query.addScalar("ancestor_id", (Type)LongType.INSTANCE);
        query.addScalar("descendant_id", (Type)LongType.INSTANCE);
        List result = query.list();
        return this.toArrayOfLong(result);
    }

    @Override
    public List<Long> findContentForList(List<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        NativeQuery query = this.currentSession().createNativeQuery("select * from TCLN_RELATIONSHIP where ancestor_id in (:folderIds)");
        query.setParameterList("folderIds", ids, (Type)LongType.INSTANCE);
        query.addScalar("descendant_id", (Type)LongType.INSTANCE);
        return query.list();
    }

    private List<Long[]> toArrayOfLong(List<Object[]> input) {
        ArrayList<Long[]> result = new ArrayList<Long[]>();
        for (Object[] pair : input) {
            Long[] newPair = new Long[]{(Long)pair[0], (Long)pair[1]};
            result.add(newPair);
        }
        return result;
    }

    @Override
    public TestCaseFolder findParentOf(final Long id) {
        SetQueryParametersCallback newCallBack = new SetQueryParametersCallback(){

            @Override
            public void setQueryParameters(Query query) {
                query.setParameter("contentId", (Object)id, (Type)LongType.INSTANCE);
            }
        };
        return (TestCaseFolder)this.executeEntityNamedQuery("testCaseFolder.findParentOf", newCallBack);
    }

    @Override
    public Map<Long, List<String>> findContentNamesByFolderIds(Collection<Long> folderIds) {
        return this.dsl.select((SelectField)Tables.TEST_CASE_FOLDER.TCLN_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME).from((TableLike)Tables.TEST_CASE_FOLDER).join((TableLike)Tables.TCLN_RELATIONSHIP).on(Tables.TEST_CASE_FOLDER.TCLN_ID.eq((Field)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TEST_CASE_FOLDER.TCLN_ID.in(folderIds)).fetchGroups((Field)Tables.TEST_CASE_FOLDER.TCLN_ID, (Field)Tables.TEST_CASE_LIBRARY_NODE.NAME);
    }

    @Override
    public TestCaseFolder loadForTestCaseAddition(Long folderId) {
        return (TestCaseFolder)this.entityManager.createQuery("select folder from TestCaseFolder folder\njoin fetch folder.project project\njoin fetch project.testCaseNatures\njoin fetch project.testCaseTypes\nleft join fetch folder.content\nwhere folder.id = :id", TestCaseFolder.class).setParameter("id", (Object)folderId).getSingleResult();
    }

    @Override
    public List<TestCaseFolder> loadForTestCaseAddition(List<Long> folderIds) {
        return this.entityManager.createQuery("select distinct folder from TestCaseFolder folder\njoin fetch folder.project project\njoin fetch project.testCaseNatures\njoin fetch project.testCaseTypes\nleft join fetch folder.content\nwhere folder.id in :ids", TestCaseFolder.class).setParameter("ids", folderIds).setHint("hibernate.query.passDistinctThrough", (Object)false).getResultList();
    }
}

