/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.jooq.BatchBindStep;
import org.jooq.DSLContext;
import org.jooq.DeleteConditionStep;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Query;
import org.jooq.Result;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UpdateConditionStep;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.records.CampaignTestPlanItemRecord;
import org.squashtest.tm.jooq.domain.tables.records.ItemTestPlanListRecord;
import org.squashtest.tm.jooq.domain.tables.records.TestSuiteTestPlanItemRecord;
import org.squashtest.tm.service.internal.repository.TestCaseDeletionDao;
import org.squashtest.tm.service.internal.repository.hibernate.AbstractHibernateDeletionDao;

@Repository
public class HibernateTestCaseDeletionDao
extends AbstractHibernateDeletionDao
implements TestCaseDeletionDao {
    private static final String TEST_CASES_IDS = "testCaseIds";
    private static final String AUTOMATION_REQUEST_IDS = "automationRequestIds";
    private static final String TEST_STEP_IDS = "testStepIds";
    private static final String FOLDER_IDS = "folderIds";
    private final DSLContext dslContext;

    public HibernateTestCaseDeletionDao(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public void removeEntities(List<Long> entityIds) {
        if (entityIds.isEmpty()) {
            return;
        }
        Session session = this.getSession();
        session.setJdbcBatchSize(Integer.valueOf(10000));
        this.removeEntityFromParentLibraryIfExists(entityIds, session);
        this.removeEntityFromParentFolderIfExists(entityIds, session);
        this.removeTestCases(entityIds);
        this.removeTestCaseLibraryNodes(entityIds);
        session.setJdbcBatchSize(null);
        session.flush();
        session.clear();
    }

    private void removeTestCaseLibraryNodes(List<Long> nodeIds) {
        List attachmentListIds = this.dslContext.select((SelectField)Tables.ATTACHMENT_LIST.ATTACHMENT_LIST_ID).from((TableLike)Tables.ATTACHMENT_LIST).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.ATTACHMENT_LIST_ID.eq((Field)Tables.ATTACHMENT_LIST.ATTACHMENT_LIST_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(nodeIds)).fetchInto(Long.class);
        this.dslContext.deleteFrom((Table)Tables.TCLN_RELATIONSHIP_CLOSURE).where(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(nodeIds)).execute();
        this.dslContext.deleteFrom((Table)Tables.TEST_CASE_LIBRARY_NODE).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(nodeIds)).execute();
        this.dslContext.deleteFrom((Table)Tables.ATTACHMENT).where(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.in((Collection)attachmentListIds)).execute();
        this.dslContext.deleteFrom((Table)Tables.ATTACHMENT_LIST).where(Tables.ATTACHMENT_LIST.ATTACHMENT_LIST_ID.in((Collection)attachmentListIds)).execute();
    }

    private void removeTestCases(List<Long> nodeIds) {
        this.dslContext.deleteFrom((Table)Tables.MILESTONE_TEST_CASE).where(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.in(nodeIds)).execute();
        this.dslContext.deleteFrom((Table)Tables.KEYWORD_TEST_CASE).where(Tables.KEYWORD_TEST_CASE.TCLN_ID.in(nodeIds)).execute();
        this.dslContext.deleteFrom((Table)Tables.EXPLORATORY_TEST_CASE).where(Tables.EXPLORATORY_TEST_CASE.TCLN_ID.in(nodeIds)).execute();
        this.dslContext.deleteFrom((Table)Tables.SCRIPTED_TEST_CASE).where(Tables.SCRIPTED_TEST_CASE.TCLN_ID.in(nodeIds)).execute();
        this.dslContext.deleteFrom((Table)Tables.TEST_CASE).where(Tables.TEST_CASE.TCLN_ID.in(nodeIds)).execute();
        this.dslContext.deleteFrom((Table)Tables.TEST_CASE_FOLDER).where(Tables.TEST_CASE_FOLDER.TCLN_ID.in(nodeIds)).execute();
    }

    private void removeEntityFromParentLibraryIfExists(List<Long> nodeIds, Session session) {
        Map nodesToDeleteByLibraryId = session.createQuery("select lib.id, lcontent from TestCaseLibrary lib join lib.rootContent lcontent where lcontent.id in :ids", Object[].class).setParameter("ids", nodeIds).getResultList().stream().collect(Collectors.groupingBy(result -> (Long)result[0], Collectors.mapping(result -> (TestCaseLibraryNode)result[1], Collectors.toList())));
        if (nodesToDeleteByLibraryId.isEmpty()) {
            return;
        }
        List libraries = session.createQuery("select lib from TestCaseLibrary lib join fetch lib.project join fetch lib.rootContent where lib.id in :ids", TestCaseLibrary.class).setParameter("ids", nodesToDeleteByLibraryId.keySet()).getResultList();
        for (TestCaseLibrary library : libraries) {
            List<TestCaseLibraryNode> nodes = nodesToDeleteByLibraryId.get(library.getId());
            nodes.forEach(arg_0 -> ((TestCaseLibrary)library).removeContent(arg_0));
        }
        session.flush();
        session.clear();
    }

    private void removeEntityFromParentFolderIfExists(List<Long> nodeIds, Session session) {
        Map nodesToDeleteByFolderId = session.createQuery("select fold.id, fcontent from TestCaseFolder as fold join fold.content fcontent where fcontent.id in :ids", Object[].class).setParameter("ids", nodeIds).getResultList().stream().collect(Collectors.groupingBy(result -> (Long)result[0], Collectors.mapping(result -> (TestCaseLibraryNode)result[1], Collectors.toList())));
        if (nodesToDeleteByFolderId.isEmpty()) {
            return;
        }
        List folders = session.createQuery("select folder from TestCaseFolder folder join fetch folder.content where folder.id in :ids", TestCaseFolder.class).setParameter("ids", nodesToDeleteByFolderId.keySet()).getResultList();
        for (TestCaseFolder folder : folders) {
            List<TestCaseLibraryNode> nodes = nodesToDeleteByFolderId.get(folder.getId());
            nodes.forEach(arg_0 -> ((TestCaseFolder)folder).removeContent(arg_0));
        }
        session.flush();
        session.clear();
    }

    @Override
    public void removeAutomationRequestLibraryContent(List<Long> automationRequestIds) {
        if (!automationRequestIds.isEmpty()) {
            this.executeUpdateSQLQuery("update TEST_CASE set AUTOMATION_REQUEST_ID = null where AUTOMATION_REQUEST_ID in (:automationRequestIds)", AUTOMATION_REQUEST_IDS, automationRequestIds);
            this.executeDeleteSQLQuery("delete from AUTOMATION_REQUEST_LIBRARY_CONTENT where content_id in (:automationRequestIds)", AUTOMATION_REQUEST_IDS, automationRequestIds);
            this.executeDeleteSQLQuery("delete from REMOTE_AUTOMATION_REQUEST_EXTENDER where AUTOMATION_REQUEST_ID in (:automationRequestIds)", AUTOMATION_REQUEST_IDS, automationRequestIds);
            this.executeDeleteSQLQuery("delete from AUTOMATION_REQUEST where AUTOMATION_REQUEST_ID in (:automationRequestIds)", AUTOMATION_REQUEST_IDS, automationRequestIds);
        }
    }

    @Override
    public void removeAllSteps(List<Long> testStepIds) {
        if (!testStepIds.isEmpty()) {
            this.executeDeleteSQLQuery("delete from TEST_CASE_STEPS where step_id in (:testStepIds)", TEST_STEP_IDS, testStepIds);
            this.executeDeleteSQLQuery("delete from ACTION_TEST_STEP where test_step_id in (:testStepIds)", TEST_STEP_IDS, testStepIds);
            this.executeDeleteSQLQuery("delete from CALL_TEST_STEP where test_step_id in (:testStepIds)", TEST_STEP_IDS, testStepIds);
            this.executeDeleteSQLQuery("delete from ACTION_WORD_PARAMETER_VALUE where keyword_test_step_id in (:testStepIds)", TEST_STEP_IDS, testStepIds);
            this.executeDeleteSQLQuery("delete from KEYWORD_TEST_STEP where test_step_id in (:testStepIds)", TEST_STEP_IDS, testStepIds);
            this.executeDeleteSQLQuery("delete from TEST_STEP where test_step_id in (:testStepIds)", TEST_STEP_IDS, testStepIds);
        }
    }

    @Override
    public List<Long> findTestSteps(List<Long> testCaseIds) {
        if (!testCaseIds.isEmpty()) {
            return this.executeSelectNamedQuery("testCase.findAllSteps", TEST_CASES_IDS, testCaseIds);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Long> findTestCaseAttachmentListIds(List<Long> testCaseIds) {
        if (!testCaseIds.isEmpty()) {
            return this.executeSelectNamedQuery("testCase.findAllAttachmentLists", TEST_CASES_IDS, testCaseIds);
        }
        return new ArrayList<Long>();
    }

    @Override
    public List<Long> findTestCaseFolderAttachmentListIds(List<Long> folderIds) {
        if (!folderIds.isEmpty()) {
            return this.executeSelectNamedQuery("testCaseFolder.findAllAttachmentLists", FOLDER_IDS, folderIds);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Long> findTestStepAttachmentListIds(List<Long> testStepIds) {
        if (!testStepIds.isEmpty()) {
            return this.executeSelectNamedQuery("testStep.findAllAttachmentLists", TEST_STEP_IDS, testStepIds);
        }
        return Collections.emptyList();
    }

    @Override
    public void removeCampaignTestPlanInboundReferences(List<Long> testCasesToRemove) {
        if (testCasesToRemove.isEmpty()) {
            return;
        }
        Map<Long, Result<CampaignTestPlanItemRecord>> itemsToReorderByCampaignId = this.fetchCampaignItemsToReorder(testCasesToRemove);
        this.deleteAffectedCampaignItems(testCasesToRemove);
        this.batchInsertReorderedCampaignItems(itemsToReorderByCampaignId);
    }

    private Map<Long, Result<CampaignTestPlanItemRecord>> fetchCampaignItemsToReorder(List<Long> testCasesToRemove) {
        List affectedCampaignIds = this.dslContext.select((SelectField)Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID).from((TableLike)Tables.CAMPAIGN_TEST_PLAN_ITEM).where(Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID.in(testCasesToRemove)).fetchInto(Long.class);
        List itemIdsToRemove = this.dslContext.select((SelectField)Tables.CAMPAIGN_TEST_PLAN_ITEM.CTPI_ID).from((TableLike)Tables.CAMPAIGN_TEST_PLAN_ITEM).where(Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID.in(testCasesToRemove)).fetchInto(Long.class);
        if (!affectedCampaignIds.isEmpty()) {
            SelectConditionStep query = this.dslContext.selectFrom((TableLike)Tables.CAMPAIGN_TEST_PLAN_ITEM).where(Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID.in((Collection)affectedCampaignIds));
            if (!itemIdsToRemove.isEmpty()) {
                query = query.and(Tables.CAMPAIGN_TEST_PLAN_ITEM.CTPI_ID.notIn((Collection)itemIdsToRemove));
            }
            return query.orderBy((OrderField)Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_PLAN_ORDER).fetchGroups((Field)Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID);
        }
        return new HashMap<Long, Result<CampaignTestPlanItemRecord>>();
    }

    private void deleteAffectedCampaignItems(List<Long> testCasesToRemove) {
        List affectedCampaignIds = this.dslContext.select((SelectField)Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID).from((TableLike)Tables.CAMPAIGN_TEST_PLAN_ITEM).where(Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID.in(testCasesToRemove)).fetchInto(Long.class);
        if (!affectedCampaignIds.isEmpty()) {
            this.executeWithinHibernateSession((Query)this.dslContext.delete((Table)Tables.CAMPAIGN_TEST_PLAN_ITEM).where(Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID.in((Collection)affectedCampaignIds)));
        }
    }

    private void batchInsertReorderedCampaignItems(Map<Long, Result<CampaignTestPlanItemRecord>> groupedItemsToReorder) {
        groupedItemsToReorder.values().forEach(records -> IntStream.range(0, records.size()).forEach(position -> {
            CampaignTestPlanItemRecord record = (CampaignTestPlanItemRecord)records.get(position);
            record.setTestPlanOrder(Integer.valueOf(position));
            record.changed(true);
        }));
        this.dslContext.batchInsert(groupedItemsToReorder.values().stream().flatMap(Collection::stream).toList()).execute();
    }

    @Override
    public void removeOrSetIterationTestPlanInboundReferencesToNull(List<Long> testCasesToRemove) {
        if (testCasesToRemove.isEmpty()) {
            return;
        }
        Set<Long> iterationTestPlanItemsWithoutExecution = this.findIterationTestPlanItemsWithoutExecution(testCasesToRemove);
        if (!iterationTestPlanItemsWithoutExecution.isEmpty()) {
            Set<Long> iterationIds = this.findIterationsToReorder(iterationTestPlanItemsWithoutExecution);
            Set<Long> testSuiteIds = this.findTestSuiteToReorder(iterationTestPlanItemsWithoutExecution);
            this.deleteSessionOverview(iterationTestPlanItemsWithoutExecution);
            this.deleteItemTestPlanList(iterationTestPlanItemsWithoutExecution);
            this.deleteTestSuiteTestPlanItem(iterationTestPlanItemsWithoutExecution);
            this.deleteIterationTestPlanItems(iterationTestPlanItemsWithoutExecution);
            this.reorderIterations(iterationIds);
            this.reorderTestSuites(testSuiteIds);
        }
        this.nullifyReferencedTestCase(testCasesToRemove);
    }

    private void reorderTestSuites(Set<Long> testSuiteIds) {
        if (!testSuiteIds.isEmpty()) {
            this.doReorderTestSuites(testSuiteIds);
        }
    }

    private void doReorderTestSuites(Set<Long> testSuiteIds) {
        Collection<Result<TestSuiteTestPlanItemRecord>> itemGroups = this.fetchTestSuiteTestPlanItemsToReorder(testSuiteIds);
        this.deleteRemainingTestSuiteTestPlanItem(testSuiteIds);
        this.batchReorderTestSuiteTestPlanItems(itemGroups);
    }

    private void batchReorderTestSuiteTestPlanItems(Collection<Result<TestSuiteTestPlanItemRecord>> itemGroups) {
        if (!itemGroups.isEmpty()) {
            this.doBatchReorderTestSuiteTestPlanItems(itemGroups);
        }
    }

    private void doBatchReorderTestSuiteTestPlanItems(Collection<Result<TestSuiteTestPlanItemRecord>> itemGroups) {
        BatchBindStep batch = this.dslContext.batch((Query)this.dslContext.insertInto((Table)Tables.TEST_SUITE_TEST_PLAN_ITEM, (Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID, (Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID, (Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.TEST_PLAN_ORDER).values(null, null, null));
        itemGroups.forEach(itemGroup -> IntStream.range(0, itemGroup.size()).forEach(position -> {
            TestSuiteTestPlanItemRecord record = (TestSuiteTestPlanItemRecord)itemGroup.get(position);
            batch.bind(new Object[]{record.getSuiteId(), record.getTpiId(), position});
        }));
        batch.execute();
    }

    private void deleteRemainingTestSuiteTestPlanItem(Set<Long> testSuiteIds) {
        DeleteConditionStep deleteQuery = this.dslContext.deleteFrom((Table)Tables.TEST_SUITE_TEST_PLAN_ITEM).where(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.in(testSuiteIds));
        this.executeWithinHibernateSession((Query)deleteQuery);
    }

    private Collection<Result<TestSuiteTestPlanItemRecord>> fetchTestSuiteTestPlanItemsToReorder(Set<Long> testSuiteIds) {
        return this.dslContext.selectFrom((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).where(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.in(testSuiteIds)).orderBy((OrderField)Tables.TEST_SUITE_TEST_PLAN_ITEM.TEST_PLAN_ORDER).fetchGroups((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID).values();
    }

    private void reorderIterations(Set<Long> iterationIds) {
        if (!iterationIds.isEmpty()) {
            this.doReorderIterations(iterationIds);
        }
    }

    private void doReorderIterations(Set<Long> iterationIds) {
        Collection<Result<ItemTestPlanListRecord>> itemGroups = this.fetchIterationTestPlanItemsToReorder(iterationIds);
        this.deleteRemainingItemTestPlanList(iterationIds);
        this.batchReorderIterationTestPlanItems(itemGroups);
    }

    private void batchReorderIterationTestPlanItems(Collection<Result<ItemTestPlanListRecord>> itemGroups) {
        if (!itemGroups.isEmpty()) {
            this.doBatchReorderIterationTestPlanItems(itemGroups);
        }
    }

    private void doBatchReorderIterationTestPlanItems(Collection<Result<ItemTestPlanListRecord>> itemGroups) {
        BatchBindStep batch = this.dslContext.batch((Query)this.dslContext.insertInto((Table)Tables.ITEM_TEST_PLAN_LIST, (Field)Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID, (Field)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID, (Field)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ORDER).values(null, null, null));
        itemGroups.forEach(itemGroup -> IntStream.range(0, itemGroup.size()).forEach(position -> {
            ItemTestPlanListRecord record = (ItemTestPlanListRecord)itemGroup.get(position);
            batch.bind(new Object[]{record.getIterationId(), record.getItemTestPlanId(), position});
        }));
        batch.execute();
    }

    private void deleteRemainingItemTestPlanList(Set<Long> iterationIds) {
        if (!iterationIds.isEmpty()) {
            DeleteConditionStep deleteQuery = this.dslContext.deleteFrom((Table)Tables.ITEM_TEST_PLAN_LIST).where(Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID.in(iterationIds));
            this.executeWithinHibernateSession((Query)deleteQuery);
        }
    }

    private void deleteIterationTestPlanItems(Set<Long> iterationTestPlanItemIds) {
        if (!iterationTestPlanItemIds.isEmpty()) {
            DeleteConditionStep deleteQuery = this.dslContext.deleteFrom((Table)Tables.ITERATION_TEST_PLAN_ITEM).where(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.in(iterationTestPlanItemIds));
            this.executeWithinHibernateSession((Query)deleteQuery);
        }
    }

    private void deleteTestSuiteTestPlanItem(Set<Long> iterationTestPlanItemIds) {
        DeleteConditionStep deleteQuery = this.dslContext.deleteFrom((Table)Tables.TEST_SUITE_TEST_PLAN_ITEM).where(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.in(iterationTestPlanItemIds));
        this.executeWithinHibernateSession((Query)deleteQuery);
    }

    private void deleteItemTestPlanList(Set<Long> iterationTestPlanItemIds) {
        DeleteConditionStep deleteQuery = this.dslContext.deleteFrom((Table)Tables.ITEM_TEST_PLAN_LIST).where(Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID.in(iterationTestPlanItemIds));
        this.executeWithinHibernateSession((Query)deleteQuery);
    }

    private void deleteSessionOverview(Set<Long> iterationTestPlanItemIds) {
        DeleteConditionStep deleteQuery = this.dslContext.deleteFrom((Table)Tables.EXPLORATORY_SESSION_OVERVIEW).where(Tables.EXPLORATORY_SESSION_OVERVIEW.ITEM_TEST_PLAN_ID.in(iterationTestPlanItemIds));
        this.executeWithinHibernateSession((Query)deleteQuery);
    }

    private Set<Long> findTestSuiteToReorder(Set<Long> iterationTestPlanItemsWithoutExecution) {
        return this.dslContext.selectDistinct((SelectField)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID).from((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).where(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.in(iterationTestPlanItemsWithoutExecution)).fetchSet((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID);
    }

    private Set<Long> findIterationsToReorder(Set<Long> iterationTestPlanItemsWithoutExecution) {
        return this.dslContext.selectDistinct((SelectField)Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID).from((TableLike)Tables.ITEM_TEST_PLAN_LIST).where(Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID.in(iterationTestPlanItemsWithoutExecution)).fetchSet((Field)Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID);
    }

    private Set<Long> findIterationTestPlanItemsWithoutExecution(List<Long> testCaseIds) {
        return this.dslContext.select((SelectField)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID).from((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).leftJoin((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID)).where(Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.isNull()).and(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.in(testCaseIds)).fetchSet((Field)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID);
    }

    private Collection<Result<ItemTestPlanListRecord>> fetchIterationTestPlanItemsToReorder(Set<Long> iterationIds) {
        return this.dslContext.selectFrom((TableLike)Tables.ITEM_TEST_PLAN_LIST).where(Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID.in(iterationIds)).orderBy((OrderField)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ORDER).fetchGroups((Field)Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID).values();
    }

    private void nullifyReferencedTestCase(List<Long> testCasesToRemove) {
        UpdateConditionStep nullifyQuery = this.dslContext.update((Table)Tables.ITERATION_TEST_PLAN_ITEM).set((Field)Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID, null).set((Field)Tables.ITERATION_TEST_PLAN_ITEM.DATASET_ID, null).where(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.in(testCasesToRemove));
        NativeQuery nativeQuery = this.getSession().createNativeQuery(nullifyQuery.getSQL());
        List bindValues = nullifyQuery.getBindValues();
        nativeQuery.setParameter(1, null, (Type)LongType.INSTANCE);
        nativeQuery.setParameter(2, null, (Type)LongType.INSTANCE);
        int i = 2;
        while (i < bindValues.size()) {
            nativeQuery.setParameter(i + 1, bindValues.get(i));
            ++i;
        }
        nativeQuery.executeUpdate();
    }

    private void executeWithinHibernateSession(Query jooqQuery) {
        NativeQuery nativeQuery = this.getSession().createNativeQuery(jooqQuery.getSQL());
        List bindValues = jooqQuery.getBindValues();
        int i = 0;
        while (i < bindValues.size()) {
            nativeQuery.setParameter(i + 1, bindValues.get(i));
            ++i;
        }
        nativeQuery.executeUpdate();
    }

    @Override
    public void setExecStepInboundReferencesToNull(List<Long> testStepIds) {
        if (!testStepIds.isEmpty()) {
            NativeQuery query = this.getSession().createNativeQuery("update EXECUTION_STEP set test_step_id = null where test_step_id in (:testStepIds)");
            query.setParameterList(TEST_STEP_IDS, testStepIds, (Type)LongType.INSTANCE);
            query.executeUpdate();
        }
    }

    @Override
    public void setExecutionInboundReferencesToNull(List<Long> testCaseIds) {
        if (!testCaseIds.isEmpty()) {
            NativeQuery query = this.getSession().createNativeQuery("update EXECUTION set tcln_id = null where tcln_id in (:testCaseIds)");
            query.setParameterList(TEST_CASES_IDS, testCaseIds, (Type)LongType.INSTANCE);
            query.executeUpdate();
        }
    }

    @Override
    public void removeFromVerifyingTestCaseLists(List<Long> testCaseIds) {
        if (!testCaseIds.isEmpty()) {
            NativeQuery query = this.getSession().createNativeQuery("delete from REQUIREMENT_VERSION_COVERAGE where verifying_test_case_id in (:testCaseIds)");
            query.setParameterList(TEST_CASES_IDS, testCaseIds, (Type)LongType.INSTANCE);
            query.executeUpdate();
        }
    }

    @Override
    public void removeFromVerifyingTestStepsList(List<Long> testStepIds) {
        if (!testStepIds.isEmpty()) {
            NativeQuery query = this.getSession().createNativeQuery("delete from VERIFYING_STEPS where TEST_STEP_ID in (:testStepIds)");
            query.setParameterList(TEST_STEP_IDS, testStepIds, (Type)LongType.INSTANCE);
            query.executeUpdate();
        }
    }

    @Override
    public List<Long>[] separateFolderFromTestCaseIds(List<Long> originalIds) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        ArrayList<Long> testcaseIds = new ArrayList<Long>();
        List filtredFolderIds = this.executeSelectSQLQuery("select folder.tcln_id from TEST_CASE_FOLDER folder where folder.tcln_id in (:testcaseIds)", "testcaseIds", originalIds);
        for (Long oId : originalIds) {
            if (filtredFolderIds.contains(BigInteger.valueOf(oId))) {
                folderIds.add(oId);
                continue;
            }
            testcaseIds.add(oId);
        }
        List[] result = new List[]{folderIds, testcaseIds};
        return result;
    }

    @Override
    public List<Long> findRemainingTestCaseIds(List<Long> originalIds) {
        List rawids = this.executeSelectSQLQuery("select TCLN_ID from TEST_CASE where TCLN_ID in (:allTestCaseIds)", "allTestCaseIds", originalIds);
        ArrayList<Long> tcIds = new ArrayList<Long>(rawids.size());
        for (BigInteger rid : rawids) {
            tcIds.add(rid.longValue());
        }
        return tcIds;
    }

    @Override
    public void unbindFromMilestone(List<Long> testCaseIds, Long milestoneId) {
        if (!testCaseIds.isEmpty()) {
            NativeQuery query = this.getSession().createNativeQuery("delete from MILESTONE_TEST_CASE where MILESTONE_ID = :milestoneId and TEST_CASE_ID in (:testCaseIds)");
            query.setParameterList(TEST_CASES_IDS, testCaseIds, (Type)LongType.INSTANCE);
            query.setParameter("milestoneId", (Object)milestoneId);
            query.executeUpdate();
        }
    }

    @Override
    public List<Long> findTestCasesWhichMilestonesForbidsDeletion(List<Long> originalId) {
        if (!originalId.isEmpty()) {
            Object[] blockingStatuses = new MilestoneStatus[MilestoneStatus.MILESTONE_BLOCKING_STATUSES.size()];
            MilestoneStatus.MILESTONE_BLOCKING_STATUSES.toArray(blockingStatuses);
            org.hibernate.query.Query query = this.getSession().getNamedQuery("testCase.findTestCasesWhichMilestonesForbidsDeletion");
            query.setParameterList(TEST_CASES_IDS, originalId, (Type)LongType.INSTANCE);
            query.setParameterList("lockedStatuses", blockingStatuses);
            return query.list();
        }
        return new ArrayList<Long>();
    }
}

