/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.jooq.DSLContext;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.squashtest.tm.domain.environmenttag.AutomationEnvironmentTagHolder;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.AutomationEnvironmentTag;
import org.squashtest.tm.service.internal.repository.CustomGenericProjectDao;

public class GenericProjectDaoImpl
implements CustomGenericProjectDao {
    @PersistenceContext
    private EntityManager em;
    @Inject
    private DSLContext dslContext;

    @Override
    public ProjectTemplate coerceProjectIntoTemplate(long projectId) {
        Session session = this.getCurrentSession();
        Project project = (Project)session.load(Project.class, (Serializable)Long.valueOf(projectId));
        session.flush();
        session.evict((Object)project);
        NativeQuery query = session.createNativeQuery("update PROJECT set PROJECT_TYPE = 'T',  TEMPLATE_ID = null where PROJECT_ID = :id");
        query.setParameter("id", (Object)projectId);
        int changedRows = query.executeUpdate();
        if (changedRows != 1) {
            throw new HibernateException("Expected 1 changed row but got " + changedRows + " instead");
        }
        session.flush();
        return (ProjectTemplate)session.load(ProjectTemplate.class, (Serializable)Long.valueOf(projectId));
    }

    @Override
    public boolean isProjectTemplate(long projectId) {
        Query query = this.em.createNamedQuery("GenericProject.findProjectTypeOf");
        query.setParameter("projectId", (Object)projectId);
        String type = (String)query.getSingleResult();
        return "T".equals(type);
    }

    @Override
    public boolean isBoundToATemplate(long genericProjectId) {
        Query query = this.em.createNamedQuery("GenericProject.findBoundTemplateId");
        query.setParameter("projectId", (Object)genericProjectId);
        List templateIdss = query.getResultList();
        return !templateIdss.isEmpty();
    }

    @Override
    public boolean oneIsBoundToABoundProject(Collection<Long> bindingIds) {
        Query query = this.em.createNamedQuery("GenericProject.findBoundTemplateIdsFromBindingIds");
        query.setParameter("bindingIds", bindingIds);
        List templateIds = query.getResultList();
        return !templateIds.isEmpty();
    }

    @Override
    public GenericProject getProjectWithBugtrackerProjects(long projectId) {
        return (GenericProject)this.em.createQuery("select p from GenericProject p left join fetch p.bugtrackerProjects where p.id = :projectId group by p", GenericProject.class).setParameter("projectId", (Object)projectId).getSingleResult();
    }

    @Override
    public List<String> getEnvironmentTags(long genericProjectId) {
        return this.dslContext.select((SelectField)AutomationEnvironmentTag.AUTOMATION_ENVIRONMENT_TAG.VALUE).from((TableLike)AutomationEnvironmentTag.AUTOMATION_ENVIRONMENT_TAG).where(AutomationEnvironmentTag.AUTOMATION_ENVIRONMENT_TAG.ENTITY_TYPE.eq((Object)AutomationEnvironmentTagHolder.PROJECT.name()).and(AutomationEnvironmentTag.AUTOMATION_ENVIRONMENT_TAG.ENTITY_ID.eq((Object)genericProjectId))).fetchInto(String.class);
    }

    @Override
    public boolean isInheritsEnvironmentTags(long genericProjectId) {
        return this.dslContext.select((SelectField)Tables.PROJECT.INHERITS_ENVIRONMENT_TAGS).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_ID.eq((Object)genericProjectId)).fetchOptional().map(inheritsEnvironmentTags -> (Boolean)inheritsEnvironmentTags.into(Boolean.class)).orElse(false);
    }

    private Session getCurrentSession() {
        return (Session)this.em.unwrap(Session.class);
    }
}

