/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.TclnRelationshipClosure;
import org.squashtest.tm.service.internal.repository.display.EntityPathHeaderDao;

@Repository
public class EntityPathHeaderDaoImpl
implements EntityPathHeaderDao {
    private static final String PATH_SEPARATOR = " > ";
    private static final String PROJECT_NAME = "PROJECT_NAME";
    private static final String NODE_NAME = "NODE_NAME";
    private static final String DEPTH = "DEPTH";
    private static final String PATH_TABLE = "PATH_TABLE";
    private static final String PATH = "PATH";
    private static final String TCLN_ID = "TCLN_ID";
    private static final String PROJECT_ID = "PROJECT_ID";
    private static final String FULL_PATH = "PROJECT_ID";
    @Inject
    private DSLContext dslContext;

    @Override
    public String buildRequirementLibraryNodePathHeader(Long nodeId) {
        Table nodeTable = this.dslContext.select((SelectField)Tables.PROJECT.NAME.as(PROJECT_NAME), (SelectField)Tables.RESOURCE.NAME.as(NODE_NAME), (SelectField)Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.as(DEPTH)).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).leftJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID)).leftJoin((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).on(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).leftJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).leftJoin((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.REQUIREMENT_FOLDER.RLN_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).leftJoin((TableLike)Tables.RESOURCE).on(Tables.RESOURCE.RES_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RES_ID).or(Tables.RESOURCE.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID))).where(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID).and(Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Object)nodeId)).and(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.notEqual((Object)nodeId))).asTable();
        return this.buildPathHeader(nodeId, nodeTable, Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID);
    }

    @Override
    public String buildTestCaseLibraryNodePathHeader(Long nodeId) {
        Table nodeTable = this.dslContext.select((SelectField)Tables.PROJECT.NAME.as(PROJECT_NAME), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME.as(NODE_NAME), (SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH.as(DEPTH)).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).leftJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).leftJoin((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID)).and(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Object)nodeId)).and(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.notEqual((Object)nodeId)).asTable();
        return this.buildPathHeader(nodeId, nodeTable, Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID);
    }

    @Override
    public String buildCampaignLibraryNodePathHeader(Long nodeId) {
        Table nodeTable = this.dslContext.select((SelectField)Tables.PROJECT.NAME.as(PROJECT_NAME), (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME.as(NODE_NAME), (SelectField)Tables.CLN_RELATIONSHIP_CLOSURE.DEPTH.as(DEPTH)).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).leftJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID)).leftJoin((TableLike)Tables.CLN_RELATIONSHIP_CLOSURE).on(Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID).and(Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Object)nodeId)).and(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.notEqual((Object)nodeId))).asTable();
        return this.buildPathHeader(nodeId, nodeTable, Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID);
    }

    @Override
    public String buildIterationPathHeader(Long iterationId) {
        Long campaignId = (Long)this.dslContext.select((SelectField)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID).from((TableLike)Tables.CAMPAIGN_ITERATION).where(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Object)iterationId)).fetchOneInto(Long.class);
        return (String)this.dslContext.select(this.concatPathFromParent(this.buildCampaignLibraryNodePathHeader(campaignId), Tables.CAMPAIGN_LIBRARY_NODE.NAME)).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).where(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Object)campaignId)).fetchOneInto(String.class);
    }

    @Override
    public String buildTestSuitePathHeader(Long testSuiteId) {
        Long iterationId = (Long)this.dslContext.select((SelectField)Tables.ITERATION_TEST_SUITE.ITERATION_ID).from((TableLike)Tables.ITERATION_TEST_SUITE).where(Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID.eq((Object)testSuiteId)).fetchOneInto(Long.class);
        return this.buildIterationChildPath(iterationId);
    }

    @Override
    public String buildExecutionPathHeader(Long executionId) {
        if (this.executionIsInsideSprint(executionId)) {
            Long sprintId = this.getSprintIdForExecutionId(executionId);
            return this.buildSprintChildPathHeader(sprintId);
        }
        List<Long> testSuiteParentIds = this.getTestSuiteParentIdsForExecution(executionId);
        if (testSuiteParentIds.size() == 1) {
            return this.buildTestSuiteChildPathHeader(testSuiteParentIds);
        }
        Long iterationId = this.getIterationIdForExecutionId(executionId);
        return this.buildIterationChildPath(iterationId);
    }

    private boolean executionIsInsideSprint(Long executionId) {
        Long testPlanItemId = (Long)this.dslContext.select((SelectField)Tables.EXECUTION.TEST_PLAN_ITEM_ID).from((TableLike)Tables.EXECUTION).where(Tables.EXECUTION.EXECUTION_ID.eq((Object)executionId)).fetchOneInto(Long.class);
        return Objects.nonNull(testPlanItemId);
    }

    private Long getSprintIdForExecutionId(Long executionId) {
        return (Long)this.dslContext.select((SelectField)Tables.SPRINT.CLN_ID).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).innerJoin((TableLike)Tables.SPRINT).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).where(Tables.EXECUTION.EXECUTION_ID.eq((Object)executionId)).fetchOneInto(Long.class);
    }

    private List<Long> getTestSuiteParentIdsForExecution(Long executionId) {
        return this.dslContext.select((SelectField)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID).from((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).innerJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID)).where(Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID.eq((Object)executionId)).fetchInto(Long.class);
    }

    private Long getIterationIdForExecutionId(Long executionId) {
        return (Long)this.dslContext.select((SelectField)Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID).from((TableLike)Tables.ITEM_TEST_PLAN_LIST).innerJoin((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).on(Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID)).where(Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID.eq((Object)executionId)).fetchOneInto(Long.class);
    }

    private String buildTestSuiteChildPathHeader(List<Long> testSuiteParentIds) {
        return (String)this.dslContext.select(this.concatPathFromParent(this.buildTestSuitePathHeader(testSuiteParentIds.get(0)), Tables.TEST_SUITE.NAME)).from((TableLike)Tables.TEST_SUITE).where(Tables.TEST_SUITE.ID.eq((Object)testSuiteParentIds.get(0))).fetchOneInto(String.class);
    }

    @Override
    public String buildExploratorySessionOverviewPathHeader(Long sessionOverviewId) {
        Long iterationId = (Long)this.dslContext.select((SelectField)Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID).from((TableLike)Tables.ITEM_TEST_PLAN_LIST).join((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.EXPLORATORY_SESSION_OVERVIEW.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID)).where(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Object)sessionOverviewId)).fetchOneInto(Long.class);
        if (iterationId != null) {
            return this.buildIterationChildPath(iterationId);
        }
        Long clnId = (Long)this.dslContext.select((SelectField)Tables.SPRINT_REQ_VERSION.SPRINT_ID).from((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXPLORATORY_SESSION_OVERVIEW.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).join((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).where(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Object)sessionOverviewId)).fetchOneInto(Long.class);
        return this.buildSprintChildPathHeader(clnId);
    }

    private String buildSprintChildPathHeader(Long clnId) {
        return (String)this.dslContext.select(this.concatPathFromParent(this.buildCampaignLibraryNodePathHeader(clnId), Tables.CAMPAIGN_LIBRARY_NODE.NAME)).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).where(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Object)clnId)).fetchOneInto(String.class);
    }

    private Field<String> concatPathFromParent(String parentPath, TableField<?, String> parentField) {
        return DSL.concat((Field[])new Field[]{DSL.value((String)parentPath), DSL.value((String)PATH_SEPARATOR), parentField});
    }

    private String buildIterationChildPath(Long iterationId) {
        return (String)this.dslContext.select(this.concatPathFromParent(this.buildIterationPathHeader(iterationId), Tables.ITERATION.NAME)).from((TableLike)Tables.ITERATION).where(Tables.ITERATION.ITERATION_ID.eq((Object)iterationId)).fetchOneInto(String.class);
    }

    private String buildPathHeader(Long nodeId, Table<?> nodeTable, TableField<?, Long> entityFieldId, TableField<?, Long> entityFieldProjectId) {
        String path = this.buildPathFromNodeTable(nodeTable);
        if (Objects.nonNull(path)) {
            return path;
        }
        return this.getDefaultProjectPath(entityFieldId, entityFieldProjectId, nodeId);
    }

    private String buildPathFromNodeTable(Table<?> nodeTable) {
        return (String)this.dslContext.select((SelectField)DSL.concat((Field[])new Field[]{nodeTable.field(PROJECT_NAME), DSL.value((String)PATH_SEPARATOR), DSL.groupConcat((Field)nodeTable.field(NODE_NAME)).orderBy(new OrderField[]{nodeTable.field(DEPTH).desc()}).separator(PATH_SEPARATOR)})).from(nodeTable).groupBy(new GroupField[]{nodeTable.field(PROJECT_NAME)}).fetchOneInto(String.class);
    }

    private String getDefaultProjectPath(TableField<?, Long> entityFieldId, TableField<?, Long> entityFieldProjectId, Long entityId) {
        return (String)this.dslContext.select((SelectField)Tables.PROJECT.NAME).from((TableLike)entityFieldId.getTable()).leftJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq(entityFieldProjectId)).where(entityFieldId.eq((Object)entityId)).fetchOneInto(String.class);
    }

    @Override
    public Map<Long, String> buildTestCasePathByIds(Collection<Long> testCaseIds) {
        return this.buildTestCasePathByIds(testCaseIds, PATH_SEPARATOR);
    }

    @Override
    public Map<Long, String> buildTestCasePathByIds(Collection<Long> testCaseIds, String separator) {
        short zero = 0;
        TclnRelationshipClosure descendant = Tables.TCLN_RELATIONSHIP_CLOSURE.as("descendant");
        Table path = DSL.select((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.NAME, (SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, (SelectField)DSL.groupConcat((Field)Tables.TEST_CASE_LIBRARY_NODE.NAME).orderBy(new OrderField[]{Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH.desc()}).separator(separator).as(PATH)).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).innerJoin((TableLike)descendant).on(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)descendant.ANCESTOR_ID)).leftJoin((TableLike)Tables.TEST_CASE_FOLDER).on(descendant.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_FOLDER.TCLN_ID).and(Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH.ne((Object)zero))).where(Tables.TEST_CASE_FOLDER.TCLN_ID.isNull()).groupBy(new GroupField[]{Tables.PROJECT.PROJECT_ID, Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID}).asTable(PATH_TABLE, new String[]{"PROJECT_ID", PROJECT_NAME, TCLN_ID, PATH});
        return this.dslContext.select((SelectField)path.field(TCLN_ID), (SelectField)DSL.concat((Field[])new Field[]{path.field(PROJECT_NAME), DSL.value((String)separator), path.field(PATH), DSL.when((Condition)Tables.TEST_CASE_FOLDER.TCLN_ID.isNotNull(), (Field)DSL.value((String)separator)).otherwise((Object)"")}).as("PROJECT_ID")).from((TableLike)path).leftJoin((TableLike)Tables.TEST_CASE_FOLDER).on(path.field(TCLN_ID, Long.class).eq((Field)Tables.TEST_CASE_FOLDER.TCLN_ID)).where(path.field(TCLN_ID, Long.class).in(testCaseIds)).fetchMap(DSL.field((String)TCLN_ID, Long.class), DSL.field((String)"PROJECT_ID", String.class));
    }
}

